import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
import * as sageWhProductData from '..';
export declare class Container extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly containerType: Reference<sageWhProductData.nodes.ContainersType>;
    readonly containerLevel: Promise<sageWhMasterData.enums.ContainerLevel>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly height: Promise<decimal>;
    readonly width: Promise<decimal>;
    readonly depth: Promise<decimal>;
    readonly volume: Promise<decimal | null>;
    readonly parcelRangeShippedAsIsStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
    readonly parcelTypeShippedAsIsStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
    readonly parcelRangeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
    readonly parcelTypeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
    readonly shippingUnitDispatchableAsIs: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
    readonly isShippingUnitPalettizableAsIs: Promise<boolean>;
    readonly maximumQuantityAllowedInInputOutput: Promise<integer | null>;
    readonly palletBaseHeight: Promise<decimal | null>;
    readonly palletBaseGrossWeight: Promise<decimal | null>;
    readonly isActive: Promise<boolean>;
    readonly containerManagementType: Promise<sageWhMasterData.enums.ContainerManagementType>;
    readonly unitWeight: Promise<decimal | null>;
    readonly unitVolume: Promise<decimal | null>;
}
//# sourceMappingURL=container.d.ts.map