"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocationExtension = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageWhProductData = require("..");
const joins = {
    referenceJoins: {
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
        container: {
            site: 'site',
            code: 'container',
        },
        source: {
            site: 'site',
            depositor: 'depositor',
            code: 'source',
        },
        referenceContainer: {
            site: 'site',
            code: 'referenceContainer',
        },
        presentContainer: {
            site: 'site',
            code: 'presentContainer',
        },
        superiorContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'superiorContainer',
        },
    },
};
let LocationExtension = class LocationExtension extends xtrem_core_1.NodeExtension {
};
exports.LocationExtension = LocationExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], LocationExtension.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNGCTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Container,
        lookupAccess: true,
    })
], LocationExtension.prototype, "container", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORI',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Origin,
        lookupAccess: true,
    })
], LocationExtension.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REFCTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Container,
        lookupAccess: true,
    })
], LocationExtension.prototype, "referenceContainer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Container,
        lookupAccess: true,
    })
], LocationExtension.prototype, "presentContainer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CTRSUP',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], LocationExtension.prototype, "superiorContainer", void 0);
exports.LocationExtension = LocationExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageWhMasterData.nodes.Location,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], LocationExtension);
//# sourceMappingURL=location-extension.js.map