export interface ConsumptionUnit {
    _id: string;
    code: string;
    numberOfConsumptionUnit: number;
    numberOfDecimals?: number;
    stockUnit?: string;
}
export interface ContainerOfProduct {
    _id: string;
    containerLevel: string;
    container: {
        _id: string;
        code: string;
        containerManagementType: string;
    };
}
export interface ContainerUnit extends ContainerOfProduct, ConsumptionUnit {
    homogeneousLevel: string;
    containerLevel: string;
    inferiorContainer?: ContainerOfProduct;
    isKeyInSupportNumbers: boolean;
}
export type ContainerUnits = ContainerUnit[];
export interface ContainerProductUnit extends Omit<ContainerUnit, 'code' | 'numberOfConsumptionUnit' | 'numberOfDecimals' | 'stockUnit'> {
    numberOfConsumptionUnit: string;
}
export interface ContainerUnitAndOptions {
    containerUnit: ContainerUnit | undefined;
    containerOptions: string[];
}
export interface FifoManagementErrorMessages {
    manufacturedDateError?: string;
    detentionDateError?: string;
    sellByDateError: string;
    useByDateError: string;
    shipByDateError: string;
    fifoDateError?: string;
}
export interface MovementPlan {
    inputContainerCode: string | undefined;
    homogeneousContainerCode: string | undefined;
    numberOfContainers: number;
    numberOfHomogeneousContainers: number;
}
export interface ProductConfiguration {
    code: string;
    localizedDescription: string;
    isSerialNumberInInputAllowed: boolean;
    isSerialNumberInOutputAllowed: boolean;
    isLocalizedSerialNumberAllowed: boolean;
    isKeyInControlCode: boolean;
    isKeyInLotNumber: boolean;
    isStockUnitManagement: boolean;
    stockUnitCode?: string;
    numberOfDecimals?: number;
    defaultContainerCode: string;
    defaultContainerLevel: string;
    fifoDateNature: string;
    detentionLength: number;
    detentionUnit: string;
    useByDateLength: number;
    useByDateUnit: string;
    sendByDateLength: number;
    sendByDateUnit: string;
    sellByDateLength: number;
    sellByDateUnit: string;
}
//# sourceMappingURL=environnement.d.ts.map