"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProductConfiguration = getProductConfiguration;
const storage_properties_1 = require("@sage/wh-master-data/lib/client-functions/storage-properties");
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
/**
 *  Get the product configuration
 * @param pageInstance
 * @param siteCode
 * @param depositorCode
 * @param productCode
 * @param numberOfRecords
 * @returns
 */
async function getProductConfiguration(pageInstance, productCode) {
    const _siteDepositor = (0, storage_properties_1.getSelectedSiteDepositor)(pageInstance);
    const _siteCode = _siteDepositor?.site;
    const _depositorCode = _siteDepositor?.depositor;
    if (_siteCode && _depositorCode && productCode) {
        try {
            const _result = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
                .node('@sage/wh-product-data/Product')
                .query(ui.queryUtils.edgesSelector({
                code: true,
                localizedDescription: true,
                isKeyInSerialNumber: true,
                isKeyInControlCode: true,
                isKeyInLotNumber: true,
                isStockUnitManagement: true,
                fifoDateNature: true,
                detentionLength: true,
                detentionUnit: true,
                useByDateLength: true,
                useByDateUnit: true,
                sendByDateLength: true,
                sendByDateUnit: true,
                sellByDateLength: true,
                sellByDateUnit: true,
                inputMode: {
                    isKeyInSerialNumber: true,
                },
                outputMode: {
                    isSerialNumberInInputAllowed: true,
                    isSerialNumberInOutputAllowed: true,
                    isLocalizedSerialNumberAllowed: true,
                },
                stockUnit: {
                    code: true,
                    numberOfDecimals: true,
                },
                depositor: {
                    isStoringListControlCode: true,
                },
                defaultContainer: {
                    container: { code: true, containerLevel: true },
                },
            }, {
                filter: {
                    site: {
                        code: _siteCode,
                    },
                    depositor: {
                        code: _depositorCode,
                    },
                    code: productCode,
                    isActive: true,
                },
            }))
                .execute())[0];
            if (_result) {
                // The configuration is returned with some calculated values
                return {
                    code: _result.code,
                    localizedDescription: _result.localizedDescription,
                    isKeyInControlCode: _result.isKeyInControlCode && _result.depositor.isStoringListControlCode,
                    isSerialNumberInInputAllowed: _result.isKeyInSerialNumber && _result.inputMode.isKeyInSerialNumber,
                    isSerialNumberInOutputAllowed: _result.isKeyInSerialNumber && _result.outputMode.isSerialNumberInOutputAllowed,
                    isLocalizedSerialNumberAllowed: _result.isKeyInSerialNumber && _result.outputMode.isLocalizedSerialNumberAllowed,
                    defaultContainerCode: _result.defaultContainer?.container?.code,
                    defaultContainerLevel: _result.defaultContainer?.container?.containerLevel,
                    isKeyInLotNumber: _result.isKeyInLotNumber,
                    isStockUnitManagement: _result.isStockUnitManagement,
                    stockUnitCode: _result.stockUnit?.code,
                    numberOfDecimals: _result.stockUnit?.numberOfDecimals,
                    fifoDateNature: _result.fifoDateNature,
                    detentionLength: _result.detentionLength,
                    detentionUnit: _result.detentionUnit,
                    useByDateLength: _result.useByDateLength,
                    useByDateUnit: _result.useByDateUnit,
                    sendByDateLength: _result.sendByDateLength,
                    sendByDateUnit: _result.sendByDateUnit,
                    sellByDateLength: _result.sellByDateLength,
                    sellByDateUnit: _result.sellByDateUnit,
                };
            }
        }
        catch (error) {
            ui.console.error(`Error reading product configuration :\n${JSON.stringify(error)}`);
        }
    }
    return undefined;
}
//# sourceMappingURL=get-product-configuration.js.map