import * as ui from '@sage/xtrem-ui';
import { FifoManagementErrorMessages, ProductConfiguration } from '../interfaces/environnement';
export declare class FifoManagement {
    private _manufacturedDate;
    private _detentionDate;
    private _sellByDate;
    private _useByDate;
    private _shipByDate;
    private _fifoDate;
    private _errorMessages;
    private _productConfiguration;
    constructor(_manufacturedDate: ui.fields.Date, _detentionDate: ui.fields.Date, _sellByDate: ui.fields.Date, _useByDate: ui.fields.Date, _shipByDate: ui.fields.Date, _fifoDate: ui.fields.Date, _errorMessages: FifoManagementErrorMessages);
    Initialize(_productConfiguration: ProductConfiguration | undefined): void;
    onChangeManufacturedDate(pageInstance: ui.Page): Promise<void>;
    onChangeDetentionDate(pageInstance: ui.Page): Promise<void>;
    onValidationSellByDate(value: string): string | undefined;
    onChangeSellByDate(pageInstance: ui.Page): Promise<void>;
    onValidationUseByDate(value: string): string | undefined;
    onChangeUseByDate(_pageInstance: ui.Page): Promise<void>;
    onValidationShipByDate(value: string): string | undefined;
    onChangeShipByDate(pageInstance: ui.Page): Promise<void>;
    onValidationFifoDate(_value: string): string | undefined;
    onChangeFifoDate(pageInstance: ui.Page): Promise<void>;
    /**
     * This function assign the FIFO date based on the current date and the product configuration.
     * @param currentDate
     * @param fifoDateNature
     * @returns
     */
    private _setFifoDate;
    /**
     * This function calculates the manufacturing date and then readjusts the fifo date.
     * @param currentDate
     * @param fieldName
     * @returns
     */
    private _setManufacturedDate;
    /**
     * Assign all date after change date
     * @param currentDate
     * @returns
     */
    private _setStandardDate;
    /**
     * This function calculates the date based on the current date and the product configuration.
     *  @param currentDate
     *  @param dateTarget
     *  @param productConfiguration
     *  @returns
     */
    private _dateCalculation;
}
//# sourceMappingURL=fifo-management.d.ts.map