declare module '@sage/wh-product-data-api-partial' {
    import type {
        AssignmentClass,
        Depositor,
        Location,
        LocationInput,
        LocationSplitAddresses,
        LocationSplitAddressesBinding,
        LocationSplitAddressesInput,
        Package as SageWhMasterData$Package,
        ParcelType,
        PreparationArea,
        RangeOfParcel,
        RotationClass,
        ShippingUnitType,
        StockCountClass,
        StockNature,
        StorageType,
        Store,
        StoreChaining,
        Supplier,
        TruckTrackingStatus,
        UnitOfMeasure,
    } from '@sage/wh-master-data-api';
    import type { Package as SageWhStructure$Package } from '@sage/wh-structure-api';
    import type { Package as SageWhSystem$Package, Site } from '@sage/wh-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface Action458$Enum {
        deleted: 1;
        created: 2;
        none: 3;
    }
    export type Action458 = keyof Action458$Enum;
    export interface ActionType$Enum {
        pick: 1;
        pack: 2;
        packPalletize: 3;
        palletize: 4;
    }
    export type ActionType = keyof ActionType$Enum;
    export interface Action$Enum {
        cre: 1;
        dup: 2;
        upd: 3;
        del: 4;
    }
    export type Action = keyof Action$Enum;
    export interface AdStatus$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        substituteValue9: 9;
    }
    export type AdStatus = keyof AdStatus$Enum;
    export interface AddressStructure$Enum {
        aisle: 1;
        row: 2;
        level: 3;
        other4: 4;
        other: 5;
    }
    export type AddressStructure = keyof AddressStructure$Enum;
    export interface AllocationMethod$Enum {
        toBeProcessed: 1;
        processed: 2;
        intergrationError: 3;
        errorProcessed: 4;
        importError: 5;
        exportError: 6;
        blocked: 7;
    }
    export type AllocationMethod = keyof AllocationMethod$Enum;
    export interface AppointmentWeight$Enum {
        eiWeight: 1;
        roundWeight: 2;
    }
    export type AppointmentWeight = keyof AppointmentWeight$Enum;
    export interface AssemblyMovementStatus$Enum {
        notAddressed: 1;
        notUsed2: 2;
        addressed: 3;
        notUsed4: 4;
        nonCompliant: 5;
        compliant: 6;
        notUsed7: 7;
        notUsed8: 8;
        validated: 9;
    }
    export type AssemblyMovementStatus = keyof AssemblyMovementStatus$Enum;
    export interface AssemblyOrderStatus$Enum {
        pendingPreparation: 1;
        notUsed2: 2;
        selectedForPreparation: 3;
        preparationUnderProgress: 4;
        notUsed5: 5;
        notUsed6: 6;
        notUsed7: 7;
        notUsed8: 8;
        processed: 9;
    }
    export type AssemblyOrderStatus = keyof AssemblyOrderStatus$Enum;
    export interface AutoPalletizationStatus$Enum {
        notValidated: 1;
        notUsed2: 2;
        partlyValidated: 3;
        validated: 4;
        cancelled: 5;
    }
    export type AutoPalletizationStatus = keyof AutoPalletizationStatus$Enum;
    export interface BlockingReason$Enum {
        inventoryPending: 1;
        blockedInOutput: 2;
        forbiddenInOutput: 3;
        reserved: 4;
        stockNature: 5;
        datesExpired: 6;
    }
    export type BlockingReason = keyof BlockingReason$Enum;
    export interface BlockingType$Enum {
        noBlock: 1;
        operationBlocking: 2;
        statusBlock: 3;
        newForm: 4;
    }
    export type BlockingType = keyof BlockingType$Enum;
    export interface CancelationOfEiShortage$Enum {
        no: 1;
        closeTheLine: 2;
        closeTheInput: 3;
    }
    export type CancelationOfEiShortage = keyof CancelationOfEiShortage$Enum;
    export interface CirculationDirection$Enum {
        alternate: 1;
        ascending: 2;
        descending: 3;
    }
    export type CirculationDirection = keyof CirculationDirection$Enum;
    export interface CirculationType$Enum {
        rowLevel: 1;
        levelRow: 2;
    }
    export type CirculationType = keyof CirculationType$Enum;
    export interface Class$Enum {
        depositorItem: 1;
        store: 2;
        rotationClass: 3;
        assignmentClass: 4;
        container: 5;
    }
    export type Class = keyof Class$Enum;
    export interface Code128Police$Enum {
        normal: 1;
        large: 2;
        narrow: 3;
    }
    export type Code128Police = keyof Code128Police$Enum;
    export interface Colis$Enum {
        onDock: 1;
        pendingTransfer: 2;
        exDock: 3;
    }
    export type Colis = keyof Colis$Enum;
    export interface ConsumableMvtOrigin$Enum {
        direct: 1;
        ei: 2;
        receipt: 3;
        di: 4;
        do: 5;
        round: 6;
        all: 7;
    }
    export type ConsumableMvtOrigin = keyof ConsumableMvtOrigin$Enum;
    export interface ConsumableMvtSorting$Enum {
        byConsumable: 1;
        byDate: 2;
    }
    export type ConsumableMvtSorting = keyof ConsumableMvtSorting$Enum;
    export interface ConsumableMvtType429$Enum {
        input: 1;
        output: 2;
        all: 3;
    }
    export type ConsumableMvtType429 = keyof ConsumableMvtType429$Enum;
    export interface ConsumableSorting$Enum {
        byConsumable: 1;
        byQuantity: 2;
    }
    export type ConsumableSorting = keyof ConsumableSorting$Enum;
    export interface ControlType397$Enum {
        valueList: 1;
        ranges: 2;
        noControl: 3;
    }
    export type ControlType397 = keyof ControlType397$Enum;
    export interface CountingPrint$Enum {
        no: 1;
        counting: 2;
        stockObjects: 3;
    }
    export type CountingPrint = keyof CountingPrint$Enum;
    export interface CountingType$Enum {
        inventoryLines: 1;
        countDiscrepancies: 2;
        gapBetween2Counts: 3;
    }
    export type CountingType = keyof CountingType$Enum;
    export interface CrossDockingCover$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
    }
    export type CrossDockingCover = keyof CrossDockingCover$Enum;
    export interface CrossDocking$Enum {
        no: 1;
        yesIfShortage: 2;
        yesPriority: 3;
    }
    export type CrossDocking = keyof CrossDocking$Enum;
    export interface CrystalReportDgg$Enum {
        selections: 1;
        site: 2;
        depositor: 3;
        shippedBy: 4;
        icpeClass: 5;
        activeMaterial6: 6;
        product7: 7;
        qtyInStock: 8;
        qty: 9;
        ubdUnit: 10;
        weight: 11;
        activeMaterialWeight: 12;
        activeMaterialTotal: 13;
        classTotal: 14;
        detailedStockByIcpeClass: 15;
        total16: 16;
        cumulatedStockByIcpeClass: 17;
        flammableProductStock: 18;
        flashPoint19: 19;
        liquidProducts: 20;
        solideProducts: 21;
        flashPoint: 22;
        class: 23;
        total: 24;
        totalAllFlammableProducts: 25;
        stockOfFlammableProductsInCorrectedTonnage: 26;
        transportedProducts: 27;
        transportClass: 28;
        notClassified: 29;
        generalTotal: 30;
        dateRange: 31;
        limitControlOfDangerousGoodsStorage: 32;
        maxi: 33;
        maxiQuantityAuthorized: 34;
        expectedQty: 35;
        roundNo: 36;
        cnNo: 37;
        dangerousSubstanceTransportDocument: 38;
        simplifiedJointStockCompanyWithACapitalOf: 39;
        vehicleRegistrationNumber: 40;
        classification: 41;
        packing: 42;
        deposit: 43;
        label: 44;
        coefficient: 45;
        onuCodeDescription: 46;
        productDescription: 47;
        cU: 48;
        summary: 49;
        actualWeight: 50;
        weightedWeight: 51;
        threshold: 52;
        transportNotExceedingTheFreeLimitsRecommendedIn1136: 53;
        affixingOfOrangePannels: 54;
        mandatoryLoadSignature: 55;
        mandatoryDriverSignature: 56;
        the: 57;
        dnTransportDocumentNo: 58;
        crNo: 59;
        stockOnDockByIcpeClass: 60;
        activeMaterial61: 61;
        weightOf: 62;
        un: 63;
        pg: 64;
        transportCategoryDescription: 65;
        categoryTotal: 66;
        hazardMatQty: 67;
        unit: 68;
        transportExceedingThePrescriptionsOfChapter1136: 69;
        transportNotExceedingThePrescriptionsOfChapter1136: 70;
        actualMaterialQty: 71;
        weighedMaterialQty: 72;
        saleUnitQty: 73;
        activeMaterialQty: 74;
        category: 75;
        youHaveBeenInformedThatTheStorageLimitOfHazardousMaterialsHasBeenExceeded: 76;
        storageLimitExceededOnSite: 77;
        activeMaterial: 78;
        product: 79;
        cuStk: 80;
    }
    export type CrystalReportDgg = keyof CrystalReportDgg$Enum;
    export interface CrystalReport$Enum {
        provisional: 1;
        final: 2;
        reprint: 3;
        all4: 4;
        page: 5;
        multiZonesDn: 6;
        facility: 7;
        selection: 8;
        depositor9: 9;
        printingType: 10;
        wave: 11;
        round: 12;
        dONumber: 13;
        dlNumber: 14;
        preparationZone: 15;
        sender: 16;
        deliveryAddress: 17;
        loadRecapitulation: 18;
        deliveryNote: 19;
        ourReferences: 20;
        from21: 21;
        customerCode: 22;
        doReferences: 23;
        yourReferences: 24;
        order: 25;
        n: 26;
        invoiceAddress: 27;
        carriage: 28;
        mode: 29;
        postageType: 30;
        line: 31;
        itemCode: 32;
        description: 33;
        ucQuantity: 34;
        weight: 35;
        volume: 36;
        suN37: 37;
        parcelN38: 38;
        packingList: 39;
        suN: 40;
        parcelN: 41;
        dimension: 42;
        hWD: 43;
        yes: 44;
        no: 45;
        all: 46;
        picking: 47;
        reserve: 48;
        mixed: 49;
        level: 50;
        carrier: 51;
        multiZonesPo: 52;
        byDo: 53;
        byItem: 54;
        byLocation55: 55;
        input: 56;
        output: 57;
        transfer: 58;
        adjustment: 59;
        consignee: 60;
        from: 61;
        cu: 62;
        transferReplenishment: 63;
        difference: 64;
        stock: 65;
        merging: 66;
        stockObject: 67;
        conform: 68;
        anomaly: 69;
        pendingDn: 70;
        finishedDn: 71;
        numberOfConformedFinishedDnXTheoreticalShipdate: 72;
        requestN: 73;
        di: 74;
        receipt: 75;
        ei: 76;
        direct: 77;
        byConsumable: 78;
        byDate: 79;
        byQuantity: 80;
        byProduct: 81;
        byPrompting: 82;
        byLocation: 83;
        byStore: 84;
        roundSite: 85;
        aoNumber: 86;
        byAo: 87;
        store: 88;
        assembly: 89;
        range: 90;
        type: 91;
        shipAsIs: 92;
        suType: 93;
        doNo: 94;
        doRef: 95;
        pickingMode: 96;
        intersiteDeliveryNote: 97;
        cuStkQuantity: 98;
        serviceProvision: 99;
        address: 100;
        product: 101;
        cuStkTotal: 102;
        cuStkNo: 103;
        unitPrice: 104;
        valuation: 105;
        storeAddress: 106;
        serialNumbers: 107;
        depositor: 108;
        status: 109;
        srn1: 110;
        srn2: 111;
    }
    export type CrystalReport = keyof CrystalReport$Enum;
    export interface Custk$Enum {
        cu: 1;
        stk: 2;
    }
    export type Custk = keyof Custk$Enum;
    export interface DataFileType461$Enum {
        delineated: 1;
        fixedLength: 2;
        xml: 3;
    }
    export type DataFileType461 = keyof DataFileType461$Enum;
    export interface DateContractUnit$Enum {
        day: 1;
        month: 2;
    }
    export type DateContractUnit = keyof DateContractUnit$Enum;
    export interface DeliveryOrderLineStatus$Enum {
        waitFirstPick: 1;
        waitNthPick: 2;
        selectedForPreparation: 3;
        preparationInProcess: 4;
        notUsed5: 5;
        notUsed6: 6;
        notUsed7: 7;
        waitToShip: 8;
        shippedClosed: 9;
    }
    export type DeliveryOrderLineStatus = keyof DeliveryOrderLineStatus$Enum;
    export interface DispatchableInState$Enum {
        no: 1;
        yes: 2;
        yesIfStandard: 3;
    }
    export type DispatchableInState = keyof DispatchableInState$Enum;
    export interface DoLineType$Enum {
        item: 1;
        kit: 2;
        component: 3;
        commentary: 4;
    }
    export type DoLineType = keyof DoLineType$Enum;
    export interface EdiLevel$Enum {
        parcel: 1;
        dn: 2;
        cr: 3;
        su: 4;
    }
    export type EdiLevel = keyof EdiLevel$Enum;
    export interface EdiMngtStatus$Enum {
        pending: 1;
        finished: 2;
        notConcerned: 3;
    }
    export type EdiMngtStatus = keyof EdiMngtStatus$Enum;
    export interface EndDay$Enum {
        d: 1;
        d1: 2;
    }
    export type EndDay = keyof EndDay$Enum;
    export interface ExpectedInputLineStatus$Enum {
        notReceived: 1;
        partialReceipt: 2;
        notUsed3: 3;
        notUsed4: 4;
        notUsed5: 5;
        notUsed6: 6;
        notUsed7: 7;
        receivedClosed: 8;
    }
    export type ExpectedInputLineStatus = keyof ExpectedInputLineStatus$Enum;
    export interface ExpectedInputStatus$Enum {
        notReceived: 1;
        partialReceipt: 2;
        firstReceiptPending: 3;
        fourthReceiptPending: 4;
        notUsed5: 5;
        notUsed6: 6;
        notUsed7: 7;
        receivedClosed: 8;
    }
    export type ExpectedInputStatus = keyof ExpectedInputStatus$Enum;
    export interface FifoDate$Enum {
        input: 1;
        manufacturing: 2;
        sellByDate: 3;
        maximumConservationLimit: 4;
        sendByDateLimit: 5;
    }
    export type FifoDate = keyof FifoDate$Enum;
    export interface FormulaType406$Enum {
        rotationClasses: 1;
        receipts: 2;
    }
    export type FormulaType406 = keyof FormulaType406$Enum;
    export interface GeodeEdition$Enum {
        standardEdition: 1;
        advancedEdition: 2;
        premiumEdition: 3;
    }
    export type GeodeEdition = keyof GeodeEdition$Enum;
    export interface IncompleteOutputAuthorized$Enum {
        no: 1;
        requestStandardQuantity: 2;
        always: 3;
    }
    export type IncompleteOutputAuthorized = keyof IncompleteOutputAuthorized$Enum;
    export interface InputHeaderStatus$Enum {
        notAdressed: 1;
        inControl: 2;
        notUsed3: 3;
        adressed: 4;
        notUset5: 5;
        notUsed6: 6;
        notUsed7: 7;
        storedClosed: 8;
    }
    export type InputHeaderStatus = keyof InputHeaderStatus$Enum;
    export interface InputLineStatus$Enum {
        notAddressed: 1;
        notUsed2: 2;
        notUsed3: 3;
        addressed: 4;
        notUsed5: 5;
        notUsed6: 6;
        notUsed7: 7;
        storedClosed: 8;
    }
    export type InputLineStatus = keyof InputLineStatus$Enum;
    export interface InputMovementStatus$Enum {
        notAddressed: 1;
        notUsed2: 2;
        notUsed3: 3;
        addressed: 4;
        notUsed5: 5;
        notUsed6: 6;
        notUsed7: 7;
        storedClosed: 8;
    }
    export type InputMovementStatus = keyof InputMovementStatus$Enum;
    export interface InputReport$Enum {
        directInput: 1;
        inputLine: 2;
        movement: 3;
    }
    export type InputReport = keyof InputReport$Enum;
    export interface InterfaceType$Enum {
        transmission: 1;
        receipt: 2;
    }
    export type InterfaceType = keyof InterfaceType$Enum;
    export interface InventoryDiscrepancy$Enum {
        no: 1;
        yes: 2;
        adjustedInPart: 3;
        adjusted: 4;
        notAdjusted: 5;
    }
    export type InventoryDiscrepancy = keyof InventoryDiscrepancy$Enum;
    export interface InventoryLineType$Enum {
        pending: 1;
        closed: 2;
        settled: 3;
        canBeClosed: 4;
        cannotBeClosed: 5;
    }
    export type InventoryLineType = keyof InventoryLineType$Enum;
    export interface InventoryStatus$Enum {
        pending: 1;
        closed: 2;
        settled: 3;
        partiallyClosed: 4;
    }
    export type InventoryStatus = keyof InventoryStatus$Enum;
    export interface InventoryType$Enum {
        byAddress: 1;
        byItem: 2;
    }
    export type InventoryType = keyof InventoryType$Enum;
    export interface InvoiceLineType$Enum {
        proportional: 1;
        fixed: 2;
        byRange: 3;
    }
    export type InvoiceLineType = keyof InvoiceLineType$Enum;
    export interface InvoiceStatus$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        substituteValue9: 9;
    }
    export type InvoiceStatus = keyof InvoiceStatus$Enum;
    export interface LicenceInfo$Enum {
        routing: 1;
        maxNrSites: 2;
        maxNrDepositors: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        substituteValue9: 9;
    }
    export type LicenceInfo = keyof LicenceInfo$Enum;
    export interface LineStatus$Enum {
        waiting: 1;
        closed: 2;
        validated: 3;
    }
    export type LineStatus = keyof LineStatus$Enum;
    export interface LoadRangeEntity$Enum {
        item: 1;
        ei: 2;
        eiLine: 3;
        do: 4;
        doLine: 5;
        parcel: 6;
        su: 7;
        movement: 8;
        appointment: 9;
    }
    export type LoadRangeEntity = keyof LoadRangeEntity$Enum;
    export interface LoadSplit$Enum {
        parcel: 1;
        su: 2;
    }
    export type LoadSplit = keyof LoadSplit$Enum;
    export interface LocationType467$Enum {
        none: 1;
        productLocation: 2;
        productLocationPossibleLocations: 3;
    }
    export type LocationType467 = keyof LocationType467$Enum;
    export interface LuSelectionType$Enum {
        parcel: 1;
        su: 2;
    }
    export type LuSelectionType = keyof LuSelectionType$Enum;
    export interface MaterialType$Enum {
        liquidMaterial: 1;
        solidMaterial: 2;
    }
    export type MaterialType = keyof MaterialType$Enum;
    export interface MergingInInput$Enum {
        no: 1;
        yes: 2;
        yesIfIncomplete: 3;
        yesIfNotStandard: 4;
    }
    export type MergingInInput = keyof MergingInInput$Enum;
    export interface MissionAreaType$Enum {
        receivingDock: 1;
        shippingDock: 2;
        bufferArea: 3;
        travelSequence: 4;
    }
    export type MissionAreaType = keyof MissionAreaType$Enum;
    export interface MissionStatus$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        substituteValue9: 9;
    }
    export type MissionStatus = keyof MissionStatus$Enum;
    export interface MovementOrigin$Enum {
        picking: 1;
        replenishment: 2;
        inventoryLines: 3;
    }
    export type MovementOrigin = keyof MovementOrigin$Enum;
    export interface MovementType416$Enum {
        input: 1;
        depositTrf: 2;
        depositRepl: 3;
        deposit2P: 4;
        output: 5;
        pickTrf: 6;
        pickRepl: 7;
        pick2P: 8;
    }
    export type MovementType416 = keyof MovementType416$Enum;
    export interface MovementType465$Enum {
        input: 1;
        transferRepositioning: 2;
        adjustment: 3;
        transferRemoval: 4;
        output: 5;
        assembly: 6;
    }
    export type MovementType465 = keyof MovementType465$Enum;
    export interface MovementType$Enum {
        normal: 1;
        mergingWithAccrual: 2;
        mergingWithoutAccrual: 3;
        stockOutReplenishment: 4;
        preventiveReplenishment: 5;
        transferEntireContainer: 6;
        mergingFlowsTransfer: 7;
        mergingFlowsReplenishment: 8;
        componentTransfer: 9;
        componentReplen: 10;
        kitTransfer: 11;
        kitReorder: 12;
    }
    export type MovementType = keyof MovementType$Enum;
    export interface MultiPickingIssue$Enum {
        fifoDate: 1;
        occupation: 2;
        cuQuantity: 3;
        pickingPriority: 4;
        fifoBracket: 5;
    }
    export type MultiPickingIssue = keyof MultiPickingIssue$Enum;
    export interface NoYesBlank$Enum {
        no: 1;
        yes: 2;
        substituteValue3: 3;
    }
    export type NoYesBlank = keyof NoYesBlank$Enum;
    export interface OrderCategory$Enum {
        creation: 1;
        modification: 2;
        suppression: 3;
        read: 4;
    }
    export type OrderCategory = keyof OrderCategory$Enum;
    export interface OutputMovementStatus$Enum {
        beingAddressed: 1;
        notUsed2: 2;
        addressed: 3;
        inShortage: 4;
        cancelledInThePreparation: 5;
        cancelledInTheShipment: 6;
        deferredInTheShipment: 7;
        validated: 8;
        shipped: 9;
    }
    export type OutputMovementStatus = keyof OutputMovementStatus$Enum;
    export interface OutputMvtSort$Enum {
        product: 1;
        family: 2;
        subFamily: 3;
        group: 4;
        subGroup: 5;
        netWeight: 6;
        netVolume: 7;
        fifoDate: 8;
        lot: 9;
        supportNo: 10;
        store: 11;
        address: 12;
        travelSequence: 13;
        orderCustomer: 14;
        shippedToCustomer: 15;
        genericRound: 16;
        round: 17;
        roundPosition: 18;
        dock: 19;
        formula: 20;
        reservation: 21;
        postalCode: 22;
    }
    export type OutputMvtSort = keyof OutputMvtSort$Enum;
    export interface OutputOfTheReserve$Enum {
        fifoDate: 1;
        occupation: 2;
        cuStkQuantity: 3;
        store: 4;
        fifoBracket: 5;
        lotNumber: 6;
    }
    export type OutputOfTheReserve = keyof OutputOfTheReserve$Enum;
    export interface OwnerType$Enum {
        company: 1;
        site: 2;
        supplier: 3;
    }
    export type OwnerType = keyof OwnerType$Enum;
    export interface PackagingGroup$Enum {
        i: 1;
        ii: 2;
        iii: 3;
        notUsed4: 4;
    }
    export type PackagingGroup = keyof PackagingGroup$Enum;
    export interface Packing$Enum {
        withoutPacking: 1;
        prePacking: 2;
        declarativePacking: 3;
    }
    export type Packing = keyof Packing$Enum;
    export interface PalletizationType$Enum {
        prepalletization: 1;
        autoPalletization: 2;
    }
    export type PalletizationType = keyof PalletizationType$Enum;
    export interface ParameterValues$Enum {
        none: 1;
        parameters: 2;
        parametersParameterValues: 3;
    }
    export type ParameterValues = keyof ParameterValues$Enum;
    export interface ParcelAction$Enum {
        creation: 1;
        validation: 2;
        suClosing3: 3;
        loading: 4;
        unloading: 5;
        palletization: 6;
        depalletization: 7;
        shipping8: 8;
        repacking: 9;
        declarativePackingParcelCreation: 10;
        dockTransferValidation: 11;
        dockTransfer: 12;
        carrierParcelUpdate: 13;
        suOpening: 14;
        report: 15;
        reintegration: 16;
        shipping: 17;
        groupingParcelCreation: 18;
        splittingDestinationParcelCreation: 19;
        splittingDestinationParcelModification: 20;
        splittingOriginalParcelCreation: 21;
        parcelModification: 22;
        suDeletion: 23;
        parcelDeletion: 24;
        shippingCancellation: 25;
        suClosing: 26;
        declarativePackingParcelModification: 27;
        suGroupingSuCreation: 28;
        suSplittingParcelPalletizationOnSu: 29;
        suSplittingCreationOfSuDestination: 30;
        suSplittingParcelDepalletizationOfASu: 31;
        suModification: 32;
        suSplittingSuParcelChange: 33;
        suGroupingSuParcelChange: 34;
        suGroupingSuDeletion: 35;
        suSplittingSuDeletion: 36;
        suValidation: 37;
        prepalletization: 38;
        autoPalletizationCancellation: 39;
    }
    export type ParcelAction = keyof ParcelAction$Enum;
    export interface ParcelStatus$Enum {
        notUsed1: 1;
        notUsed2: 2;
        creationPending: 3;
        notValidated: 4;
        autoPalletization: 5;
        waitToPalletized: 6;
        waitToLoad: 7;
        waitToShip: 8;
        shipped: 9;
    }
    export type ParcelStatus = keyof ParcelStatus$Enum;
    export interface ParcelSuPrint$Enum {
        parcel: 1;
        su: 2;
        suAndParcel: 3;
    }
    export type ParcelSuPrint = keyof ParcelSuPrint$Enum;
    export interface PendingMode$Enum {
        normal: 1;
    }
    export type PendingMode = keyof PendingMode$Enum;
    export interface PickingDynamisationStatus$Enum {
        waitIdealClasses: 1;
        waitCurrentPickingBlockage: 2;
        waitReallocation: 3;
        waitTransferGeneration: 4;
        waitMovementValidations: 5;
        cancelled: 6;
        validated: 7;
    }
    export type PickingDynamisationStatus = keyof PickingDynamisationStatus$Enum;
    export interface PickingLocationPriority$Enum {
        no: 1;
        yesAlways: 2;
        yesIfReserveIsEmpty: 3;
    }
    export type PickingLocationPriority = keyof PickingLocationPriority$Enum;
    export interface PoPrintSequence$Enum {
        preparationAreaDo: 1;
        doPreparationArea: 2;
    }
    export type PoPrintSequence = keyof PoPrintSequence$Enum;
    export interface PoType$Enum {
        picking: 1;
        reserve: 2;
        mixed: 3;
    }
    export type PoType = keyof PoType$Enum;
    export interface PrintDn$Enum {
        temporary: 1;
        final: 2;
        rePrint: 3;
    }
    export type PrintDn = keyof PrintDn$Enum;
    export interface RealTimeViewType$Enum {
        wave: 1;
        round: 2;
    }
    export type RealTimeViewType = keyof RealTimeViewType$Enum;
    export interface ReceiptLineStatus$Enum {
        generated: 1;
        dripAndDropRequested: 2;
        dripAndDropInProcess: 3;
        dripAndDropValidated: 4;
        validated: 5;
    }
    export type ReceiptLineStatus = keyof ReceiptLineStatus$Enum;
    export interface ReceiptReferenceType$Enum {
        none: 1;
        expectedInputReference: 2;
        orderReference: 3;
        reference: 4;
    }
    export type ReceiptReferenceType = keyof ReceiptReferenceType$Enum;
    export interface ReceiptStatus877$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
    }
    export type ReceiptStatus877 = keyof ReceiptStatus877$Enum;
    export interface ReceiptStatus$Enum {
        declared: 1;
        pending: 2;
        partiallyValidated: 3;
        validated: 4;
    }
    export type ReceiptStatus = keyof ReceiptStatus$Enum;
    export interface ReplenishmentMovementType$Enum {
        notUsed1: 1;
        notUsed2: 2;
        addressed: 3;
        notUsed4: 4;
        notUsed5: 5;
        notUsed6: 6;
        transfertPending: 7;
        validated: 8;
        cancelled: 9;
    }
    export type ReplenishmentMovementType = keyof ReplenishmentMovementType$Enum;
    export interface ReplenishmentType$Enum {
        thresholdReplenishment: 1;
        systematicReplenishment: 2;
    }
    export type ReplenishmentType = keyof ReplenishmentType$Enum;
    export interface ReplenismentTransfer$Enum {
        replenishment: 1;
        transfer: 2;
    }
    export type ReplenismentTransfer = keyof ReplenismentTransfer$Enum;
    export interface ReserveOutputAuthorized$Enum {
        no: 1;
        requestObject: 2;
        requestPickingCapacity: 3;
        always: 4;
    }
    export type ReserveOutputAuthorized = keyof ReserveOutputAuthorized$Enum;
    export interface ReversibleFreezing$Enum {
        no: 1;
        yes: 2;
        notUsed3: 3;
    }
    export type ReversibleFreezing = keyof ReversibleFreezing$Enum;
    export interface RotationClassCalculType$Enum {
        byItem: 1;
        byItemContainer: 2;
    }
    export type RotationClassCalculType = keyof RotationClassCalculType$Enum;
    export interface SampleStatus$Enum {
        notQualified: 1;
        rejected: 2;
        accepted: 3;
    }
    export type SampleStatus = keyof SampleStatus$Enum;
    export interface SamplingType$Enum {
        none: 1;
        simple: 2;
    }
    export type SamplingType = keyof SamplingType$Enum;
    export interface SearchType$Enum {
        scripts: 1;
        screens: 2;
        windows: 3;
    }
    export type SearchType = keyof SearchType$Enum;
    export interface SerialAction$Enum {
        inputOnDi: 1;
        diCancellation: 2;
        diInterface: 3;
        vtStorageInput: 4;
        inputOnSl: 5;
        slValidation: 6;
        outputOnPo: 7;
        outputOnDo: 8;
        doCancellation: 9;
        outputOnParcel: 10;
        declaredPacking: 11;
        outputOnVtPicking: 12;
        shipmentCancellation: 13;
        shipmentPostponement: 14;
        shipmentRenewal: 15;
        inputOnAdjustment: 16;
        outputOnAdjustment: 17;
        transfer: 18;
    }
    export type SerialAction = keyof SerialAction$Enum;
    export interface SetupType$Enum {
        none: 1;
        input: 2;
        output: 3;
        inputOutput: 4;
    }
    export type SetupType = keyof SetupType$Enum;
    export interface ShippingUnitStatus$Enum {
        notUsed1: 1;
        notUsed2: 2;
        notUsed3: 3;
        notValidated: 4;
        notUsed5: 5;
        preparationPending: 6;
        waitingToLoad: 7;
        waitToShip: 8;
        shipped: 9;
    }
    export type ShippingUnitStatus = keyof ShippingUnitStatus$Enum;
    export interface SimplifiedStockCountStatus$Enum {
        pending: 1;
        nonComplying: 2;
        withDiscrepancy: 3;
        withoutDiscrepancy: 4;
        validated: 5;
        closed: 6;
    }
    export type SimplifiedStockCountStatus = keyof SimplifiedStockCountStatus$Enum;
    export interface SoType$Enum {
        neitherLocationNorSo: 1;
        allSoLocationNoEditingOfIOMvts: 2;
        allSoLocationIOMvts: 3;
        onlySoWithIOMvtsLocation: 4;
    }
    export type SoType = keyof SoType$Enum;
    export interface SortOrder478$Enum {
        ascending: 1;
        decreasing: 2;
    }
    export type SortOrder478 = keyof SortOrder478$Enum;
    export interface SortStock$Enum {
        byItem: 1;
        byAddress: 2;
    }
    export type SortStock = keyof SortStock$Enum;
    export interface SortingOfOnQuayParcels$Enum {
        byLocation: 1;
        byStore: 2;
    }
    export type SortingOfOnQuayParcels = keyof SortingOfOnQuayParcels$Enum;
    export interface StockCountCreationOrigin$Enum {
        manual: 1;
        stockCountGeneration: 2;
        simplifiedStockCount: 3;
    }
    export type StockCountCreationOrigin = keyof StockCountCreationOrigin$Enum;
    export interface StockObjectType$Enum {
        normal: 1;
        link: 2;
        master: 3;
    }
    export type StockObjectType = keyof StockObjectType$Enum;
    export interface StockOnQuayGroupingType$Enum {
        byDockLocation: 1;
        byDockLocationStatus: 2;
        detailed: 3;
    }
    export type StockOnQuayGroupingType = keyof StockOnQuayGroupingType$Enum;
    export interface StockOnQuayValidationType$Enum {
        immediate: 1;
        deferred: 2;
    }
    export type StockOnQuayValidationType = keyof StockOnQuayValidationType$Enum;
    export interface StoringListPurchaseOrderStatus$Enum {
        notValidated: 1;
        notUsed2: 2;
        partiallyValidated: 3;
        validated: 4;
        beingCreated: 5;
    }
    export type StoringListPurchaseOrderStatus = keyof StoringListPurchaseOrderStatus$Enum;
    export interface SuCreationType$Enum {
        prepalletization: 1;
        autoPalletization: 2;
        palletization: 3;
    }
    export type SuCreationType = keyof SuCreationType$Enum;
    export interface SupportStatus$Enum {
        free: 1;
        inProgress: 2;
        used: 3;
        shipped: 4;
        notForUse: 5;
        obsolete: 6;
    }
    export type SupportStatus = keyof SupportStatus$Enum;
    export interface ThresholdPalletAlways$Enum {
        threshold: 1;
        object: 2;
        always: 3;
    }
    export type ThresholdPalletAlways = keyof ThresholdPalletAlways$Enum;
    export interface TimeSlots$Enum {
        morning: 1;
        noon: 2;
        afternoon: 3;
        evening: 4;
    }
    export type TimeSlots = keyof TimeSlots$Enum;
    export interface TotalStatistics$Enum {
        spaceAvailableRefCont: 1;
        occupancyRate: 2;
        authorizedFlowsInpOut: 3;
        weight: 4;
        volume: 5;
        cu: 6;
        containers: 7;
        price: 8;
        movementsInProgressInpOut: 9;
        validatedMovements: 10;
        numberOfLocations: 11;
        stk: 12;
    }
    export type TotalStatistics = keyof TotalStatistics$Enum;
    export interface TraceLevel$Enum {
        none: 1;
        average: 2;
        high: 3;
    }
    export type TraceLevel = keyof TraceLevel$Enum;
    export interface TransferPhase$Enum {
        removal: 1;
        repositioning: 2;
    }
    export type TransferPhase = keyof TransferPhase$Enum;
    export interface TransferToStore$Enum {
        towardsInternalStore: 1;
        towardsExternalStore: 2;
    }
    export type TransferToStore = keyof TransferToStore$Enum;
    export interface TransferValidation$Enum {
        validation: 1;
        cancellation: 2;
        picking: 3;
        relocation: 4;
        none: 5;
    }
    export type TransferValidation = keyof TransferValidation$Enum;
    export interface TransmissionL3$Enum {
        none: 1;
        yes: 2;
        mounted: 3;
    }
    export type TransmissionL3 = keyof TransmissionL3$Enum;
    export interface Type815$Enum {
        movement: 1;
        so: 2;
    }
    export type Type815 = keyof Type815$Enum;
    export interface TypeOfActivity$Enum {
        inputs: 1;
        outputs: 2;
        stocks: 3;
        other: 4;
        notDefined: 5;
    }
    export type TypeOfActivity = keyof TypeOfActivity$Enum;
    export interface TypeOfAnalysis$Enum {
        empty: 1;
        ei: 2;
        do: 3;
        appRound: 4;
        receipt: 5;
        di: 6;
        sl: 7;
        inputMovement: 8;
        transferMovement: 9;
        wave: 10;
        po: 11;
        outputMovement: 12;
        doToBePrepared: 13;
        doPickingOnTheWave: 14;
        doToBeShipped: 15;
        doPickingOnRound: 16;
        appointment: 17;
    }
    export type TypeOfAnalysis = keyof TypeOfAnalysis$Enum;
    export interface TypeOfEntity$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
    }
    export type TypeOfEntity = keyof TypeOfEntity$Enum;
    export interface Type$Enum {
        assembling: 1;
        disassembling: 2;
    }
    export type Type = keyof Type$Enum;
    export interface UnavailabilityType$Enum {
        resource: 1;
        material: 2;
        mission: 3;
    }
    export type UnavailabilityType = keyof UnavailabilityType$Enum;
    export interface UnitLength$Enum {
        days: 1;
        month: 2;
        no: 3;
    }
    export type UnitLength = keyof UnitLength$Enum;
    export interface ValidationProcess$Enum {
        manual: 1;
        semiAutomatic: 2;
        automatic: 3;
    }
    export type ValidationProcess = keyof ValidationProcess$Enum;
    export interface ViewType$Enum {
        do: 1;
        round: 2;
    }
    export type ViewType = keyof ViewType$Enum;
    export interface VtGroupingCriteria$Enum {
        none: 1;
        customer: 2;
        do: 3;
        doLine: 4;
    }
    export type VtGroupingCriteria = keyof VtGroupingCriteria$Enum;
    export interface WaveStatus$Enum {
        waitToLaunch: 1;
        notUsed2: 2;
        waitToTransfer: 3;
        wait2ndStep: 4;
        ended: 5;
    }
    export type WaveStatus = keyof WaveStatus$Enum;
    export interface WaveType409$Enum {
        automaticallyGeneratedWaves: 1;
        manuallyGeneratedWaves: 2;
    }
    export type WaveType409 = keyof WaveType409$Enum;
    export interface WaveType$Enum {
        normal: 1;
        mergingOfFlows: 2;
        assembling: 3;
        disassembling: 4;
    }
    export type WaveType = keyof WaveType$Enum;
    export interface ZoneType$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
        boolean: 4;
        text: 5;
    }
    export type ZoneType = keyof ZoneType$Enum;
    export interface ActiveMatter extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        isSaleWithdrawal: boolean;
    }
    export interface ActiveMatterInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        isSaleWithdrawal?: boolean | string;
    }
    export interface ActiveMatterBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        isSaleWithdrawal: boolean;
    }
    export interface ActiveMatter$Lookups {
        site: QueryOperation<Site>;
    }
    export interface ActiveMatter$Operations {
        query: QueryOperation<ActiveMatter>;
        read: ReadOperation<ActiveMatter>;
        aggregate: {
            read: AggregateReadOperation<ActiveMatter>;
            query: AggregateQueryOperation<ActiveMatter>;
        };
        lookups(dataOrId: string | { data: ActiveMatterInput }): ActiveMatter$Lookups;
        getDefaults: GetDefaultsOperation<ActiveMatter>;
    }
    export interface Container extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        containerType: ContainersType;
        containerLevel: ContainerLevel;
        localizedDescription: string;
        localizedShortDescription: string;
        height: string;
        width: string;
        depth: string;
        volume: string;
        parcelRangeShippedAsIsStandard: RangeOfParcel;
        parcelTypeShippedAsIsStandard: ParcelType;
        parcelRangeShippedAsIsNonStandard: RangeOfParcel;
        parcelTypeShippedAsIsNonStandard: ParcelType;
        shippingUnitDispatchableAsIs: ShippingUnitType;
        isShippingUnitPalettizableAsIs: boolean;
        maximumQuantityAllowedInInputOutput: integer;
        palletBaseHeight: string;
        palletBaseGrossWeight: string;
        isActive: boolean;
        containerManagementType: ContainerManagementType;
        unitWeight: string;
        unitVolume: string;
    }
    export interface ContainerInput extends ClientNodeInput {
        site?: string;
        code?: string;
        containerType?: string;
        containerLevel?: ContainerLevel;
        localizedDescription?: string;
        localizedShortDescription?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        parcelRangeShippedAsIsStandard?: string;
        parcelTypeShippedAsIsStandard?: string;
        parcelRangeShippedAsIsNonStandard?: string;
        parcelTypeShippedAsIsNonStandard?: string;
        shippingUnitDispatchableAsIs?: string;
        isShippingUnitPalettizableAsIs?: boolean | string;
        maximumQuantityAllowedInInputOutput?: integer | string;
        palletBaseHeight?: decimal | string;
        palletBaseGrossWeight?: decimal | string;
        isActive?: boolean | string;
        containerManagementType?: ContainerManagementType;
        unitWeight?: decimal | string;
        unitVolume?: decimal | string;
    }
    export interface ContainerBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        containerType: ContainersType;
        containerLevel: ContainerLevel;
        localizedDescription: string;
        localizedShortDescription: string;
        height: string;
        width: string;
        depth: string;
        volume: string;
        parcelRangeShippedAsIsStandard: RangeOfParcel;
        parcelTypeShippedAsIsStandard: ParcelType;
        parcelRangeShippedAsIsNonStandard: RangeOfParcel;
        parcelTypeShippedAsIsNonStandard: ParcelType;
        shippingUnitDispatchableAsIs: ShippingUnitType;
        isShippingUnitPalettizableAsIs: boolean;
        maximumQuantityAllowedInInputOutput: integer;
        palletBaseHeight: string;
        palletBaseGrossWeight: string;
        isActive: boolean;
        containerManagementType: ContainerManagementType;
        unitWeight: string;
        unitVolume: string;
    }
    export interface Container$Lookups {
        site: QueryOperation<Site>;
        containerType: QueryOperation<ContainersType>;
        parcelRangeShippedAsIsStandard: QueryOperation<RangeOfParcel>;
        parcelTypeShippedAsIsStandard: QueryOperation<ParcelType>;
        parcelRangeShippedAsIsNonStandard: QueryOperation<RangeOfParcel>;
        parcelTypeShippedAsIsNonStandard: QueryOperation<ParcelType>;
        shippingUnitDispatchableAsIs: QueryOperation<ShippingUnitType>;
    }
    export interface Container$Operations {
        query: QueryOperation<Container>;
        read: ReadOperation<Container>;
        aggregate: {
            read: AggregateReadOperation<Container>;
            query: AggregateQueryOperation<Container>;
        };
        lookups(dataOrId: string | { data: ContainerInput }): Container$Lookups;
        getDefaults: GetDefaultsOperation<Container>;
    }
    export interface ContainersType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        level: ContainerLevel;
        mergingOfFlowsGroup: string;
        containerManagementType: ContainerManagementType;
    }
    export interface ContainersTypeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        level?: ContainerLevel;
        mergingOfFlowsGroup?: string;
        containerManagementType?: ContainerManagementType;
    }
    export interface ContainersTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        level: ContainerLevel;
        mergingOfFlowsGroup: string;
        containerManagementType: ContainerManagementType;
    }
    export interface ContainersType$Lookups {
        site: QueryOperation<Site>;
    }
    export interface ContainersType$Operations {
        query: QueryOperation<ContainersType>;
        read: ReadOperation<ContainersType>;
        aggregate: {
            read: AggregateReadOperation<ContainersType>;
            query: AggregateQueryOperation<ContainersType>;
        };
        lookups(dataOrId: string | { data: ContainersTypeInput }): ContainersType$Lookups;
        getDefaults: GetDefaultsOperation<ContainersType>;
    }
    export interface Family extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        parcelRange: RangeOfParcel;
        parcelGroup: string;
    }
    export interface FamilyInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        parcelRange?: string;
        parcelGroup?: string;
    }
    export interface FamilyBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        parcelRange: RangeOfParcel;
        parcelGroup: string;
    }
    export interface Family$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        parcelRange: QueryOperation<RangeOfParcel>;
    }
    export interface Family$Operations {
        query: QueryOperation<Family>;
        read: ReadOperation<Family>;
        aggregate: {
            read: AggregateReadOperation<Family>;
            query: AggregateQueryOperation<Family>;
        };
        lookups(dataOrId: string | { data: FamilyInput }): Family$Lookups;
        getDefaults: GetDefaultsOperation<Family>;
    }
    export interface Group extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface GroupInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface GroupBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface Group$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface Group$Operations {
        query: QueryOperation<Group>;
        read: ReadOperation<Group>;
        aggregate: {
            read: AggregateReadOperation<Group>;
            query: AggregateQueryOperation<Group>;
        };
        lookups(dataOrId: string | { data: GroupInput }): Group$Lookups;
        getDefaults: GetDefaultsOperation<Group>;
    }
    export interface HazardousMaterialsClass extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
    }
    export interface HazardousMaterialsClassInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
    }
    export interface HazardousMaterialsClassBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
    }
    export interface HazardousMaterialsClass$Lookups {
        site: QueryOperation<Site>;
    }
    export interface HazardousMaterialsClass$Operations {
        query: QueryOperation<HazardousMaterialsClass>;
        read: ReadOperation<HazardousMaterialsClass>;
        aggregate: {
            read: AggregateReadOperation<HazardousMaterialsClass>;
            query: AggregateQueryOperation<HazardousMaterialsClass>;
        };
        lookups(dataOrId: string | { data: HazardousMaterialsClassInput }): HazardousMaterialsClass$Lookups;
        getDefaults: GetDefaultsOperation<HazardousMaterialsClass>;
    }
    export interface IcpeClasses extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        maximumQuantityAllowedOnSite: integer;
    }
    export interface IcpeClassesInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        maximumQuantityAllowedOnSite?: integer | string;
    }
    export interface IcpeClassesBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        maximumQuantityAllowedOnSite: integer;
    }
    export interface IcpeClasses$Lookups {
        site: QueryOperation<Site>;
    }
    export interface IcpeClasses$Operations {
        query: QueryOperation<IcpeClasses>;
        read: ReadOperation<IcpeClasses>;
        aggregate: {
            read: AggregateReadOperation<IcpeClasses>;
            query: AggregateQueryOperation<IcpeClasses>;
        };
        lookups(dataOrId: string | { data: IcpeClassesInput }): IcpeClasses$Lookups;
        getDefaults: GetDefaultsOperation<IcpeClasses>;
    }
    export interface InputModeCreationOfSeparateMovements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        isCreationOfSeparateMovements: boolean;
    }
    export interface InputModeCreationOfSeparateMovementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        isCreationOfSeparateMovements?: boolean | string;
    }
    export interface InputModeCreationOfSeparateMovementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        isCreationOfSeparateMovements: boolean;
    }
    export interface InputModeCreationOfSeparateMovements$Operations {
        query: QueryOperation<InputModeCreationOfSeparateMovements>;
        read: ReadOperation<InputModeCreationOfSeparateMovements>;
        aggregate: {
            read: AggregateReadOperation<InputModeCreationOfSeparateMovements>;
            query: AggregateQueryOperation<InputModeCreationOfSeparateMovements>;
        };
        getDefaults: GetDefaultsOperation<InputModeCreationOfSeparateMovements>;
    }
    export interface InputModeInputPriorityInReserveLocations extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        inputPriorityInReserveLocation: Class;
    }
    export interface InputModeInputPriorityInReserveLocationsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        inputPriorityInReserveLocation?: Class;
    }
    export interface InputModeInputPriorityInReserveLocationsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        inputPriorityInReserveLocation: Class;
    }
    export interface InputModeInputPriorityInReserveLocations$Operations {
        query: QueryOperation<InputModeInputPriorityInReserveLocations>;
        read: ReadOperation<InputModeInputPriorityInReserveLocations>;
        aggregate: {
            read: AggregateReadOperation<InputModeInputPriorityInReserveLocations>;
            query: AggregateQueryOperation<InputModeInputPriorityInReserveLocations>;
        };
        getDefaults: GetDefaultsOperation<InputModeInputPriorityInReserveLocations>;
    }
    export interface InputModeMovementLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        movementLevel: ContainerLevel;
    }
    export interface InputModeMovementLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        movementLevel?: ContainerLevel;
    }
    export interface InputModeMovementLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        movementLevel: ContainerLevel;
    }
    export interface InputModeMovementLevels$Operations {
        query: QueryOperation<InputModeMovementLevels>;
        read: ReadOperation<InputModeMovementLevels>;
        aggregate: {
            read: AggregateReadOperation<InputModeMovementLevels>;
            query: AggregateQueryOperation<InputModeMovementLevels>;
        };
        getDefaults: GetDefaultsOperation<InputModeMovementLevels>;
    }
    export interface InputMode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        priorityPickingLocation: PickingLocationPriority;
        isProximityPickingAllowed: boolean;
        isPartialObjectInPickingAllowed: boolean;
        availableSpaceInPickingManagement: ThresholdPalletAlways;
        isRotationClassesChaining: boolean;
        isAssignmentClassesChaining: boolean;
        isContainerCorrespondence: boolean;
        isSingleContainer: boolean;
        isSingleProduct: boolean;
        isIncompleteObjectCorrespondence: boolean;
        mergingInInputManagement: MergingInInput;
        isKeyInSerialNumber: boolean;
        isUniqueMergingStore: boolean;
        isCompleteQuantityInSingleLocation: boolean;
        homogeneousCrossDockingContainerLevel: ContainerLevel;
        isAutoCrossDockingPreparationOrder: boolean;
        isActive: boolean;
        siteDepositorIdentifier: string;
        isPartialObjectCapacityExcessAllowed: boolean;
        creationOfSeparateMovements: ClientCollection<InputModeCreationOfSeparateMovements>;
        inputPriorityInReserveLocations: ClientCollection<InputModeInputPriorityInReserveLocations>;
        movementLevels: ClientCollection<InputModeMovementLevels>;
    }
    export interface InputModeInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        priorityPickingLocation?: PickingLocationPriority;
        isProximityPickingAllowed?: boolean | string;
        isPartialObjectInPickingAllowed?: boolean | string;
        availableSpaceInPickingManagement?: ThresholdPalletAlways;
        isRotationClassesChaining?: boolean | string;
        isAssignmentClassesChaining?: boolean | string;
        isContainerCorrespondence?: boolean | string;
        isSingleContainer?: boolean | string;
        isSingleProduct?: boolean | string;
        isIncompleteObjectCorrespondence?: boolean | string;
        mergingInInputManagement?: MergingInInput;
        isKeyInSerialNumber?: boolean | string;
        isUniqueMergingStore?: boolean | string;
        isCompleteQuantityInSingleLocation?: boolean | string;
        homogeneousCrossDockingContainerLevel?: ContainerLevel;
        isAutoCrossDockingPreparationOrder?: boolean | string;
        isActive?: boolean | string;
        siteDepositorIdentifier?: string;
        isPartialObjectCapacityExcessAllowed?: boolean | string;
        creationOfSeparateMovements?: Partial<InputModeCreationOfSeparateMovementsInput>[];
        inputPriorityInReserveLocations?: Partial<InputModeInputPriorityInReserveLocationsInput>[];
        movementLevels?: Partial<InputModeMovementLevelsInput>[];
    }
    export interface InputModeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        priorityPickingLocation: PickingLocationPriority;
        isProximityPickingAllowed: boolean;
        isPartialObjectInPickingAllowed: boolean;
        availableSpaceInPickingManagement: ThresholdPalletAlways;
        isRotationClassesChaining: boolean;
        isAssignmentClassesChaining: boolean;
        isContainerCorrespondence: boolean;
        isSingleContainer: boolean;
        isSingleProduct: boolean;
        isIncompleteObjectCorrespondence: boolean;
        mergingInInputManagement: MergingInInput;
        isKeyInSerialNumber: boolean;
        isUniqueMergingStore: boolean;
        isCompleteQuantityInSingleLocation: boolean;
        homogeneousCrossDockingContainerLevel: ContainerLevel;
        isAutoCrossDockingPreparationOrder: boolean;
        isActive: boolean;
        siteDepositorIdentifier: string;
        isPartialObjectCapacityExcessAllowed: boolean;
        creationOfSeparateMovements: ClientCollection<InputModeCreationOfSeparateMovementsBinding>;
        inputPriorityInReserveLocations: ClientCollection<InputModeInputPriorityInReserveLocationsBinding>;
        movementLevels: ClientCollection<InputModeMovementLevelsBinding>;
    }
    export interface InputMode$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface InputMode$Operations {
        query: QueryOperation<InputMode>;
        read: ReadOperation<InputMode>;
        aggregate: {
            read: AggregateReadOperation<InputMode>;
            query: AggregateQueryOperation<InputMode>;
        };
        lookups(dataOrId: string | { data: InputModeInput }): InputMode$Lookups;
        getDefaults: GetDefaultsOperation<InputMode>;
    }
    export interface Kits extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        kit: Product;
        lineOrder: integer;
        product: Product;
        numberOfConsumptionUnits: string;
    }
    export interface KitsInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        kit?: string;
        lineOrder?: integer | string;
        product?: string;
        numberOfConsumptionUnits?: decimal | string;
    }
    export interface KitsBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        kit: Product;
        lineOrder: integer;
        product: Product;
        numberOfConsumptionUnits: string;
    }
    export interface Kits$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        kit: QueryOperation<Product>;
        product: QueryOperation<Product>;
    }
    export interface Kits$Operations {
        query: QueryOperation<Kits>;
        read: ReadOperation<Kits>;
        aggregate: {
            read: AggregateReadOperation<Kits>;
            query: AggregateQueryOperation<Kits>;
        };
        lookups(dataOrId: string | { data: KitsInput }): Kits$Lookups;
        getDefaults: GetDefaultsOperation<Kits>;
    }
    export interface OnuCode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
    }
    export interface OnuCodeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
    }
    export interface OnuCodeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
    }
    export interface OnuCode$Lookups {
        site: QueryOperation<Site>;
    }
    export interface OnuCode$Operations {
        query: QueryOperation<OnuCode>;
        read: ReadOperation<OnuCode>;
        aggregate: {
            read: AggregateReadOperation<OnuCode>;
            query: AggregateQueryOperation<OnuCode>;
        };
        lookups(dataOrId: string | { data: OnuCodeInput }): OnuCode$Lookups;
        getDefaults: GetDefaultsOperation<OnuCode>;
    }
    export interface Origin extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface OriginInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface OriginBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface Origin$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface Origin$Operations {
        query: QueryOperation<Origin>;
        read: ReadOperation<Origin>;
        aggregate: {
            read: AggregateReadOperation<Origin>;
            query: AggregateQueryOperation<Origin>;
        };
        lookups(dataOrId: string | { data: OriginInput }): Origin$Lookups;
        getDefaults: GetDefaultsOperation<Origin>;
    }
    export interface OutputModeOutputsPriority extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        outputPriority: OutputOfTheReserve;
    }
    export interface OutputModeOutputsPriorityInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        outputPriority?: OutputOfTheReserve;
    }
    export interface OutputModeOutputsPriorityBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        outputPriority: OutputOfTheReserve;
    }
    export interface OutputModeOutputsPriority$Operations {
        query: QueryOperation<OutputModeOutputsPriority>;
        read: ReadOperation<OutputModeOutputsPriority>;
        aggregate: {
            read: AggregateReadOperation<OutputModeOutputsPriority>;
            query: AggregateQueryOperation<OutputModeOutputsPriority>;
        };
        getDefaults: GetDefaultsOperation<OutputModeOutputsPriority>;
    }
    export interface OutputModePickingsPriority extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        pickingPriority: MultiPickingIssue;
    }
    export interface OutputModePickingsPriorityInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        pickingPriority?: MultiPickingIssue;
    }
    export interface OutputModePickingsPriorityBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        pickingPriority: MultiPickingIssue;
    }
    export interface OutputModePickingsPriority$Operations {
        query: QueryOperation<OutputModePickingsPriority>;
        read: ReadOperation<OutputModePickingsPriority>;
        aggregate: {
            read: AggregateReadOperation<OutputModePickingsPriority>;
            query: AggregateQueryOperation<OutputModePickingsPriority>;
        };
        getDefaults: GetDefaultsOperation<OutputModePickingsPriority>;
    }
    export interface OutputModeReplenishmentsPrioritySorting extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        replenishmentPrioritySorting: SortOrder;
    }
    export interface OutputModeReplenishmentsPrioritySortingInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        replenishmentPrioritySorting?: SortOrder;
    }
    export interface OutputModeReplenishmentsPrioritySortingBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        replenishmentPrioritySorting: SortOrder;
    }
    export interface OutputModeReplenishmentsPrioritySorting$Operations {
        query: QueryOperation<OutputModeReplenishmentsPrioritySorting>;
        read: ReadOperation<OutputModeReplenishmentsPrioritySorting>;
        aggregate: {
            read: AggregateReadOperation<OutputModeReplenishmentsPrioritySorting>;
            query: AggregateQueryOperation<OutputModeReplenishmentsPrioritySorting>;
        };
        getDefaults: GetDefaultsOperation<OutputModeReplenishmentsPrioritySorting>;
    }
    export interface OutputModeReplenishmentsPriority extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        replenishmentPriority: OutputOfTheReserve;
    }
    export interface OutputModeReplenishmentsPriorityInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        replenishmentPriority?: OutputOfTheReserve;
    }
    export interface OutputModeReplenishmentsPriorityBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        replenishmentPriority: OutputOfTheReserve;
    }
    export interface OutputModeReplenishmentsPriority$Operations {
        query: QueryOperation<OutputModeReplenishmentsPriority>;
        read: ReadOperation<OutputModeReplenishmentsPriority>;
        aggregate: {
            read: AggregateReadOperation<OutputModeReplenishmentsPriority>;
            query: AggregateQueryOperation<OutputModeReplenishmentsPriority>;
        };
        getDefaults: GetDefaultsOperation<OutputModeReplenishmentsPriority>;
    }
    export interface OutputMode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isPickingStockAllowed: boolean;
        isPickingPivotAllowed: boolean;
        isSingleDeliveryOrderReplenishmentForPickingPivotAllowed: boolean;
        isSingleWaveReplenishmentForPickingPivotAllowed: boolean;
        reserveOutputAuthorizedRule: ReserveOutputAuthorized;
        isReserveProhibited: boolean;
        percentagePickingCapacityForReserveOutputAuthorizedRule: integer;
        isAutomaticChoiceOfPicking: boolean;
        inCompleteContainerPickingAuthorizedRule: IncompleteOutputAuthorized;
        isIncompletePalletCreatedAuthorized: boolean;
        isStockOutReplenishmentAllowed: boolean;
        isPreventiveReplenishmentAllowed: boolean;
        isSerialNumberInInputAllowed: boolean;
        isSerialNumberInOutputAllowed: boolean;
        bigVolumeLimit: string;
        isDynamicPickingAllowed: boolean;
        isMultiplePickingAllowed: boolean;
        isDeliveryOrderSinglePickingForMultiplePickingAllowed: boolean;
        isPriorityOutputToReplenishmentForMultiplePickingAllowed: boolean;
        isSingleAddressReplenishmentForMultiplePickingAllowed: boolean;
        isActive: boolean;
        siteDepositorIdentifier: string;
        isLocalizedSerialNumberAllowed: boolean;
        isMovementInHomogeneousContainerForReserveOutputAuthorizedRuleAllowed: boolean;
        outputsPriority: ClientCollection<OutputModeOutputsPriority>;
        pickingsPriority: ClientCollection<OutputModePickingsPriority>;
        replenishmentsPriority: ClientCollection<OutputModeReplenishmentsPriority>;
        replenishmentsPrioritySorting: ClientCollection<OutputModeReplenishmentsPrioritySorting>;
    }
    export interface OutputModeInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isPickingStockAllowed?: boolean | string;
        isPickingPivotAllowed?: boolean | string;
        isSingleDeliveryOrderReplenishmentForPickingPivotAllowed?: boolean | string;
        isSingleWaveReplenishmentForPickingPivotAllowed?: boolean | string;
        reserveOutputAuthorizedRule?: ReserveOutputAuthorized;
        isReserveProhibited?: boolean | string;
        percentagePickingCapacityForReserveOutputAuthorizedRule?: integer | string;
        isAutomaticChoiceOfPicking?: boolean | string;
        inCompleteContainerPickingAuthorizedRule?: IncompleteOutputAuthorized;
        isIncompletePalletCreatedAuthorized?: boolean | string;
        isStockOutReplenishmentAllowed?: boolean | string;
        isPreventiveReplenishmentAllowed?: boolean | string;
        isSerialNumberInInputAllowed?: boolean | string;
        isSerialNumberInOutputAllowed?: boolean | string;
        bigVolumeLimit?: decimal | string;
        isDynamicPickingAllowed?: boolean | string;
        isMultiplePickingAllowed?: boolean | string;
        isDeliveryOrderSinglePickingForMultiplePickingAllowed?: boolean | string;
        isPriorityOutputToReplenishmentForMultiplePickingAllowed?: boolean | string;
        isSingleAddressReplenishmentForMultiplePickingAllowed?: boolean | string;
        isActive?: boolean | string;
        siteDepositorIdentifier?: string;
        isLocalizedSerialNumberAllowed?: boolean | string;
        isMovementInHomogeneousContainerForReserveOutputAuthorizedRuleAllowed?: boolean | string;
        outputsPriority?: Partial<OutputModeOutputsPriorityInput>[];
        pickingsPriority?: Partial<OutputModePickingsPriorityInput>[];
        replenishmentsPriority?: Partial<OutputModeReplenishmentsPriorityInput>[];
        replenishmentsPrioritySorting?: Partial<OutputModeReplenishmentsPrioritySortingInput>[];
    }
    export interface OutputModeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isPickingStockAllowed: boolean;
        isPickingPivotAllowed: boolean;
        isSingleDeliveryOrderReplenishmentForPickingPivotAllowed: boolean;
        isSingleWaveReplenishmentForPickingPivotAllowed: boolean;
        reserveOutputAuthorizedRule: ReserveOutputAuthorized;
        isReserveProhibited: boolean;
        percentagePickingCapacityForReserveOutputAuthorizedRule: integer;
        isAutomaticChoiceOfPicking: boolean;
        inCompleteContainerPickingAuthorizedRule: IncompleteOutputAuthorized;
        isIncompletePalletCreatedAuthorized: boolean;
        isStockOutReplenishmentAllowed: boolean;
        isPreventiveReplenishmentAllowed: boolean;
        isSerialNumberInInputAllowed: boolean;
        isSerialNumberInOutputAllowed: boolean;
        bigVolumeLimit: string;
        isDynamicPickingAllowed: boolean;
        isMultiplePickingAllowed: boolean;
        isDeliveryOrderSinglePickingForMultiplePickingAllowed: boolean;
        isPriorityOutputToReplenishmentForMultiplePickingAllowed: boolean;
        isSingleAddressReplenishmentForMultiplePickingAllowed: boolean;
        isActive: boolean;
        siteDepositorIdentifier: string;
        isLocalizedSerialNumberAllowed: boolean;
        isMovementInHomogeneousContainerForReserveOutputAuthorizedRuleAllowed: boolean;
        outputsPriority: ClientCollection<OutputModeOutputsPriorityBinding>;
        pickingsPriority: ClientCollection<OutputModePickingsPriorityBinding>;
        replenishmentsPriority: ClientCollection<OutputModeReplenishmentsPriorityBinding>;
        replenishmentsPrioritySorting: ClientCollection<OutputModeReplenishmentsPrioritySortingBinding>;
    }
    export interface OutputMode$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface OutputMode$Operations {
        query: QueryOperation<OutputMode>;
        read: ReadOperation<OutputMode>;
        aggregate: {
            read: AggregateReadOperation<OutputMode>;
            query: AggregateQueryOperation<OutputMode>;
        };
        lookups(dataOrId: string | { data: OutputModeInput }): OutputMode$Lookups;
        getDefaults: GetDefaultsOperation<OutputMode>;
    }
    export interface PickingMode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isExclusiveReservation: boolean;
        isMergingOfFlows: boolean;
        crossDockingRule: CrossDocking;
        isExclusiveFifoDate: boolean;
        isSingleLotInOutput: boolean;
        isPreparationOrderMixed: boolean;
        isPreparationOrderSingleDeliveryOrderPerPicking: boolean;
        isPreparationOrderSingleDeliveryOrderPerReserve: boolean;
        isPreparationOrderSinglePickArea: boolean;
        preparationAreaForParcel: PreparationArea;
        preparationAreaForKit: PreparationArea;
        isPreparationOrderSingleOutputLevel: boolean;
        isSingleShippingRoundPerPreparationOrder: boolean;
        isSingleShipToCustomerPerPreparationOrder: boolean;
        isPickingPreparationOrder: boolean;
        isReservePreparationOrder: boolean;
        packingManagement: Packing;
        isPreparationOrderPrint: boolean;
        preparationOrderPrintSequence: PoPrintSequence;
        isGroupedMovements: boolean;
        isParcelLabelPrint: boolean;
        isShippingUnitLabelPrint: boolean;
        isMultiplePicking: boolean;
        isPrepalletization: boolean;
        loadSplit: LoadSplit;
        isContractDate: boolean;
        handledGroupingRule: VtGroupingCriteria;
        isActive: boolean;
        siteDepositorIdentifier: string;
    }
    export interface PickingModeInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isExclusiveReservation?: boolean | string;
        isMergingOfFlows?: boolean | string;
        crossDockingRule?: CrossDocking;
        isExclusiveFifoDate?: boolean | string;
        isSingleLotInOutput?: boolean | string;
        isPreparationOrderMixed?: boolean | string;
        isPreparationOrderSingleDeliveryOrderPerPicking?: boolean | string;
        isPreparationOrderSingleDeliveryOrderPerReserve?: boolean | string;
        isPreparationOrderSinglePickArea?: boolean | string;
        preparationAreaForParcel?: string;
        preparationAreaForKit?: string;
        isPreparationOrderSingleOutputLevel?: boolean | string;
        isSingleShippingRoundPerPreparationOrder?: boolean | string;
        isSingleShipToCustomerPerPreparationOrder?: boolean | string;
        isPickingPreparationOrder?: boolean | string;
        isReservePreparationOrder?: boolean | string;
        packingManagement?: Packing;
        isPreparationOrderPrint?: boolean | string;
        preparationOrderPrintSequence?: PoPrintSequence;
        isGroupedMovements?: boolean | string;
        isParcelLabelPrint?: boolean | string;
        isShippingUnitLabelPrint?: boolean | string;
        isMultiplePicking?: boolean | string;
        isPrepalletization?: boolean | string;
        loadSplit?: LoadSplit;
        isContractDate?: boolean | string;
        handledGroupingRule?: VtGroupingCriteria;
        isActive?: boolean | string;
        siteDepositorIdentifier?: string;
    }
    export interface PickingModeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isExclusiveReservation: boolean;
        isMergingOfFlows: boolean;
        crossDockingRule: CrossDocking;
        isExclusiveFifoDate: boolean;
        isSingleLotInOutput: boolean;
        isPreparationOrderMixed: boolean;
        isPreparationOrderSingleDeliveryOrderPerPicking: boolean;
        isPreparationOrderSingleDeliveryOrderPerReserve: boolean;
        isPreparationOrderSinglePickArea: boolean;
        preparationAreaForParcel: PreparationArea;
        preparationAreaForKit: PreparationArea;
        isPreparationOrderSingleOutputLevel: boolean;
        isSingleShippingRoundPerPreparationOrder: boolean;
        isSingleShipToCustomerPerPreparationOrder: boolean;
        isPickingPreparationOrder: boolean;
        isReservePreparationOrder: boolean;
        packingManagement: Packing;
        isPreparationOrderPrint: boolean;
        preparationOrderPrintSequence: PoPrintSequence;
        isGroupedMovements: boolean;
        isParcelLabelPrint: boolean;
        isShippingUnitLabelPrint: boolean;
        isMultiplePicking: boolean;
        isPrepalletization: boolean;
        loadSplit: LoadSplit;
        isContractDate: boolean;
        handledGroupingRule: VtGroupingCriteria;
        isActive: boolean;
        siteDepositorIdentifier: string;
    }
    export interface PickingMode$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        preparationAreaForParcel: QueryOperation<PreparationArea>;
        preparationAreaForKit: QueryOperation<PreparationArea>;
    }
    export interface PickingMode$Operations {
        query: QueryOperation<PickingMode>;
        read: ReadOperation<PickingMode>;
        aggregate: {
            read: AggregateReadOperation<PickingMode>;
            query: AggregateQueryOperation<PickingMode>;
        };
        lookups(dataOrId: string | { data: PickingModeInput }): PickingMode$Lookups;
        getDefaults: GetDefaultsOperation<PickingMode>;
    }
    export interface ProductActiveMatters extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        activeMatter: ActiveMatter;
    }
    export interface ProductActiveMattersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        activeMatter?: string;
    }
    export interface ProductActiveMattersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        activeMatter: ActiveMatter;
    }
    export interface ProductActiveMatters$Lookups {
        activeMatter: QueryOperation<ActiveMatter>;
    }
    export interface ProductActiveMatters$Operations {
        query: QueryOperation<ProductActiveMatters>;
        read: ReadOperation<ProductActiveMatters>;
        aggregate: {
            read: AggregateReadOperation<ProductActiveMatters>;
            query: AggregateQueryOperation<ProductActiveMatters>;
        };
        lookups(dataOrId: string | { data: ProductActiveMattersInput }): ProductActiveMatters$Lookups;
        getDefaults: GetDefaultsOperation<ProductActiveMatters>;
    }
    export interface ProductContainerContainersInferior extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        containerInferior: ProductContainer;
    }
    export interface ProductContainerContainersInferiorInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        product?: string;
        container?: string;
        containerInferior?: string;
    }
    export interface ProductContainerContainersInferiorBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        containerInferior: ProductContainer;
    }
    export interface ProductContainerContainersInferior$Lookups {
        containerInferior: QueryOperation<ProductContainer>;
    }
    export interface ProductContainerContainersInferior$Operations {
        query: QueryOperation<ProductContainerContainersInferior>;
        read: ReadOperation<ProductContainerContainersInferior>;
        aggregate: {
            read: AggregateReadOperation<ProductContainerContainersInferior>;
            query: AggregateQueryOperation<ProductContainerContainersInferior>;
        };
        lookups(
            dataOrId: string | { data: ProductContainerContainersInferiorInput },
        ): ProductContainerContainersInferior$Lookups;
        getDefaults: GetDefaultsOperation<ProductContainerContainersInferior>;
    }
    export interface ProductContainerNumberOfConsumptionUnitPerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        numberOfConsumptionUnitPerLevel: string;
    }
    export interface ProductContainerNumberOfConsumptionUnitPerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        product?: string;
        container?: string;
        numberOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface ProductContainerNumberOfConsumptionUnitPerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        numberOfConsumptionUnitPerLevel: string;
    }
    export interface ProductContainerNumberOfConsumptionUnitPerLevels$Operations {
        query: QueryOperation<ProductContainerNumberOfConsumptionUnitPerLevels>;
        read: ReadOperation<ProductContainerNumberOfConsumptionUnitPerLevels>;
        aggregate: {
            read: AggregateReadOperation<ProductContainerNumberOfConsumptionUnitPerLevels>;
            query: AggregateQueryOperation<ProductContainerNumberOfConsumptionUnitPerLevels>;
        };
        getDefaults: GetDefaultsOperation<ProductContainerNumberOfConsumptionUnitPerLevels>;
    }
    export interface ProductContainerNumberOfStockUnitPerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        numberOfStockUnitPerLevel: string;
    }
    export interface ProductContainerNumberOfStockUnitPerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        product?: string;
        container?: string;
        numberOfStockUnitPerLevel?: decimal | string;
    }
    export interface ProductContainerNumberOfStockUnitPerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        numberOfStockUnitPerLevel: string;
    }
    export interface ProductContainerNumberOfStockUnitPerLevels$Operations {
        query: QueryOperation<ProductContainerNumberOfStockUnitPerLevels>;
        read: ReadOperation<ProductContainerNumberOfStockUnitPerLevels>;
        aggregate: {
            read: AggregateReadOperation<ProductContainerNumberOfStockUnitPerLevels>;
            query: AggregateQueryOperation<ProductContainerNumberOfStockUnitPerLevels>;
        };
        getDefaults: GetDefaultsOperation<ProductContainerNumberOfStockUnitPerLevels>;
    }
    export interface ProductContainerProhibitedClasses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        prohibitedClass: AssignmentClass;
    }
    export interface ProductContainerProhibitedClassesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        product?: string;
        container?: string;
        prohibitedClass?: string;
    }
    export interface ProductContainerProhibitedClassesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        product: string;
        container: string;
        prohibitedClass: AssignmentClass;
    }
    export interface ProductContainerProhibitedClasses$Lookups {
        prohibitedClass: QueryOperation<AssignmentClass>;
    }
    export interface ProductContainerProhibitedClasses$Operations {
        query: QueryOperation<ProductContainerProhibitedClasses>;
        read: ReadOperation<ProductContainerProhibitedClasses>;
        aggregate: {
            read: AggregateReadOperation<ProductContainerProhibitedClasses>;
            query: AggregateQueryOperation<ProductContainerProhibitedClasses>;
        };
        lookups(
            dataOrId: string | { data: ProductContainerProhibitedClassesInput },
        ): ProductContainerProhibitedClasses$Lookups;
        getDefaults: GetDefaultsOperation<ProductContainerProhibitedClasses>;
    }
    export interface ProductContainer extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        container: Container;
        upcCode: string;
        containerLevel: ContainerLevel;
        inferiorContainer: ProductContainer;
        numberInferiorContainer: string;
        numberOfConsumptionUnit: string;
        minimumReserveOutput: ContainerLevel;
        grossWeight: string;
        width: string;
        depth: string;
        height: string;
        volume: string;
        linearMeters: string;
        isNesting: boolean;
        maximumNesting: integer;
        umpteenthProductWidthNesting: string;
        umpteenthProductDepthNesting: string;
        umpteenthProductHeightNesting: string;
        umpteenthProductVolumeNesting: string;
        isInputAllowed: boolean;
        sequenceCode: StoreChaining;
        percentageOfRupture: integer;
        maximumNumberOfContainers: string;
        stackingCoefficient: integer;
        stackingCorrective: integer;
        isKeyInSupportNumbers: boolean;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        homogeneousLevel: ContainerLevel;
        isOutputAllowed: boolean;
        dispatchableInState: DispatchableInState;
        isPackingPattern: boolean;
        containerTare: string;
        parcelRangeShippedAsIsStandard: RangeOfParcel;
        parcelTypeShippedAsIsStandard: ParcelType;
        parcelRangeShippedAsIsNonStandard: RangeOfParcel;
        parcelTypeShippedAsIsNonStandard: ParcelType;
        isActive: boolean;
        numberOfStockUnit: string;
        density: string;
        unitWeight: string;
        unitVolume: string;
        containersInferior: ClientCollection<ProductContainerContainersInferior>;
        numberOfConsumptionUnitPerLevels: ClientCollection<ProductContainerNumberOfConsumptionUnitPerLevels>;
        numberOfStockUnitPerLevels: ClientCollection<ProductContainerNumberOfStockUnitPerLevels>;
        prohibitedClasses: ClientCollection<ProductContainerProhibitedClasses>;
    }
    export interface ProductContainerInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        product?: string;
        container?: string;
        upcCode?: string;
        containerLevel?: ContainerLevel;
        inferiorContainer?: string;
        numberInferiorContainer?: decimal | string;
        numberOfConsumptionUnit?: decimal | string;
        minimumReserveOutput?: ContainerLevel;
        grossWeight?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        height?: decimal | string;
        volume?: decimal | string;
        linearMeters?: decimal | string;
        isNesting?: boolean | string;
        maximumNesting?: integer | string;
        umpteenthProductWidthNesting?: decimal | string;
        umpteenthProductDepthNesting?: decimal | string;
        umpteenthProductHeightNesting?: decimal | string;
        umpteenthProductVolumeNesting?: decimal | string;
        isInputAllowed?: boolean | string;
        sequenceCode?: string;
        percentageOfRupture?: integer | string;
        maximumNumberOfContainers?: decimal | string;
        stackingCoefficient?: integer | string;
        stackingCorrective?: integer | string;
        isKeyInSupportNumbers?: boolean | string;
        rotationClass?: string;
        assignmentClass?: string;
        homogeneousLevel?: ContainerLevel;
        isOutputAllowed?: boolean | string;
        dispatchableInState?: DispatchableInState;
        isPackingPattern?: boolean | string;
        containerTare?: decimal | string;
        parcelRangeShippedAsIsStandard?: string;
        parcelTypeShippedAsIsStandard?: string;
        parcelRangeShippedAsIsNonStandard?: string;
        parcelTypeShippedAsIsNonStandard?: string;
        isActive?: boolean | string;
        numberOfStockUnit?: decimal | string;
        density?: decimal | string;
        unitWeight?: decimal | string;
        unitVolume?: decimal | string;
        containersInferior?: Partial<ProductContainerContainersInferiorInput>[];
        numberOfConsumptionUnitPerLevels?: Partial<ProductContainerNumberOfConsumptionUnitPerLevelsInput>[];
        numberOfStockUnitPerLevels?: Partial<ProductContainerNumberOfStockUnitPerLevelsInput>[];
        prohibitedClasses?: Partial<ProductContainerProhibitedClassesInput>[];
    }
    export interface ProductContainerBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        container: Container;
        upcCode: string;
        containerLevel: ContainerLevel;
        inferiorContainer: ProductContainer;
        numberInferiorContainer: string;
        numberOfConsumptionUnit: string;
        minimumReserveOutput: ContainerLevel;
        grossWeight: string;
        width: string;
        depth: string;
        height: string;
        volume: string;
        linearMeters: string;
        isNesting: boolean;
        maximumNesting: integer;
        umpteenthProductWidthNesting: string;
        umpteenthProductDepthNesting: string;
        umpteenthProductHeightNesting: string;
        umpteenthProductVolumeNesting: string;
        isInputAllowed: boolean;
        sequenceCode: StoreChaining;
        percentageOfRupture: integer;
        maximumNumberOfContainers: string;
        stackingCoefficient: integer;
        stackingCorrective: integer;
        isKeyInSupportNumbers: boolean;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        homogeneousLevel: ContainerLevel;
        isOutputAllowed: boolean;
        dispatchableInState: DispatchableInState;
        isPackingPattern: boolean;
        containerTare: string;
        parcelRangeShippedAsIsStandard: RangeOfParcel;
        parcelTypeShippedAsIsStandard: ParcelType;
        parcelRangeShippedAsIsNonStandard: RangeOfParcel;
        parcelTypeShippedAsIsNonStandard: ParcelType;
        isActive: boolean;
        numberOfStockUnit: string;
        density: string;
        unitWeight: string;
        unitVolume: string;
        containersInferior: ClientCollection<ProductContainerContainersInferiorBinding>;
        numberOfConsumptionUnitPerLevels: ClientCollection<ProductContainerNumberOfConsumptionUnitPerLevelsBinding>;
        numberOfStockUnitPerLevels: ClientCollection<ProductContainerNumberOfStockUnitPerLevelsBinding>;
        prohibitedClasses: ClientCollection<ProductContainerProhibitedClassesBinding>;
    }
    export interface ProductContainer$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        container: QueryOperation<Container>;
        inferiorContainer: QueryOperation<ProductContainer>;
        sequenceCode: QueryOperation<StoreChaining>;
        rotationClass: QueryOperation<RotationClass>;
        assignmentClass: QueryOperation<AssignmentClass>;
        parcelRangeShippedAsIsStandard: QueryOperation<RangeOfParcel>;
        parcelTypeShippedAsIsStandard: QueryOperation<ParcelType>;
        parcelRangeShippedAsIsNonStandard: QueryOperation<RangeOfParcel>;
        parcelTypeShippedAsIsNonStandard: QueryOperation<ParcelType>;
    }
    export interface ProductContainer$Operations {
        query: QueryOperation<ProductContainer>;
        read: ReadOperation<ProductContainer>;
        aggregate: {
            read: AggregateReadOperation<ProductContainer>;
            query: AggregateQueryOperation<ProductContainer>;
        };
        lookups(dataOrId: string | { data: ProductContainerInput }): ProductContainer$Lookups;
        getDefaults: GetDefaultsOperation<ProductContainer>;
    }
    export interface ProductIsPrintableDescriptions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        isPrintableDescription: boolean;
    }
    export interface ProductIsPrintableDescriptionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        isPrintableDescription?: boolean | string;
    }
    export interface ProductIsPrintableDescriptionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        isPrintableDescription: boolean;
    }
    export interface ProductIsPrintableDescriptions$Operations {
        query: QueryOperation<ProductIsPrintableDescriptions>;
        read: ReadOperation<ProductIsPrintableDescriptions>;
        aggregate: {
            read: AggregateReadOperation<ProductIsPrintableDescriptions>;
            query: AggregateQueryOperation<ProductIsPrintableDescriptions>;
        };
        getDefaults: GetDefaultsOperation<ProductIsPrintableDescriptions>;
    }
    export interface ProductPercentageActiveMatters extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        percentageActiveMatter: string;
    }
    export interface ProductPercentageActiveMattersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        percentageActiveMatter?: decimal | string;
    }
    export interface ProductPercentageActiveMattersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        percentageActiveMatter: string;
    }
    export interface ProductPercentageActiveMatters$Operations {
        query: QueryOperation<ProductPercentageActiveMatters>;
        read: ReadOperation<ProductPercentageActiveMatters>;
        aggregate: {
            read: AggregateReadOperation<ProductPercentageActiveMatters>;
            query: AggregateQueryOperation<ProductPercentageActiveMatters>;
        };
        getDefaults: GetDefaultsOperation<ProductPercentageActiveMatters>;
    }
    export interface Product extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        otherCode: string;
        localizedDescription: string;
        localizedDescription2: string;
        localizedShortDescription: string;
        family: Family;
        subFamily: SubFamily;
        group: Group;
        subGroup: SubGroup;
        isKeyInSerialNumber: boolean;
        stockCountClass: StockCountClass;
        numberStockCount: integer;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isKeyInLotNumber: boolean;
        isSingleLot: boolean;
        isCrossDocking: boolean;
        isHazardousMaterials: boolean;
        isKeyInControlCode: boolean;
        fifoDateNature: FifoDate;
        source: Origin;
        inputMode: InputMode;
        outputMode: OutputMode;
        autoTransferMode: MovementType;
        detentionLength: integer;
        detentionUnit: UnitLength;
        useByDateLength: integer;
        useByDateUnit: UnitLength;
        sendByDateLength: integer;
        sendByDateUnit: UnitLength;
        sellByDateLength: integer;
        sellByDateUnit: UnitLength;
        fifoTolerance: integer;
        fifoGapUnit: UnitLength;
        netWeight: string;
        netVolume: string;
        pureAlcoholVolume: string;
        price: string;
        material: Risk;
        minimumStock: string;
        alertStock: string;
        maximumStock: string;
        firstArrival: string;
        lastReceipt: string;
        lastOutput: string;
        lastStockCount: string;
        defaultContainer: ProductContainer;
        defaultContainerLevel: ContainerLevel;
        transmittedFromL3: TransmissionL3;
        endOfLife: string;
        isQualityControlManagement: boolean;
        stockStatus: StockNature;
        isSingleLotControl: boolean;
        samplingType: SamplingType;
        generalLevelOfInspection: string;
        aql: string;
        freezingPoint: integer;
        freezingReversibility: ReversibleFreezing;
        ammNo: string;
        referredQuantity: string;
        referredUnit: UnitOfMeasure;
        icpeClass: IcpeClasses;
        flashPoint: integer;
        transportCategory: TransportCategory;
        hazardousMaterialClass: HazardousMaterialsClass;
        tunnelRestriction: string;
        classificationCode: string;
        packagingGroup: PackagingGroup;
        onuCodes: OnuCode;
        solventCode: string;
        technicalField: string;
        isActive: boolean;
        isStockUnitManagement: boolean;
        stockUnit: UnitOfMeasure;
        siteDepositorIdentifier: string;
        suppliersUpcs: ClientCollection<SupplierUpc>;
        productContainers: ClientCollection<ProductContainer>;
        picture: BinaryStream;
        activeMatters: ClientCollection<ProductActiveMatters>;
        isPrintableDescriptions: ClientCollection<ProductIsPrintableDescriptions>;
        percentageActiveMatters: ClientCollection<ProductPercentageActiveMatters>;
    }
    export interface ProductInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        otherCode?: string;
        localizedDescription?: string;
        localizedDescription2?: string;
        localizedShortDescription?: string;
        family?: string;
        subFamily?: string;
        group?: string;
        subGroup?: string;
        isKeyInSerialNumber?: boolean | string;
        stockCountClass?: string;
        numberStockCount?: integer | string;
        isBlockedInInput?: boolean | string;
        isBlockedInOutput?: boolean | string;
        isBlockedInInput2?: boolean | string;
        isBlockedInOutput2?: boolean | string;
        isKeyInLotNumber?: boolean | string;
        isSingleLot?: boolean | string;
        isCrossDocking?: boolean | string;
        isHazardousMaterials?: boolean | string;
        isKeyInControlCode?: boolean | string;
        fifoDateNature?: FifoDate;
        source?: string;
        inputMode?: string;
        outputMode?: string;
        autoTransferMode?: MovementType;
        detentionLength?: integer | string;
        detentionUnit?: UnitLength;
        useByDateLength?: integer | string;
        useByDateUnit?: UnitLength;
        sendByDateLength?: integer | string;
        sendByDateUnit?: UnitLength;
        sellByDateLength?: integer | string;
        sellByDateUnit?: UnitLength;
        fifoTolerance?: integer | string;
        fifoGapUnit?: UnitLength;
        netWeight?: decimal | string;
        netVolume?: decimal | string;
        pureAlcoholVolume?: decimal | string;
        price?: decimal | string;
        material?: string;
        minimumStock?: decimal | string;
        alertStock?: decimal | string;
        maximumStock?: decimal | string;
        firstArrival?: string;
        lastReceipt?: string;
        lastOutput?: string;
        lastStockCount?: string;
        defaultContainer?: string;
        defaultContainerLevel?: ContainerLevel;
        transmittedFromL3?: TransmissionL3;
        endOfLife?: string;
        isQualityControlManagement?: boolean | string;
        stockStatus?: string;
        isSingleLotControl?: boolean | string;
        samplingType?: SamplingType;
        generalLevelOfInspection?: string;
        aql?: decimal | string;
        freezingPoint?: integer | string;
        freezingReversibility?: ReversibleFreezing;
        ammNo?: string;
        referredQuantity?: decimal | string;
        referredUnit?: string;
        icpeClass?: string;
        flashPoint?: integer | string;
        transportCategory?: string;
        hazardousMaterialClass?: string;
        tunnelRestriction?: string;
        classificationCode?: string;
        packagingGroup?: PackagingGroup;
        onuCodes?: string;
        solventCode?: string;
        technicalField?: string;
        isActive?: boolean | string;
        isStockUnitManagement?: boolean | string;
        stockUnit?: string;
        siteDepositorIdentifier?: string;
        picture?: BinaryStream;
        activeMatters?: Partial<ProductActiveMattersInput>[];
        isPrintableDescriptions?: Partial<ProductIsPrintableDescriptionsInput>[];
        percentageActiveMatters?: Partial<ProductPercentageActiveMattersInput>[];
    }
    export interface ProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        otherCode: string;
        localizedDescription: string;
        localizedDescription2: string;
        localizedShortDescription: string;
        family: Family;
        subFamily: SubFamily;
        group: Group;
        subGroup: SubGroup;
        isKeyInSerialNumber: boolean;
        stockCountClass: StockCountClass;
        numberStockCount: integer;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isKeyInLotNumber: boolean;
        isSingleLot: boolean;
        isCrossDocking: boolean;
        isHazardousMaterials: boolean;
        isKeyInControlCode: boolean;
        fifoDateNature: FifoDate;
        source: Origin;
        inputMode: InputMode;
        outputMode: OutputMode;
        autoTransferMode: MovementType;
        detentionLength: integer;
        detentionUnit: UnitLength;
        useByDateLength: integer;
        useByDateUnit: UnitLength;
        sendByDateLength: integer;
        sendByDateUnit: UnitLength;
        sellByDateLength: integer;
        sellByDateUnit: UnitLength;
        fifoTolerance: integer;
        fifoGapUnit: UnitLength;
        netWeight: string;
        netVolume: string;
        pureAlcoholVolume: string;
        price: string;
        material: Risk;
        minimumStock: string;
        alertStock: string;
        maximumStock: string;
        firstArrival: string;
        lastReceipt: string;
        lastOutput: string;
        lastStockCount: string;
        defaultContainer: ProductContainer;
        defaultContainerLevel: ContainerLevel;
        transmittedFromL3: TransmissionL3;
        endOfLife: string;
        isQualityControlManagement: boolean;
        stockStatus: StockNature;
        isSingleLotControl: boolean;
        samplingType: SamplingType;
        generalLevelOfInspection: string;
        aql: string;
        freezingPoint: integer;
        freezingReversibility: ReversibleFreezing;
        ammNo: string;
        referredQuantity: string;
        referredUnit: UnitOfMeasure;
        icpeClass: IcpeClasses;
        flashPoint: integer;
        transportCategory: TransportCategory;
        hazardousMaterialClass: HazardousMaterialsClass;
        tunnelRestriction: string;
        classificationCode: string;
        packagingGroup: PackagingGroup;
        onuCodes: OnuCode;
        solventCode: string;
        technicalField: string;
        isActive: boolean;
        isStockUnitManagement: boolean;
        stockUnit: UnitOfMeasure;
        siteDepositorIdentifier: string;
        suppliersUpcs: ClientCollection<SupplierUpc>;
        productContainers: ClientCollection<ProductContainer>;
        picture: BinaryStream;
        activeMatters: ClientCollection<ProductActiveMattersBinding>;
        isPrintableDescriptions: ClientCollection<ProductIsPrintableDescriptionsBinding>;
        percentageActiveMatters: ClientCollection<ProductPercentageActiveMattersBinding>;
    }
    export interface Product$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        family: QueryOperation<Family>;
        subFamily: QueryOperation<SubFamily>;
        group: QueryOperation<Group>;
        subGroup: QueryOperation<SubGroup>;
        stockCountClass: QueryOperation<StockCountClass>;
        source: QueryOperation<Origin>;
        inputMode: QueryOperation<InputMode>;
        outputMode: QueryOperation<OutputMode>;
        material: QueryOperation<Risk>;
        defaultContainer: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        referredUnit: QueryOperation<UnitOfMeasure>;
        icpeClass: QueryOperation<IcpeClasses>;
        transportCategory: QueryOperation<TransportCategory>;
        hazardousMaterialClass: QueryOperation<HazardousMaterialsClass>;
        onuCodes: QueryOperation<OnuCode>;
        stockUnit: QueryOperation<UnitOfMeasure>;
    }
    export interface Product$Operations {
        query: QueryOperation<Product>;
        read: ReadOperation<Product>;
        aggregate: {
            read: AggregateReadOperation<Product>;
            query: AggregateQueryOperation<Product>;
        };
        lookups(dataOrId: string | { data: ProductInput }): Product$Lookups;
        getDefaults: GetDefaultsOperation<Product>;
    }
    export interface ReceiptMode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isCrossDocking: boolean;
        isExceedQuantityControl: boolean;
        cancelBalanceExpectedInputManagement: CancelationOfEiShortage;
        isReceiptControlListPrint: boolean;
        isAutoAddressing: boolean;
        isExpectedInputLinesNotSettled: boolean;
        isActive: boolean;
        siteDepositorIdentifier: string;
        isDockAssignment: boolean;
        isAutoCreationAuthorized: boolean;
        isAutoDeletionAuthorized: boolean;
        receivingDockStore: Store;
        receivingDockAddress: Location;
        reference: ReceiptReferenceType;
        truckTrackingStatus: TruckTrackingStatus;
        occupationDuration: string;
    }
    export interface ReceiptModeInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isCrossDocking?: boolean | string;
        isExceedQuantityControl?: boolean | string;
        cancelBalanceExpectedInputManagement?: CancelationOfEiShortage;
        isReceiptControlListPrint?: boolean | string;
        isAutoAddressing?: boolean | string;
        isExpectedInputLinesNotSettled?: boolean | string;
        isActive?: boolean | string;
        siteDepositorIdentifier?: string;
        isDockAssignment?: boolean | string;
        isAutoCreationAuthorized?: boolean | string;
        isAutoDeletionAuthorized?: boolean | string;
        receivingDockStore?: string;
        receivingDockAddress?: string;
        reference?: ReceiptReferenceType;
        truckTrackingStatus?: string;
        occupationDuration?: string;
    }
    export interface ReceiptModeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isCrossDocking: boolean;
        isExceedQuantityControl: boolean;
        cancelBalanceExpectedInputManagement: CancelationOfEiShortage;
        isReceiptControlListPrint: boolean;
        isAutoAddressing: boolean;
        isExpectedInputLinesNotSettled: boolean;
        isActive: boolean;
        siteDepositorIdentifier: string;
        isDockAssignment: boolean;
        isAutoCreationAuthorized: boolean;
        isAutoDeletionAuthorized: boolean;
        receivingDockStore: Store;
        receivingDockAddress: Location;
        reference: ReceiptReferenceType;
        truckTrackingStatus: TruckTrackingStatus;
        occupationDuration: string;
    }
    export interface ReceiptMode$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        receivingDockStore: QueryOperation<Store>;
        receivingDockAddress: QueryOperation<Location>;
        truckTrackingStatus: QueryOperation<TruckTrackingStatus>;
    }
    export interface ReceiptMode$Operations {
        query: QueryOperation<ReceiptMode>;
        read: ReadOperation<ReceiptMode>;
        aggregate: {
            read: AggregateReadOperation<ReceiptMode>;
            query: AggregateQueryOperation<ReceiptMode>;
        };
        lookups(dataOrId: string | { data: ReceiptModeInput }): ReceiptMode$Lookups;
        getDefaults: GetDefaultsOperation<ReceiptMode>;
    }
    export interface Risk extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface RiskInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface RiskBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface Risk$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface Risk$Operations {
        query: QueryOperation<Risk>;
        read: ReadOperation<Risk>;
        aggregate: {
            read: AggregateReadOperation<Risk>;
            query: AggregateQueryOperation<Risk>;
        };
        lookups(dataOrId: string | { data: RiskInput }): Risk$Lookups;
        getDefaults: GetDefaultsOperation<Risk>;
    }
    export interface SubFamily extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SubFamilyInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface SubFamilyBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SubFamily$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface SubFamily$Operations {
        query: QueryOperation<SubFamily>;
        read: ReadOperation<SubFamily>;
        aggregate: {
            read: AggregateReadOperation<SubFamily>;
            query: AggregateQueryOperation<SubFamily>;
        };
        lookups(dataOrId: string | { data: SubFamilyInput }): SubFamily$Lookups;
        getDefaults: GetDefaultsOperation<SubFamily>;
    }
    export interface SubGroup extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SubGroupInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface SubGroupBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SubGroup$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface SubGroup$Operations {
        query: QueryOperation<SubGroup>;
        read: ReadOperation<SubGroup>;
        aggregate: {
            read: AggregateReadOperation<SubGroup>;
            query: AggregateQueryOperation<SubGroup>;
        };
        lookups(dataOrId: string | { data: SubGroupInput }): SubGroup$Lookups;
        getDefaults: GetDefaultsOperation<SubGroup>;
    }
    export interface SupplierUpc extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        upcCode: string;
        product: Product;
        container: Container;
        supplier: Supplier;
    }
    export interface SupplierUpcInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        upcCode?: string;
        product?: string;
        container?: string;
        supplier?: string;
    }
    export interface SupplierUpcBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        upcCode: string;
        product: Product;
        container: Container;
        supplier: Supplier;
    }
    export interface SupplierUpc$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        container: QueryOperation<Container>;
        supplier: QueryOperation<Supplier>;
    }
    export interface SupplierUpc$Operations {
        query: QueryOperation<SupplierUpc>;
        read: ReadOperation<SupplierUpc>;
        aggregate: {
            read: AggregateReadOperation<SupplierUpc>;
            query: AggregateQueryOperation<SupplierUpc>;
        };
        lookups(dataOrId: string | { data: SupplierUpcInput }): SupplierUpc$Lookups;
        getDefaults: GetDefaultsOperation<SupplierUpc>;
    }
    export interface TransportCategory extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        maximumMaterialQuantity: integer;
        isUnlimited: boolean;
    }
    export interface TransportCategoryInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        maximumMaterialQuantity?: integer | string;
        isUnlimited?: boolean | string;
    }
    export interface TransportCategoryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        maximumMaterialQuantity: integer;
        isUnlimited: boolean;
    }
    export interface TransportCategory$Lookups {
        site: QueryOperation<Site>;
    }
    export interface TransportCategory$Operations {
        query: QueryOperation<TransportCategory>;
        read: ReadOperation<TransportCategory>;
        aggregate: {
            read: AggregateReadOperation<TransportCategory>;
            query: AggregateQueryOperation<TransportCategory>;
        };
        lookups(dataOrId: string | { data: TransportCategoryInput }): TransportCategory$Lookups;
        getDefaults: GetDefaultsOperation<TransportCategory>;
    }
    export interface LocationExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddresses>;
        product: Product;
        container: Container;
        source: Origin;
        referenceContainer: Container;
        presentContainer: Container;
        superiorContainer: ProductContainer;
    }
    export interface LocationInputExtension {
        site?: string;
        store?: string;
        code?: string;
        storageType?: string;
        storage?: string;
        storeType?: StoreType;
        locationType?: LocationType;
        dockType?: DockType;
        depositor?: string;
        lotNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        numberOfConsumptionUnitPerContainer?: decimal | string;
        rotationClass?: string;
        assignmentClass?: string;
        prohibitedClass?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        maxVolume?: decimal | string;
        maxWeightAuthorized?: decimal | string;
        maxMeters?: decimal | string;
        maximumLoad?: decimal | string;
        dockHeight?: decimal | string;
        storingTime?: decimal | string;
        unStockingTime?: decimal | string;
        presentContainerMaximumQuantity?: decimal | string;
        referenceContainerLevel?: integer | string;
        maximumQuantityInReferenceContainer?: decimal | string;
        quantityInStock?: decimal | string;
        lastStockCount?: string;
        lastReceipt?: string;
        firstArrival?: string;
        fifoDate?: string;
        quantityInPendingInput?: decimal | string;
        quantityInPendingOutput?: decimal | string;
        quantityInPendingReplenish?: decimal | string;
        isBlockedInInput?: boolean | string;
        isBlockedInOutput?: boolean | string;
        isBlockedInInput2?: boolean | string;
        isBlockedInOutput2?: boolean | string;
        isAutoAddressing?: boolean | string;
        isKeyInControlCode?: boolean | string;
        controlCode?: string;
        reorderPoint?: decimal | string;
        replenishmentType?: LocationType;
        replenishmentLevel?: ContainerLevel;
        percentageOccupied?: integer | string;
        parity?: Parity;
        isTemporaryPicking?: boolean | string;
        isPickingPivot?: boolean | string;
        wavePivot?: string;
        pickingPriority?: integer | string;
        isUsed?: boolean | string;
        controlDimension?: ControlOfDimensions;
        isActive?: boolean | string;
        isDockLeveler?: boolean | string;
        completeObjectsAddressingThreshold?: decimal | string;
        splitAddresses?: Partial<LocationSplitAddressesInput>[];
        product?: string;
        container?: string;
        source?: string;
        referenceContainer?: string;
        presentContainer?: string;
        superiorContainer?: string;
    }
    export interface LocationBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddressesBinding>;
        product: Product;
        container: Container;
        source: Origin;
        referenceContainer: Container;
        presentContainer: Container;
        superiorContainer: ProductContainer;
    }
    export interface LocationExtension$Lookups {
        product: QueryOperation<Product>;
        container: QueryOperation<Container>;
        source: QueryOperation<Origin>;
        referenceContainer: QueryOperation<Container>;
        presentContainer: QueryOperation<Container>;
        superiorContainer: QueryOperation<ProductContainer>;
    }
    export interface LocationExtension$Operations {
        lookups(dataOrId: string | { data: LocationInput }): LocationExtension$Lookups;
    }
    export interface Package {
        '@sage/wh-product-data/ActiveMatter': ActiveMatter$Operations;
        '@sage/wh-product-data/Container': Container$Operations;
        '@sage/wh-product-data/ContainersType': ContainersType$Operations;
        '@sage/wh-product-data/Family': Family$Operations;
        '@sage/wh-product-data/Group': Group$Operations;
        '@sage/wh-product-data/HazardousMaterialsClass': HazardousMaterialsClass$Operations;
        '@sage/wh-product-data/IcpeClasses': IcpeClasses$Operations;
        '@sage/wh-product-data/InputModeCreationOfSeparateMovements': InputModeCreationOfSeparateMovements$Operations;
        '@sage/wh-product-data/InputModeInputPriorityInReserveLocations': InputModeInputPriorityInReserveLocations$Operations;
        '@sage/wh-product-data/InputModeMovementLevels': InputModeMovementLevels$Operations;
        '@sage/wh-product-data/InputMode': InputMode$Operations;
        '@sage/wh-product-data/Kits': Kits$Operations;
        '@sage/wh-product-data/OnuCode': OnuCode$Operations;
        '@sage/wh-product-data/Origin': Origin$Operations;
        '@sage/wh-product-data/OutputModeOutputsPriority': OutputModeOutputsPriority$Operations;
        '@sage/wh-product-data/OutputModePickingsPriority': OutputModePickingsPriority$Operations;
        '@sage/wh-product-data/OutputModeReplenishmentsPrioritySorting': OutputModeReplenishmentsPrioritySorting$Operations;
        '@sage/wh-product-data/OutputModeReplenishmentsPriority': OutputModeReplenishmentsPriority$Operations;
        '@sage/wh-product-data/OutputMode': OutputMode$Operations;
        '@sage/wh-product-data/PickingMode': PickingMode$Operations;
        '@sage/wh-product-data/ProductActiveMatters': ProductActiveMatters$Operations;
        '@sage/wh-product-data/ProductContainerContainersInferior': ProductContainerContainersInferior$Operations;
        '@sage/wh-product-data/ProductContainerNumberOfConsumptionUnitPerLevels': ProductContainerNumberOfConsumptionUnitPerLevels$Operations;
        '@sage/wh-product-data/ProductContainerNumberOfStockUnitPerLevels': ProductContainerNumberOfStockUnitPerLevels$Operations;
        '@sage/wh-product-data/ProductContainerProhibitedClasses': ProductContainerProhibitedClasses$Operations;
        '@sage/wh-product-data/ProductContainer': ProductContainer$Operations;
        '@sage/wh-product-data/ProductIsPrintableDescriptions': ProductIsPrintableDescriptions$Operations;
        '@sage/wh-product-data/ProductPercentageActiveMatters': ProductPercentageActiveMatters$Operations;
        '@sage/wh-product-data/Product': Product$Operations;
        '@sage/wh-product-data/ReceiptMode': ReceiptMode$Operations;
        '@sage/wh-product-data/Risk': Risk$Operations;
        '@sage/wh-product-data/SubFamily': SubFamily$Operations;
        '@sage/wh-product-data/SubGroup': SubGroup$Operations;
        '@sage/wh-product-data/SupplierUpc': SupplierUpc$Operations;
        '@sage/wh-product-data/TransportCategory': TransportCategory$Operations;
    }
    export interface GraphApi
        extends Package,
            SageWhMasterData$Package,
            SageWhStructure$Package,
            SageWhSystem$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-product-data-api' {
    export type * from '@sage/wh-product-data-api-partial';
}
declare module '@sage/wh-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-product-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-product-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-product-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-product-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-product-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-master-data-api-partial' {
    import type {
        LocationBindingExtension,
        LocationExtension,
        LocationExtension$Lookups,
        LocationExtension$Operations,
        LocationInputExtension,
    } from '@sage/wh-product-data-api';
    export interface Location extends LocationExtension {}
    export interface LocationBinding extends LocationBindingExtension {}
    export interface LocationInput extends LocationInputExtension {}
    export interface Location$Lookups extends LocationExtension$Lookups {}
    export interface Location$Operations extends LocationExtension$Operations {}
}
