/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const chai_1=require("chai"),lib_1=require("../lib");lib_1.X3ConfigManager.load(__dirname);const currentConfig=lib_1.X3ConfigManager.current,{security}=currentConfig,{secret}=security?.syracuse||{secret:"secret"},testConfig={folderName:"testFolder",session:{userName:"user",login:"login"},xtremServiceUrl:"http://serviceurl.com",sql:{driver:"oracle",hostname:"testServer",database:"testDb"}};describe("Decrypt",()=>{it("throws an error if value is not base64 encoded",()=>{chai_1.assert.throw(()=>lib_1.X3ConfigManager.base64EncodedCheck(JSON.stringify(testConfig)),"Input must be a base64 encoded string")}),it("returns decoded object if iv and encrypted is not present",async()=>{const e=Buffer.from(JSON.stringify({})).toString("base64"),i=await lib_1.X3ConfigManager.decrypt(e,{secret});chai_1.assert.isObject(i,"Decrypted value is not an object"),chai_1.assert.notEqual(i,e)}),it("decrypts the encrypted header value",async()=>{const e=await lib_1.X3ConfigManager.decrypt(Buffer.from(JSON.stringify(await lib_1.X3ConfigManager.encrypt(testConfig,{secret}))).toString("base64"),{secret});chai_1.assert.isObject(e,"Decrypted value is not an object");const{sql:i}=e,{driver:s,hostname:t,database:n}=i;chai_1.assert.equal(s,testConfig.sql.driver,"Decrypted value is not the same as original"),chai_1.assert.equal(t,testConfig.sql.hostname,"Decrypted value is not the same as original"),chai_1.assert.equal(n,testConfig.sql.database,"Decrypted value is not the same as original")})}),describe("validateX3SyncConfig",()=>{describe("when auth configuration is missing",()=>{it("should throw error if auth object is null",()=>{chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(null),"X3 Sync auth configuration is missing")}),it("should throw error if auth object is undefined",()=>{chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(void 0),"X3 Sync auth configuration is missing")})}),describe("when jwksAuthConfig is invalid",()=>{it("should throw error if jwksAuthConfig is missing",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth jwksAuthConfig is missing")}),it("should throw error if audience is undefined",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth jwksAuthConfig is missing required properties.")}),it("should throw error if audience is null",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:null,tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth jwksAuthConfig is missing required properties.")}),it("should throw error if tokenUri is undefined",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth jwksAuthConfig is missing required properties.")}),it("should throw error if tokenUri is null",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:null,cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth jwksAuthConfig is missing required properties.")}),it("should throw error if cloudDomain is undefined",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth jwksAuthConfig is missing required properties.")}),it("should throw error if cloudDomain is null",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:null},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth jwksAuthConfig is missing required properties.")})}),describe("when x3ApiKeyConfig is invalid",()=>{it("should throw error if x3ApiKeyConfig is missing",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth x3ApiKeyConfig is missing")}),it("should throw error if awsSsmParamPath is undefined",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"},x3ApiKeyConfig:{xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth x3ApiKeyConfig is missing required properties.")}),it("should throw error if awsSsmParamPath is null",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:null,xApiKey:"X-API-KEY"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth x3ApiKeyConfig is missing required properties.")}),it("should throw error if xApiKey is undefined",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key"}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth x3ApiKeyConfig is missing required properties.")}),it("should throw error if xApiKey is null",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:null}};chai_1.assert.throws(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e),"X3 Sync auth x3ApiKeyConfig is missing required properties.")})}),describe("when all configuration is valid",()=>{it("should not throw error for valid configuration",()=>{const e={jwksCacheTtlSeconds:600,ssmCacheTtlSeconds:600,jwksAuthConfig:{audience:"test-audience",tokenUri:"https://test.com/.well-known/jwks.json",cloudDomain:"test-domain"},x3ApiKeyConfig:{awsSsmParamPath:"/test/api-key",xApiKey:"X-API-KEY"}};chai_1.assert.doesNotThrow(()=>lib_1.X3ConfigManager.validateX3SyncConfig(e))})})});
//# sourceMappingURL=x3-config-manager-test.js.map