/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3ConfigManager=void 0;const AWS=require("@aws-sdk/client-ssm"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_log_1=require("@sage/xtrem-log"),crypto=require("crypto"),logger=xtrem_log_1.Logger.getLogger(__filename,"config");class X3ConfigManager{static#e;static#r;static get current(){return xtrem_config_1.ConfigManager.current}static#t;static getRegion(){return process.env.AWS_REGION??xtrem_config_1.ConfigManager.current?.aws?.region??"eu-west-1"}static get ssmClient(){if(this.#t)return this.#t;return logger.verbose(()=>`Creating SSM client for region: ${this.getRegion()}`),this.#t=new AWS.SSM({region:this.getRegion()}),this.#t}static async getSsmValue(e){try{logger.verbose(()=>`Getting SSM parameter ${e}`);const r=await this.ssmClient.getParameter({Name:e,WithDecryption:true});if(!r.Parameter||!r.Parameter.Value)throw new Error(`Parameter ${e} not found or has no value`);return logger.verbose(()=>`Returning SSM parameter value from path ${e}.`),r.Parameter.Value}catch(r){if("ParameterNotFound"===r.name)logger.error(`SSM parameter not found: ${e}`);else logger.error(`Error getting SSM parameter ${e}: ${r.message}`);throw new Error(`Error getting parameter ${e}`)}}static async setClientIdSsmValue(){logger.verbose(()=>"Setting clientId from SSM parameter");const e=this.current.security.syracuse?.clientId??"";this.#r=await this.getSsmValue(e.replace("@secret:ssm",""))}static async getClientId(){if(logger.verbose(()=>"Retrieving client id."),this.#r)return logger.verbose(()=>"Client id already set, returning cached value."),this.#r;if(this.isCloud()&&this.current.security.syracuse?.clientId.startsWith("@secret:ssm"))return logger.verbose(()=>"Cloud environment detected, retrieving client id from SSM."),await this.setClientIdSsmValue(),this.#r;if(!this.current.security.syracuse?.clientId)throw new Error("xtrem.security.syracuse.clientId config value must be set");return logger.verbose(()=>"Using clientId from current security syracuse config."),this.#r=this.current.security.syracuse.clientId,this.#r}static async setSecretSsmValue(){logger.verbose(()=>"Setting secret from SSM parameter");const e=this.current.security.syracuse?.secret??"";this.#e=await this.getSsmValue(e.replace("@secret:ssm",""))}static async getSecret(){if(logger.verbose(()=>"Retrieving secret."),this.#e)return logger.verbose(()=>"Secret already set, returning cached value."),this.#e;if(this.isCloud()&&this.current.security.syracuse?.secret.startsWith("@secret:ssm"))return logger.verbose(()=>"Cloud environment detected, retrieving secret from SSM."),await this.setSecretSsmValue(),this.#e;if(!this.current.security.syracuse?.secret)throw new Error("xtrem.security.secret config value must be set");return logger.verbose(()=>"Using secret from current security syracuse config."),this.#e=this.current.security.syracuse.secret,this.#e}static isCloud(){logger.verbose(()=>"Checking if the current environment is cloud.");const e=this.current.x3?.isCloud??false;return logger.verbose(()=>`Current environment is ${e?"cloud":"not cloud"}.`),e}static notLoadedError(){return new Error("Config not loaded!")}static validateX3SyncConfig(e){if(!e)throw logger.error("X3 Sync auth configuration is missing"),new Error("X3 Sync auth configuration is missing");if(!e.jwksAuthConfig)throw logger.error("X3 Sync auth configuration is missing jwksAuthConfig"),new Error("X3 Sync auth jwksAuthConfig is missing");const{jwksAuthConfig:r}=e;if(!r.audience||!r.tokenUri||!r.cloudDomain)throw logger.error("X3 Sync auth jwksAuthConfig is missing required properties."),new Error("X3 Sync auth jwksAuthConfig is missing required properties.");if(!e.x3ApiKeyConfig)throw logger.error("X3 Sync auth configuration is missing x3ApiKeyConfig"),new Error("X3 Sync auth x3ApiKeyConfig is missing");const{x3ApiKeyConfig:t}=e;if(!t.awsSsmParamPath||!t.xApiKey)throw logger.error("X3 Sync auth x3ApiKeyConfig is missing required properties."),new Error("X3 Sync auth x3ApiKeyConfig is missing required properties.")}static load(e){const r=xtrem_config_1.ConfigManager.load(e);if(r.x3?.sync?.auth)this.validateX3SyncConfig(r.x3.sync.auth);return r}static get emitter(){return xtrem_config_1.ConfigManager.emitter}static async encrypt(e,r){logger.verbose(()=>"Encrypt data"),logger.verbose(()=>r?.secret?"Secret provided in options, using it for encryption":"No secret provided in options, call getSecret() to retrieve it for encryption");const t=r?.secret??await X3ConfigManager.getSecret();if(!t)return{iv:"",encrypted:"string"==typeof e?e:JSON.stringify(e)};const i=crypto.createHash("sha256").update(t).digest("base64").substr(0,32),s=crypto.randomBytes(16),n=crypto.createCipheriv("aes-256-cbc",Buffer.from(i),s);let o=n.update("string"==typeof e?e:JSON.stringify(e));return o=Buffer.concat([o,n.final()]),{iv:s.toString("hex"),encrypted:o.toString("hex")}}static base64EncodedCheck(e){if(!/^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$/.test(e))throw new Error("Input must be a base64 encoded string")}static async decrypt(e,r){logger.verbose(()=>"Decrypting data"),logger.verbose(()=>r?.secret?"Secret provided in options, using it for decryption":"No secret provided in options, call getSecret() to retrieve it for decryption");const t=r?.secret??await X3ConfigManager.getSecret();this.base64EncodedCheck(e);const i=JSON.parse(Buffer.from(e,"base64").toString());if(!i.iv&&!i.encrypted)return i;const s=crypto.createHash("sha256").update(String(t)).digest("base64").substr(0,32),n=Buffer.from(i.iv,"hex"),o=Buffer.from(i.encrypted,"hex"),c=crypto.createDecipheriv("aes-256-cbc",Buffer.from(s),n);let a=c.update(o);return a=Buffer.concat([a,c.final()]),JSON.parse(a.toString())}}exports.X3ConfigManager=X3ConfigManager;
//# sourceMappingURL=x3-config-manager.js.map