import * as AWS from '@aws-sdk/client-ssm';
import { Config, SecurityConfig } from '@sage/xtrem-shared';
import { EventEmitter } from 'events';
export interface X3SecurityConfig extends SecurityConfig {
    syracuse?: {
        clientId: string;
        secret: string;
        clockToleranceSeconds?: number;
    };
}
export interface X3ServiceAgentConfig {
    traceInterval: number;
}
export interface X3SqlConfig {
    driver: string;
    hostname: string;
    port: number;
    database: string;
    user: string;
    password: string;
    poolSize: number;
}
export interface X3ApiConfig {
    url: string;
    secret: string;
    userCredentials: X3UserCredentialsConfig;
    origin?: string;
}
export interface X3SoapConfig {
    webServiceURL: string;
    userCredentials: X3UserCredentialsConfig;
    codeLang: string;
    poolAlias: string;
    timeout: number;
}
export interface X3UserCredentialsConfig {
    userName: string;
    password: string;
}
export interface X3DevelopmentConfig {
    folderName: string;
    referenceFolder: string;
    defaultLanguage: string;
    soap: X3SoapConfig;
    api: X3ApiConfig;
    multiWorkerServiceDisabled?: boolean;
}
export interface X3Config {
    isCloud: boolean;
    agent?: X3ServiceAgentConfig;
    sql?: X3SqlConfig;
    development?: X3DevelopmentConfig;
    sync?: X3SyncConfig;
}
export interface X3SyncConfig {
    maxPageSize?: number;
    maxStreamBatchSize?: number;
    auth: X3SyncAuthConfig;
}
export interface X3SyncAuthConfig {
    jwksCacheTtlSeconds?: number;
    ssmCacheTtlSeconds?: number;
    jwksAuthConfig: X3SyncAuthJwksConfig;
    x3ApiKeyConfig: X3SyncAuthApiKeyConfig;
}
export interface X3SyncAuthJwksConfig {
    audience: string;
    tokenUri: string;
    cloudDomain: string;
}
export interface X3SyncAuthApiKeyConfig {
    awsSsmParamPath: string;
    xApiKey: string;
}
export interface X3XtremConfig extends Config {
    security: X3SecurityConfig;
    x3?: X3Config;
    folderName?: string;
}
export declare class X3ConfigManager {
    #private;
    static get current(): X3XtremConfig;
    static getRegion(): string;
    static get ssmClient(): AWS.SSM;
    static getSsmValue(ssmParamPath: string): Promise<string>;
    private static setClientIdSsmValue;
    static getClientId(): Promise<string>;
    private static setSecretSsmValue;
    static getSecret(): Promise<string>;
    static isCloud(): boolean;
    static notLoadedError(): Error;
    static validateX3SyncConfig(auth: X3SyncAuthConfig): void;
    static load(dir: string): X3XtremConfig;
    static get emitter(): EventEmitter;
    /**
     * encrypt using shared secret
     * @param data
     * @returns
     */
    static encrypt(data: any, options?: {
        secret?: string;
    }): Promise<{
        iv: string;
        encrypted: string;
    }>;
    static base64EncodedCheck(b64: string): void;
    static decrypt(b64: string, options?: {
        secret?: string;
    }): Promise<any>;
}
//# sourceMappingURL=x3-config-manager.d.ts.map