/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getSystemInfo=getSystemInfo,exports.compileAllFiles=compileAllFiles,exports.compileFile=compileFile;const fs=require("fs"),os=require("os"),path=require("path"),minifier=require("terser"),rootDir=path.resolve(__dirname,"../../../.."),encoding="utf8";function getSystemInfo(){return{nodeVersion:process.version,arch:os.arch()}}async function minifyCode(e,r){const{filename:i}=r||{};let o="";const t=`${i}.map`;if(i&&fs.existsSync(t))o=fs.readFileSync(t,"utf-8");const n=Array.from(e.matchAll(/const ([a-zA-Z0-9_]+) = require\(/g)).map(e=>e[1]).filter(e=>e.startsWith("xtrem"));try{return await minifier.minify(e,{keep_fnames:true,mangle:{reserved:["typesLib",...n]},compress:r?.compress?{booleans:false,booleans_as_integers:false,conditionals:false,reduce_vars:false,if_return:false}:false,output:{preamble:`/* Copyright (c) 2020-${(new Date).getFullYear()} The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */`},sourceMap:{content:o,url:path.basename(t)},ecma:2020})}catch(e){throw new Error(`Error minifying ${i?.substring(rootDir.length+1)}: ${e instanceof Error?e.message:e}`)}}async function compileAllFiles(e,r,i){await Promise.all(r.map(async e=>{await compileFile({...i,minify:true,filename:e})}))}async function compileFile(e){const{verbose:r,filename:i,minify:o}=e,t=void 0===e.compileAsModule?true:e.compileAsModule,n=".js",s=e.output||`${i.slice(0,-3)}${n}`,a=fs.readFileSync(i,encoding).replace(/^#!.*/,""),l={...e,filename:i,compileAsModule:t,minify:o,replacementSource:void 0},{code:c,map:f}=await minifyCode(a,l);if(void 0===c)throw new Error(`Failed to compile ${i}. No code returned from minifier.`);if(r)console.log(`Compiled ${i?.substring(rootDir.length+1)} (${Buffer.byteLength(a)} bytes) to ${s?.substring(rootDir.length+1)} (${Buffer.byteLength(c)} bytes) `);if(fs.writeFileSync(s,c,{encoding}),f)fs.writeFileSync(`${s}.map`,"string"==typeof f?f:JSON.stringify(f),{encoding});return s}
//# sourceMappingURL=minify.js.map