interface BaseCompileOptions {
    output?: string;
    compileAsModule?: boolean;
    getPreservedRanges?: (source: string) => [number, number][];
    compress?: boolean;
    minify?: boolean;
    verbose?: boolean;
}
export interface CompileFileArguments extends BaseCompileOptions {
    filename: string;
}
export interface CompileOptions extends BaseCompileOptions {
    replacementSource?: Buffer;
    module?: boolean;
}
export interface CompileCodeOptions extends CompileOptions {
    filename: string;
}
export interface SystemInfo {
    nodeVersion: string;
    arch: string;
}
export interface Content {
    systemInfo: Uint8Array;
    dummyCode: Uint8Array;
    bytecodeBuffer: Uint8Array;
}
export declare function getSystemInfo(): SystemInfo;
export declare function compileAllFiles(packageDir: string, files: string[], options: CompileOptions): Promise<void>;
/**
 * Compiles JavaScript file to a minified .js file.
 * @param   options
 * @returns The compiled filename
 */
export declare function compileFile(options: CompileCodeOptions): Promise<string>;
export {};
//# sourceMappingURL=minify.d.ts.map