/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const child_process_1=require("child_process"),fs=require("fs"),glob=require("glob"),path=require("path"),xtremBuild=require("./index.js"),args=process.argv.slice(2);if(args.includes("-c"))args[args.indexOf("-c")]="--compile";if(args.includes("-h"))args[args.indexOf("-h")]="--help";if(args.includes("-v"))args[args.indexOf("-v")]="--version";if(args.includes("-z"))args[args.indexOf("-z")]="--compress";if(args.includes("-e")||args.includes("--source"))throw new Error("The `-e` or `--source` option is not supported anymore. Use `--compile` with a file or a list of files instead.");if(args.includes("-d")||args.includes("--delete-source"))console.warn("The `-d` or `--delete-source` option is deprecated.");class Program{constructor(){this.dirname=__dirname,this.filename=__filename,this.nodeBin=process.argv[0],this.flags=args.filter(e=>"-"===e[0]&&"-"===e[1]),this.inclusions=args.filter(e=>"-"!==e[0]&&"-"!==e[1]),this.exclusions=args.filter(e=>"-"===e[0]&&"-"!==e[1]).map(e=>e.substring(1)),this.files=[]}async compile(){const e=require(path.join(dir,"package.json")),s=e.main;if(s)this.exclusions.push(s);const i=this.exclusions.map(e=>path.resolve(e)),r=[];if(0===this.inclusions.length&&!this.flags.includes("--source"))r.push(`${dir}/**/*.js`);else this.inclusions.forEach(e=>r.push(path.resolve(e)));if(this.files=glob.sync(r,{ignore:i}),!this.files?.length)console.warn(`No files to process in '${dir}'.`),process.exit(0);return await Promise.all(this.files.map(async s=>{const i=path.resolve(s);if(fs.existsSync(i)&&fs.statSync(i).isFile()){const s=!this.flags.includes("--no-module");try{const r={filename:i,compileAsModule:s,compress,minify:true,module:"module"===e.type};await xtremBuild.compileFile({...r})}catch(e){console.error(e)}}else console.error(`Error: Cannot find file '${i}'.`)})),this}}const program=new Program,compress=program.flags.includes("--compress"),dir=process.cwd(),startedAt=Date.now();if(program.flags.includes("--compile"))program.compile().then(()=>{const{files:e}=program;console.log(`Compiled to binary(minify) ${e.length} file${1===e.length?"":"s"} in ${Date.now()-startedAt}ms.`)}).catch(e=>{console.error(e),process.exit(1)});else if(program.flags.includes("--help"))console.log("\n  Usage: xtrem-minify [option] [ FILE... | - ] [arguments]\n\n  Options:\n    -c, --compile [ FILE... | - ]     compile stdin, a file, or a list of files\n      --no-module                   compile without producing commonjs module\n    -h, --help                        show help information.\n    -v, --version                     show xtrem-minify version.\n    -z, --compress                    compress binary source\n\n  Examples:\n\n  $ xtrem-minify -c script.js             compile 'script.js' in-place to its minitied version.\n  $ xtrem-minify -c server.js app.js\n  $ xtrem-minify -c                       compile all '.js' files in 'build/' directory.\n  $ xtrem-minify -c src/*.js              compile all '.js' files in 'src/' directory.\n  $ xtrem-minify                          open Node REPL with xtrem-minify pre-loaded.\n");else if(program.flags.includes("--version")&&1===program.flags.length&&0===program.inclusions.length){const e=require("./package.json");console.log(e.name,e.version)}else try{(0,child_process_1.spawnSync)(program.nodeBin,["-r",path.resolve(__dirname,"index.js")].concat(args),{stdio:"inherit"})}catch(e){console.error(e)}
//# sourceMappingURL=cli.js.map