/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.adapters;

import java.io.Serializable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.Provider;
import org.picocontainer.injectors.ProviderAdapter;
import org.picocontainer.monitors.AbstractComponentMonitor;
import org.picocontainer.monitors.NullComponentMonitor;

public abstract class AbstractAdapter<T>
implements ComponentAdapter<T>,
ComponentMonitorStrategy,
Serializable {
    private Object componentKey;
    private Class<T> componentImplementation;
    private ComponentMonitor componentMonitor;

    public AbstractAdapter(Object componentKey, Class componentImplementation) {
        this(componentKey, componentImplementation, new AbstractComponentMonitor());
        this.componentMonitor = new NullComponentMonitor();
    }

    public AbstractAdapter(Object componentKey, Class componentImplementation, ComponentMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("ComponentMonitor==null");
        }
        this.componentMonitor = monitor;
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
        this.checkTypeCompatibility();
    }

    @Override
    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    @Override
    public Class<? extends T> getComponentImplementation() {
        return this.componentImplementation;
    }

    protected void checkTypeCompatibility() {
        if (this.componentKey instanceof Class) {
            Class componentType = (Class)this.componentKey;
            if (Provider.class.isAssignableFrom(this.componentImplementation) ? !componentType.isAssignableFrom(ProviderAdapter.getProvideMethod(this.componentImplementation).getReturnType()) : !componentType.isAssignableFrom(this.componentImplementation)) {
                throw this.newCCE(componentType);
            }
        }
    }

    private ClassCastException newCCE(Class<?> componentType) {
        return new ClassCastException(this.componentImplementation.getName() + " is not a " + componentType.getName());
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, null);
    }

    public String toString() {
        return this.getDescriptor() + this.getComponentKey();
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter(this);
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        this.componentMonitor = monitor;
    }

    @Override
    public ComponentMonitor currentMonitor() {
        return this.componentMonitor;
    }

    @Override
    public final ComponentAdapter<T> getDelegate() {
        return null;
    }

    @Override
    public final <U extends ComponentAdapter> U findAdapterOfType(Class<U> adapterType) {
        if (adapterType.isAssignableFrom(this.getClass())) {
            return (U)this;
        }
        if (this.getDelegate() != null) {
            return this.getDelegate().findAdapterOfType(adapterType);
        }
        return null;
    }
}

