/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.target.TargetPanel;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetNewPanel
extends TargetPanel {
    private static final long serialVersionUID = 4462248660406450482L;
    private static Logger logger = Logger.getLogger(TargetNewPanel.class.getName());
    private static final String logPrefix = "TargetNewPanel - ";

    public TargetNewPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, resources, log);
    }

    @Override
    public void panelActivate() {
        logger.log(Level.FINE, "TargetNewPanel - panelActivate");
        super.panelActivate();
        logger.log(Level.FINE, "TargetNewPanel - panelActivate  Path: " + this.pathSelectionPanel.getPath());
    }

    @Override
    public void saveData() {
        logger.log(Level.FINE, "TargetNewPanel - saveData");
        String platformSep = "[\\\\\\/]";
        int positionFromEnd = 0;
        String variableNameRaw = this.getMetadata().getConfigurationOptionValue("SetVariableName", this.installData.getRules());
        String variableName = null;
        logger.log(Level.FINE, "TargetNewPanel - saveData variableNameRaw: " + variableNameRaw);
        if (variableNameRaw != null && variableNameRaw.indexOf("${") >= 0 && variableNameRaw.indexOf("}") >= 0) {
            variableName = variableNameRaw.substring(variableNameRaw.indexOf("${") + 2, variableNameRaw.indexOf("}"));
            String[] pathElements = variableNameRaw.split(platformSep);
            for (int i = 0; i < pathElements.length; ++i) {
                String part = pathElements[i];
                if (!part.equals(variableName)) continue;
                positionFromEnd = pathElements.length - 1 - i;
            }
            logger.log(Level.FINE, "TargetNewPanel - saveData variableName: '" + variableName + "'  positionFromEnd: " + positionFromEnd);
        }
        super.saveData();
        String path = this.pathSelectionPanel.getPath();
        logger.log(Level.FINE, "TargetNewPanel - saveData Path: " + path);
        if (variableName != null) {
            String[] pathElements = path.split(platformSep);
            String variableValue = pathElements[pathElements.length - 1 - positionFromEnd];
            this.installData.setVariable(variableName, variableValue);
            logger.log(Level.FINE, "TargetNewPanel - saveData path: " + path + "  setVariable  '" + variableName + "': " + variableValue);
        }
    }

    @Override
    public boolean isValidated() {
        boolean result = false;
        String path = this.pathSelectionPanel.getPath();
        File targetPathFile = new File(this.installData.getVariables().replace(path));
        boolean modifyinstallation = ModifyInstallationUtil.get(this.installData);
        logger.log(Level.FINE, "TargetNewPanel - isValidated Path: " + path + "  targetPathFile: " + targetPathFile);
        if (StringUtil.isNullOrBlank(path)) {
            this.emitError(this.error, "You have not specified a target location ! ");
            return false;
        }
        if (targetPathFile.exists() ? !this.checkOverwrite(targetPathFile) : !this.checkCreateDirectory(targetPathFile)) {
            return false;
        }
        if (modifyinstallation && InstallationInformationHelper.isIncompatibleInstallation(path, InstallationInformationHelper.isReadInformation(this.installData))) {
            this.emitError(this.error, this.getMessage("incompatibleInstallation"));
            return false;
        }
        if (targetPathFile.isFile()) {
            this.emitError(this.error, this.getMessage("isfile"));
            return false;
        }
        path = this.installData.getVariables().replace(path);
        this.installData.setInstallPath(path);
        result = true;
        logger.log(Level.FINE, "TargetNewPanel - isValidated Path: " + path + "  result: " + result);
        return result;
    }
}

