/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.resource.DefaultLocales;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourcesHelper {
    private Resources resources = null;
    private LocaleDatabase langpack = null;
    private LocaleDatabase customResources = null;
    private String customResourcesPath = null;
    private InstallData installData;
    private static Logger logger = Logger.getLogger(ResourcesHelper.class.getName());
    private static String LogPrefix = "ResourcesHelper - ";

    public ResourcesHelper(InstallData installData, Resources resources) {
        this.installData = installData;
        this.resources = resources;
    }

    public static String getCustomPropString(String key) {
        return ResourcesHelper.getCustomPropString(key, null);
    }

    public static String getCustomPropString(String key, String arg1) {
        String result = null;
        try {
            result = ResourceBundle.getBundle("/com/sage/izpack/messages").getString(key);
            logger.log(Level.FINE, LogPrefix + "getCustomPropString  get '" + key + "': '" + result + "'  ");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, LogPrefix + "Cannot get resource " + key + " : " + exception);
            exception.printStackTrace();
        }
        if (result != null && arg1 != null) {
            result = String.format(result, arg1);
        }
        return result;
    }

    private String getLocaleIso3() {
        if (this.installData != null) {
            return this.installData.getLocaleISO3();
        }
        return this.getLocale().getISO3Language();
    }

    private Locale getLocale() {
        Locale result = null;
        if (this.installData != null) {
            result = this.installData.getLocale();
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        if (result == null) {
            result = Locale.ENGLISH;
        }
        return result;
    }

    public void mergeCustomMessages() {
        this.mergeCustomMessages(this.installData.getMessages());
    }

    public void mergeCustomMessages(Messages messages) {
        this.initializeResources();
        logger.log(Level.FINE, LogPrefix + "mergeCustomMessages  from " + this.customResourcesPath + "  GetLocale():" + this.getLocaleIso3());
        Messages messagesM = messages;
        if (this.customResources != null) {
            messagesM.add(this.customResources);
        }
    }

    public String getCustomString(String key) {
        return this.getCustomString(key, null);
    }

    public String getCustomString(String key, String arg1) {
        this.initializeResources();
        String result = null;
        try {
            result = this.customResources.get(key);
            if (result != null && arg1 != null) {
                result = String.format(result, arg1);
            }
            logger.log(Level.FINE, LogPrefix + "getCustomString  get '" + key + "': '" + result + "'  from " + this.customResourcesPath + "  GetLocale():" + this.getLocaleIso3());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogPrefix + "Cannot get resource " + key + " " + this.customResourcesPath + "GetLocale(): " + this.getLocaleIso3() + " : " + ex);
            ex.printStackTrace();
        }
        return result;
    }

    private String getSafeLocale() {
        String defaultLangISO3 = this.getLocale().getISO3Language();
        String defaultLangISO2 = this.getLocale().getLanguage();
        String lang = defaultLangISO3;
        if (this.installData != null) {
            lang = this.installData.getLocaleISO3();
        }
        if (lang == null) {
            if (this.installData != null && this.installData.getLocale() != null) {
                lang = this.installData.getLocale().getISO3Language();
            }
            if (lang == null && this.installData != null) {
                lang = this.installData.getVariable("ISO3_LANG");
            }
            if (lang == null) {
                lang = defaultLangISO3;
                logger.log(Level.FINE, LogPrefix + "getSafeLocale.  Force ISO3_LANG=" + lang);
            }
        }
        if (this.installData != null) {
            if (this.installData.getVariable("ISO3_LANG") == null) {
                this.installData.setVariable("ISO3_LANG", lang);
            }
            if (this.installData.getVariable("ISO2_LANG") == null) {
                this.installData.setVariable("ISO2_LANG", defaultLangISO2);
            }
            if (this.installData.getLocale() == null && this.installData instanceof AutomatedInstallData) {
                ((AutomatedInstallData)this.installData).setLocale(Locale.ENGLISH, lang);
            }
        }
        return lang;
    }

    private void initializeResources() {
        String lang = this.getSafeLocale();
        try {
            if (this.customResourcesPath == null) {
                this.customResourcesPath = "/com/sage/izpack/langpacks/" + lang + ".xml";
            }
            if (this.customResources == null) {
                DefaultLocales locales = new DefaultLocales(this.resources, this.getLocale());
                this.customResources = new LocaleDatabase(this.getClass().getResourceAsStream(this.customResourcesPath), (Locales)locales);
            }
            logger.log(Level.FINE, LogPrefix + "getCustomString  initialized from " + this.customResourcesPath + "  GetSafeLocale():" + lang);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogPrefix + "Cannot be initialized " + this.customResourcesPath + "GetLocale(): " + lang + " : " + ex);
            ex.printStackTrace();
        }
    }

    public String getProjectString(String key) {
        String result = null;
        try {
            if (this.langpack == null) {
                DefaultLocales locales = new DefaultLocales(this.resources, this.installData.getLocale());
                this.langpack = new LocaleDatabase(ResourcesHelper.class.getResourceAsStream("/langpack" + this.installData.getLocaleISO3() + ".xml"), (Locales)locales);
            }
            result = this.langpack.get(key);
            logger.log(Level.FINE, LogPrefix + "getProjectString  get '" + key + "': '" + result + "'  ");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, LogPrefix + "Cannot get resource " + key + " : " + exception);
        }
        return result;
    }
}

