/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RegistryHandlerX3 {
    private static final Logger logger = Logger.getLogger(RegistryHandlerX3.class.getName());
    private RegistryHandler registryHandler;
    private InstallData installData;
    public static String ADX_NODE_TYPE = "component.node.type";
    public static String ADX_NODE_FAMILY = "component.node.family";
    private static final String SPEC_FILE_NAME = "productsSpec.txt";
    private static final String LogPrefix = "RegistryHandlerX3 - ";
    public static final String AdxAdmFileWindows = "c:\\sage\\adxadm";
    public static final String AdxAdmFileLinux = "/sage/adxadm";

    public RegistryHandlerX3(RegistryHandler registryHandler, InstallData installData) {
        this.registryHandler = registryHandler;
        this.installData = installData;
    }

    public RegistryHandler getRegistryHandler() {
        return this.registryHandler;
    }

    public InstallData getInstallData() {
        return this.installData;
    }

    public boolean isAdminSetup() {
        String isAdxAdmin;
        String string = isAdxAdmin = this.installData != null ? this.installData.getVariable("is-adxadmin") : null;
        return isAdxAdmin != null && isAdxAdmin.equalsIgnoreCase("true");
    }

    public boolean needAdxAdmin() {
        String needAdxAdmin;
        String string = needAdxAdmin = this.installData != null ? this.installData.getVariable("need-adxadmin") : null;
        return needAdxAdmin != null && needAdxAdmin.equalsIgnoreCase("true");
    }

    public boolean adxadminProductRegistered() throws NativeLibException {
        String adxAdminPath = this.getAdxAdminDirPath();
        logger.log(Level.FINE, "RegistryHandlerX3 - adxadminProductRegistered. adxAdminPath: " + adxAdminPath + "  result: " + (adxAdminPath != null));
        return adxAdminPath != null;
    }

    public String getAdxAdminDirPath() throws NativeLibException {
        if (OsVersion.IS_UNIX) {
            return this.getAdxAdminPathUnix();
        }
        return this.getAdxAdminPathWin();
    }

    private String getAdxAdminPathWin() throws NativeLibException {
        String adxAdminPath = null;
        File adxadmFile = this.getWinPath();
        if (adxadmFile != null) {
            adxAdminPath = this.readAdxAdmFile(adxadmFile);
        }
        if (adxAdminPath != null) {
            logger.log(Level.FINE, "RegistryHandlerX3 - getAdxAdminPathWin. adxAdminPath from " + adxadmFile.getAbsolutePath() + ": '" + adxAdminPath + "'");
            return adxAdminPath;
        }
        int oldVal = this.registryHandler.getRoot();
        this.registryHandler.setRoot(-2147483646);
        boolean exists64bits = this.registryHandler.keyExist("SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN");
        if (exists64bits) {
            adxAdminPath = this.registryHandler.getValue("SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN", "ADXDIR").getStringData();
        }
        this.registryHandler.setRoot(oldVal);
        logger.log(Level.FINE, "RegistryHandlerX3 - getAdxAdminPathWin. adxAdminPath from registry: '" + adxAdminPath + "'");
        return adxAdminPath;
    }

    private String getAdxAdminPathUnix() {
        File adxadmFile = this.getUnixPath();
        return this.readAdxAdmFile(adxadmFile);
    }

    private File getWinPath() {
        String path = AdxAdmFileWindows;
        return this.getFile(path);
    }

    private File getUnixPath() {
        String path = AdxAdmFileLinux;
        return this.getFile(path);
    }

    private File getFile(String path) {
        File adxadmFile = new File(path);
        if (!adxadmFile.exists()) {
            return null;
        }
        return adxadmFile;
    }

    private String readAdxAdmFile(File adxadmFile) {
        String adxAdminPath = null;
        if (adxadmFile == null) {
            logger.log(Level.WARNING, "RegistryHandlerX3 - readAdxAdmFile. Cannot open NULL file");
            return null;
        }
        try {
            logger.log(Level.FINE, "RegistryHandlerX3 - readAdxAdmFile. Reading file '" + adxadmFile.getAbsolutePath() + "'");
            FileReader readerAdxAdmFile = new FileReader(adxadmFile);
            BufferedReader buffread = new BufferedReader(readerAdxAdmFile);
            adxAdminPath = buffread.readLine();
            if (adxAdminPath != null) {
                adxAdminPath = adxAdminPath.trim();
            }
            buffread.close();
            logger.log(Level.FINE, "RegistryHandlerX3 - readAdxAdmFile. adxAdminPath: '" + adxAdminPath + "'");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "RegistryHandlerX3 - readAdxAdmFile. Cannot open file '" + adxadmFile + "'");
            e.printStackTrace();
        }
        return adxAdminPath;
    }

    public HashMap<String, String[]> loadComponentsList() throws Exception {
        if (this.needAdxAdmin()) {
            return this.loadListFromAdxadmin();
        }
        if (OsVersion.IS_WINDOWS) {
            return this.loadListFromRegistry();
        }
        throw new Exception("installer.errorInstallationTypePanel.errNoCompFound");
    }

    private HashMap<String, String[]> loadListFromAdxadmin() {
        HashMap<String, String[]> lstCompPropsParam = new HashMap<String, String[]>();
        try {
            String adxAdminPath = this.getAdxAdminDirPath();
            if (adxAdminPath == null || adxAdminPath.isEmpty()) {
                logger.log(Level.WARNING, "RegistryHandlerX3 - loadListFromAdxadmin error while retrieve AdxAdminDirPath=" + adxAdminPath);
                return lstCompPropsParam;
            }
            File dirAdxDir = new File(adxAdminPath);
            if (!dirAdxDir.exists() || !dirAdxDir.isDirectory()) {
                logger.log(Level.WARNING, "RegistryHandlerX3 - loadListFromAdxadmin error while reading AdxAdminDirPath=" + dirAdxDir.getAbsolutePath());
                return lstCompPropsParam;
            }
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(dirAdxDir.getAbsolutePath());
            strBuilder.append(File.separator);
            strBuilder.append("inst");
            strBuilder.append(File.separator);
            strBuilder.append("adxinstalls.xml");
            File fileAdxinstalls = new File(strBuilder.toString());
            if (!fileAdxinstalls.exists()) {
                logger.log(Level.WARNING, "RegistryHandlerX3 - loadListFromAdxadmin error - File " + fileAdxinstalls.getAbsolutePath() + " doesn't exist.");
                return lstCompPropsParam;
            }
            String strComponentType = this.getInstallData().getVariable(ADX_NODE_TYPE);
            String strComponentFamily = this.getInstallData().getVariable(ADX_NODE_FAMILY);
            if (strComponentFamily == null) {
                return lstCompPropsParam;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fileAdxinstalls);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "//module[@family='" + strComponentFamily + "'";
            if (!StringUtil.isNullOrBlank(strComponentType)) {
                expression = expression + " and @type='" + strComponentType + "'";
            }
            expression = expression + "]";
            NodeList nodeLst = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeLst.getLength(); ++i) {
                String key;
                Element moduleNode = (Element)nodeLst.item(i);
                String path = xPath.evaluate("./component." + strComponentFamily.toLowerCase() + ".path", moduleNode);
                String versionString = xPath.evaluate("./component." + strComponentFamily.toLowerCase() + ".version", moduleNode);
                String name = moduleNode.getAttribute("name");
                File installInformation = new File(path + File.separator + ".installationinformation");
                if (installInformation.exists()) {
                    key = name + " " + versionString + " (" + path + ")";
                    lstCompPropsParam.put(key, new String[]{name, path, versionString});
                    continue;
                }
                if (!path.endsWith(File.separator + "tool") || !(installInformation = new File((path = path.substring(0, path.length() - 5)) + File.separator + ".installationinformation")).exists()) continue;
                key = name + " " + versionString + " (" + path + ")";
                lstCompPropsParam.put(key, new String[]{name, path, versionString});
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "RegistryHandlerX3 - loadListFromAdxadmin error : " + ex);
            ex.printStackTrace();
        }
        logger.log(Level.FINE, "RegistryHandlerX3 - loadListFromAdxadmin returns:" + lstCompPropsParam);
        return lstCompPropsParam;
    }

    private HashMap<String, String[]> loadListFromRegistry() {
        HashMap<String, String[]> lstCompPropsParam = new HashMap<String, String[]>();
        try {
            String uninstallName = this.installData.getVariable("UNINSTALL_NAME");
            String uninstallKeySuffix = this.installData.getVariable("UninstallKeySuffix");
            String uninstallKeyPrefix = new String(uninstallName);
            ArrayList<String> uninstallKeyPrefixList = new ArrayList<String>();
            if (!StringUtil.isNullOrBlank(uninstallKeyPrefix)) {
                uninstallKeyPrefix = uninstallKeyPrefix.substring(0, uninstallKeyPrefix.length() - uninstallKeySuffix.length());
            }
            uninstallKeyPrefixList.add(uninstallKeyPrefix);
            logger.log(Level.FINE, "RegistryHandlerX3 - loadListFromRegistry - Add '" + uninstallKeyPrefix + "' - uninstallName: " + uninstallName + " uninstallKeySuffix: " + uninstallKeySuffix);
            try {
                InputStream input = new ResourceManager().getInputStream(SPEC_FILE_NAME);
                if (input != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    while ((line = reader.readLine()) != null) {
                        String itemToAdd = line.trim();
                        if (uninstallKeyPrefixList.contains(itemToAdd)) continue;
                        uninstallKeyPrefixList.add(itemToAdd);
                        logger.log(Level.FINE, "RegistryHandlerX3 - loadListFromRegistry - Add '" + uninstallKeyPrefix + "'  from " + SPEC_FILE_NAME);
                    }
                    reader.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "RegistryHandlerX3 - Error while loading productsSpec.txt : " + ex);
            }
            RegistryHandler rh = this.registryHandler;
            if (rh == null) {
                return lstCompPropsParam;
            }
            String uninstallKeyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
            int oldVal = rh.getRoot();
            rh.setRoot(-2147483646);
            List<String> lstSubKeys = Arrays.asList(rh.getSubkeys(uninstallKeyName));
            for (String uninstallKey : lstSubKeys) {
                for (String keyToSearchFor : uninstallKeyPrefixList) {
                    File installInformation;
                    if (!uninstallKey.startsWith(keyToSearchFor)) continue;
                    String productPath = null;
                    try {
                        productPath = rh.getValue(uninstallKeyName + "\\" + uninstallKey, "UninstallString").getStringData();
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    String productVersion = null;
                    try {
                        productVersion = rh.getValue(uninstallKeyName + "\\" + uninstallKey, "DisplayVersion").getStringData();
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    productPath = productPath.substring(productPath.lastIndexOf("\"", productPath.length() - 2) + 1, productPath.length() - 29);
                    String name = uninstallKey;
                    if (name.indexOf(" - ") > 0) {
                        name = name.substring(name.indexOf(" - ") + 3);
                    }
                    if (!(installInformation = new File(productPath + File.separator + ".installationinformation")).exists()) continue;
                    String key = name + " " + productVersion + " (" + productPath + ")";
                    lstCompPropsParam.put(key, new String[]{name, productPath, productVersion});
                    logger.log(Level.FINE, "RegistryHandlerX3 - loadListFromRegistry - add final key '" + key + "' - keyToSearchFor: " + keyToSearchFor + " productPath:" + productPath + " productVersion:" + productVersion + " uninstallKey: " + uninstallKey);
                }
            }
            rh.setRoot(oldVal);
        }
        catch (Exception ex) {
            logger.log(Level.ALL, "RegistryHandlerX3 - loadListFromRegistry error : " + ex);
        }
        return lstCompPropsParam;
    }
}

