/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.PreValidateXtremSyracuseConnection;
import com.sage.izpack.ServiceWinHelper;
import com.sage.izpack.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreValidateXtremCheckedAlreadyInstalled
implements PanelAction {
    private static final Logger logger = Logger.getLogger(PreValidateXtremSyracuseConnection.class.getName());
    private static final String logPrefix = "PreValidateXtremCheckedAlreadyInstalled - ";
    private RegistryHandler registryHandler;
    private String serviceName;

    public PreValidateXtremCheckedAlreadyInstalled(RegistryDefaultHandler handler) {
        this.registryHandler = handler.getInstance();
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler uiHandler) {
        boolean serviceExists;
        logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - executeAction.");
        if (OsVersion.IS_LINUX) {
            logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - executeAction done");
            return;
        }
        boolean updateMode = ModifyInstallationUtil.get(installData);
        logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - executeAction. Skip service '" + this.serviceName + "' verification. UpdateMode=" + updateMode);
        if (!updateMode && (serviceExists = ServiceWinHelper.doesServiceExist(this.serviceName))) {
            logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - Service '" + this.serviceName + "' found. Set ModifyInstallation=" + serviceExists);
            ModifyInstallationUtil.set(installData, serviceExists);
            String installPath = PreValidateXtremCheckedAlreadyInstalled.getInstallPath(this.serviceName);
            if (!StringUtil.isNullOrBlank(installPath)) {
                logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - InstallPath detected: " + installPath);
                if (OsVersion.IS_WINDOWS) {
                    installData.setVariable("TargetPanel.dir.windows", installPath);
                }
                installData.setInstallPath(installPath);
                installData.setVariable("update.from.previouszip", "true");
            }
            logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - executeAction done. Service '" + this.serviceName + "' found. Set ModifyInstallation=" + serviceExists);
        }
    }

    @Override
    public void initialize(PanelActionConfiguration actionConfiguration) {
        String serviceName;
        logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - initialize.");
        this.serviceName = serviceName = actionConfiguration.getProperty("servicename");
        logger.log(Level.FINE, "PreValidateXtremCheckedAlreadyInstalled - initialize. ServiceName: " + serviceName);
    }

    public static String getInstallPath(String serviceName) {
        String result = null;
        if (StringUtil.isNullOrBlank(serviceName)) {
            logger.log(Level.WARNING, "PreValidateXtremCheckedAlreadyInstalled - getInstallPath(ServiceName=NULL). Cannot check service.");
            return result;
        }
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("sc", "qc", serviceName);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("BINARY_PATH_NAME")) continue;
                String pathExe = line.substring(line.indexOf(58) + 1);
                pathExe = StringUtil.trim(pathExe, new char[]{' ', '\"', '\\', '/'});
                logger.log(Level.WARNING, "PreValidateXtremCheckedAlreadyInstalled - Exe: '" + pathExe + "'");
                String installDir = "";
                int index = pathExe.indexOf("node_modules");
                if (index < 0) continue;
                installDir = pathExe.substring(0, index);
                result = StringUtil.trim(installDir, new char[]{' ', '\"', '\\', '/'});
                logger.log(Level.WARNING, "PreValidateXtremCheckedAlreadyInstalled - InstallPath: '" + installDir + "'  Exe:'" + pathExe + "'");
            }
            return result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PreValidateXtremCheckedAlreadyInstalled - Error: " + e.getMessage() + " Stack: " + Arrays.toString(e.getStackTrace()));
            return null;
        }
    }
}

