/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.panels.packs.PacksPanelAutomationHelper;
import com.sage.izpack.InstallationInformationHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PacksNewPanelAutomationHelper
extends PacksPanelAutomationHelper {
    private static final Logger logger = Logger.getLogger(PacksNewPanelAutomationHelper.class.getName());
    private static final String prefixLabel = "PacksNewPanelAutomationHelper - ";
    private final Resources resources;

    public PacksNewPanelAutomationHelper(Resources resources) {
        this.resources = resources;
    }

    @Override
    public void runAutomated(InstallData installData, IXMLElement panelRoot) {
        logger.log(Level.FINE, "PacksNewPanelAutomationHelper - runAutomated");
        PacksNewPanelAutomationHelper.readInstallationInformation(installData);
        PacksNewPanelAutomationHelper.preselectRequired(installData);
        logger.log(Level.FINE, "PacksNewPanelAutomationHelper - runAutomated - stashVariables");
        InstallationInformationHelper.stashVariables(installData);
        super.runAutomated(installData, panelRoot);
        logger.log(Level.FINE, "PacksNewPanelAutomationHelper - runAutomated - popVariables");
        InstallationInformationHelper.popVariables(installData);
        PacksNewPanelAutomationHelper.preselectRequired(installData);
    }

    public static void preselectRequired(InstallData installData) {
        for (Pack pack : installData.getAvailablePacks()) {
            if (pack.isRequired()) {
                pack.setHidden(false);
                pack.setPreselected(true);
            }
            logger.log(Level.FINE, "PacksNewPanelAutomationHelper - createPacksTable - Pack '" + pack.getName() + "' Required: " + pack.isRequired() + " Preselected: " + pack.isPreselected());
        }
    }

    public static void readInstallationInformation(InstallData installData) {
        if (InstallationInformationHelper.isReadInformation(installData) && !InstallationInformationHelper.hasAlreadyReadInformation(installData)) {
            InstallationInformationHelper.readInformation(installData);
            logger.log(Level.FINE, "PacksNewPanelAutomationHelper - ReadInstallationInformation: has been read.");
        }
    }
}

