/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.sage.izpack.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OsVersionHelper {
    private static final Logger logger = Logger.getLogger(OsVersionHelper.class.getName());
    private static final String logPrefix = "OsVersionHelper instance. ";
    public static final String OS_VERSION = OsVersion.IS_LINUX ? OsVersionHelper.getLinuxVersion() : System.getProperty("os.version");
    public static final boolean IS_REDHAT_7_MIN = OsVersion.IS_LINUX && OsVersion.IS_REDHAT_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 7.0;
    public static final boolean IS_REDHAT_8_MIN = OsVersion.IS_LINUX && OsVersion.IS_REDHAT_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 8.0;
    public static final boolean IS_REDHAT_9_MIN = OsVersion.IS_LINUX && OsVersion.IS_REDHAT_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 9.0;
    public static final boolean IS_REDHAT_10_MIN = OsVersion.IS_LINUX && OsVersion.IS_REDHAT_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 10.0;
    public static final boolean IS_UBUNTU_18_MIN = OsVersion.IS_LINUX && OsVersion.IS_UBUNTU_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 18.0;
    public static final boolean IS_UBUNTU_20_MIN = OsVersion.IS_LINUX && OsVersion.IS_UBUNTU_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 20.0;
    public static final boolean IS_UBUNTU_22_MIN = OsVersion.IS_LINUX && OsVersion.IS_UBUNTU_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 22.0;
    public static final boolean IS_UBUNTU_24_MIN = OsVersion.IS_LINUX && OsVersion.IS_UBUNTU_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 24.0;
    public static final boolean IS_LINUX_8_MIN = OsVersion.IS_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 8.0;
    public static final boolean IS_LINUX_9_MIN = OsVersion.IS_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 9.0;
    public static final boolean IS_LINUX_10_MIN = OsVersion.IS_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 10.0;
    public static final boolean IS_LINUX_8 = OsVersion.IS_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 8.0 && (double)OsVersionHelper.getOsVersionFl() < 9.0;
    public static final boolean IS_LINUX_9 = OsVersion.IS_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 9.0 && (double)OsVersionHelper.getOsVersionFl() < 10.0;
    public static final boolean IS_LINUX_10 = OsVersion.IS_LINUX && (double)OsVersionHelper.getOsVersionFl() >= 10.0 && (double)OsVersionHelper.getOsVersionFl() < 11.0;
    public static final String ORACLE = "Oracle";
    public static final String EL = "Entreprise Linux";
    public static final String CENTOS = "CentOS";
    public static final String AMI = "Amazon Linux AMI";
    public static final String AMI2023 = "Amazon Linux release 2023";
    public static final String UBUNTU = "Ubuntu";
    public static final String MACHINE_ID = OsVersionHelper.getLinuxMachineId();
    public static final boolean MACHINE_ID_REGISTERED = OsVersion.IS_LINUX && MACHINE_ID != null;
    public static final boolean IS_ORACLE_LINUX = OsVersion.IS_LINUX && (OsVersionHelper.fileContains("/etc/oracle-release", "Oracle") != false || OsVersionHelper.fileContains("/etc/oracle-release", "Entreprise Linux") != false);
    public static final boolean IS_CENTOS_LINUX = OsVersion.IS_LINUX && OsVersionHelper.fileContains("/etc/centos-release", "CentOS") != false;
    public static final boolean IS_AMI_LINUX = OsVersion.IS_LINUX && OsVersionHelper.fileContains(OsVersionHelper.getReleaseFileName(), "Amazon Linux AMI") != false;
    public static final boolean IS_AMI2023_LINUX = OsVersion.IS_LINUX && OsVersionHelper.fileContains("/etc/amazon-linux-release", "Amazon Linux release 2023") != false;
    public static final boolean IS_UBUNTU_LINUX = OsVersion.IS_LINUX && OsVersionHelper.fileContains("/etc/lsb-release", "Ubuntu") != false;
    private static String _linuxVersion = null;

    public static float getOsVersionFl() {
        String version = System.getProperty("os.version");
        if (OsVersion.IS_LINUX) {
            version = OsVersionHelper.getLinuxVersion();
        }
        return OsVersionHelper.getOsVersionFl(version);
    }

    public static float getOsVersionFl(String version) {
        if (StringUtil.isNullOrBlank(version)) {
            logger.log(Level.FINE, "OsVersionHelper getOsVersionFl(): version is null or blank");
            return 0.0f;
        }
        String[] versionPartsRaw = version.split("\\.");
        ArrayList<String> versionParts = new ArrayList<String>();
        for (String part : versionPartsRaw) {
            if (StringUtil.isNullOrBlank(part)) continue;
            versionParts.add(part);
        }
        if (versionParts.size() > 2) {
            logger.log(Level.FINE, "OsVersionHelper getOsVersionFl(): versionParts (filtered) size > 2 (" + version + ")");
            version = (String)versionParts.get(0) + "." + (String)versionParts.get(1);
        } else if (versionParts.size() == 2) {
            version = (String)versionParts.get(0) + "." + (String)versionParts.get(1);
        } else if (versionParts.size() == 1) {
            version = (String)versionParts.get(0);
        } else {
            logger.log(Level.FINE, "OsVersionHelper getOsVersionFl(): versionParts empty after filtering (" + version + ")");
            return 0.0f;
        }
        float result = Float.parseFloat(version);
        logger.log(Level.FINE, "OsVersionHelper getOsVersionFl():" + result);
        return result;
    }

    public static Boolean fileContains(String filename, String str) {
        boolean result = false;
        try {
            List<String> contentList = OsVersionHelper.getFileContent(filename);
            for (String strItem : contentList) {
                if (!strItem.contains(str)) continue;
                result = true;
                break;
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "OsVersionHelper fileContains(" + filename + ", " + str + ") error: " + e.getMessage());
            logger.log(Level.SEVERE, "OsVersionHelper instance. Error: " + e.getMessage() + " Stack: " + Arrays.toString(e.getStackTrace()));
        }
        return result;
    }

    private static List<String> getFileContent(String fileName) throws IOException {
        String aLine;
        BufferedReader reader;
        ArrayList<String> result = new ArrayList<String>();
        File aFile = new File(fileName);
        if (!aFile.isFile()) {
            return result;
        }
        try {
            reader = new BufferedReader(new FileReader(aFile));
        }
        catch (FileNotFoundException e) {
            return result;
        }
        while ((aLine = reader.readLine()) != null) {
            result.add(aLine + "\n");
        }
        reader.close();
        return result;
    }

    private static String getReleaseFileName() {
        String result = "";
        File[] etcList = new File("/etc").listFiles();
        if (etcList != null) {
            for (File etcEntry : etcList) {
                if (!etcEntry.isFile() || !etcEntry.getName().endsWith("-release")) continue;
                result = etcEntry.toString();
                return result;
            }
        }
        return result;
    }

    public static String getLinuxVersionFromFile(String strReleaseFile) {
        String regex = "^(?:(\\d+)\\.)?(?:(\\d+)\\.)?(\\*|\\d+)$";
        String result = null;
        try {
            List<String> lstLines = OsVersionHelper.getFileContent(strReleaseFile);
            block2: for (String strLine : lstLines) {
                String[] strPattern;
                for (String element : strPattern = strLine.trim().split(" |=")) {
                    if (!element.matches("^(?:(\\d+)\\.)?(?:(\\d+)\\.)?(\\*|\\d+)$")) continue;
                    result = element;
                    continue block2;
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return result;
    }

    private static String getLinuxVersion() {
        if (_linuxVersion != null) {
            return _linuxVersion;
        }
        String result = null;
        if (OsVersion.IS_SUSE_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/sles-release");
            if (result == null) {
                result = OsVersionHelper.getLinuxVersionFromFile("/etc/novell-release");
            }
            if (result == null) {
                result = OsVersionHelper.getLinuxVersionFromFile("/etc/SuSE-release");
            }
        } else if (OsVersion.IS_UBUNTU_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/lsb-release");
        } else if (OsVersion.IS_REDHAT_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/redhat-release");
        } else if (IS_CENTOS_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/centos-release");
        } else if (IS_ORACLE_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/oracle-release");
        } else if (OsVersion.IS_FEDORA_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/fedora-release");
        } else if (OsVersion.IS_MANDRAKE_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/mandrake-release");
        } else if (OsVersion.IS_MANDRIVA_LINUX) {
            result = OsVersionHelper.getLinuxVersionFromFile("/etc/mandriva-release");
            if (result == null) {
                result = OsVersionHelper.getLinuxVersionFromFile("/etc/mandrake-release");
            }
            if (result == null) {
                result = OsVersionHelper.getLinuxVersionFromFile("/etc/mandrakelinux-release");
            }
        } else {
            result = OsVersion.IS_DEBIAN_LINUX ? OsVersionHelper.getLinuxVersionFromFile("/etc/debian_version") : OsVersionHelper.getLinuxVersionFromFile(OsVersionHelper.getReleaseFileName());
        }
        logger.log(Level.FINE, "getLinuxversion result: " + result);
        _linuxVersion = result;
        return result;
    }

    public static String getLinuxDistribution() {
        String result = null;
        if (OsVersion.IS_SUSE_LINUX) {
            try {
                result = "SuSE Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent(OsVersionHelper.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (OsVersion.IS_UBUNTU_LINUX) {
            try {
                result = "Ubuntu Linux\n" + OsVersionHelper.getLinuxVersion();
            }
            catch (Exception exception) {}
        } else if (OsVersion.IS_REDHAT_LINUX) {
            try {
                result = "RedHat Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent("/etc/redhat-release"));
            }
            catch (IOException iOException) {}
        } else if (IS_CENTOS_LINUX) {
            try {
                result = "CentOS Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent("/etc/centos-release"));
            }
            catch (IOException iOException) {}
        } else if (IS_ORACLE_LINUX) {
            try {
                result = "Oracle Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent("/etc/oracle-release"));
            }
            catch (IOException iOException) {}
        } else if (OsVersion.IS_FEDORA_LINUX) {
            try {
                result = "Fedora Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent(OsVersionHelper.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (OsVersion.IS_MANDRAKE_LINUX) {
            try {
                result = "Mandrake Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent(OsVersionHelper.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (OsVersion.IS_MANDRIVA_LINUX) {
            try {
                result = "Mandriva Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent(OsVersionHelper.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (OsVersion.IS_DEBIAN_LINUX) {
            try {
                result = "Debian Linux\n" + StringTool.listToString(OsVersionHelper.getFileContent("/etc/debian_version"));
            }
            catch (IOException iOException) {}
        } else {
            try {
                result = "Unknown Linux Distribution\n" + StringTool.listToString(OsVersionHelper.getFileContent(OsVersionHelper.getReleaseFileName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.log(Level.FINE, "getLinuxDistribution result: " + result);
        return result;
    }

    public static String getOsDetails() {
        StringBuffer result = new StringBuffer();
        result.append("OS_NAME=").append(OsVersion.OS_NAME).append("\n");
        if (OsVersion.IS_UNIX) {
            if (OsVersion.IS_LINUX) {
                result.append(OsVersionHelper.getLinuxDistribution()).append("\n");
            } else {
                try {
                    result.append(OsVersionHelper.getFileContent(OsVersionHelper.getReleaseFileName())).append("\n");
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Unable to get release file contents in 'getOsDetails'.");
                }
            }
        }
        if (OsVersion.IS_WINDOWS) {
            result.append(System.getProperty("os.name")).append(" ").append(System.getProperty("sun.os.patch.level", "")).append("\n");
        }
        logger.log(Level.FINE, "getOsDetails result: " + result.toString());
        return result.toString();
    }

    private static String getLinuxMachineId() {
        String result = null;
        File machineIdFile = new File("/var/lib/dbus/machine-id");
        try {
            if (!machineIdFile.exists()) {
                machineIdFile = new File("/etc/machine-id");
            }
            if (machineIdFile.exists()) {
                result = FileUtil.getFileContent(machineIdFile.getAbsolutePath()).get(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

