/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeIdentifierDataValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(NodeIdentifierDataValidator.class.getName());
    private static final String prefixLabel = "NodeIdentifierDataValidator - ";
    private static final String SPEC_FILE_NAME = "productsSpec.txt";

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        boolean updateMode = ModifyInstallationUtil.get(installData);
        String appName = installData.getVariable("APP_NAME");
        if (StringUtil.isNullOrBlank(appName)) {
            appName = installData.getInfo().getAppName();
        }
        String uninstallName = installData.getVariable("UNINSTALL_NAME");
        String nodeName = installData.getVariable("component.node.name");
        if (updateMode) {
            logger.log(Level.FINE, "NodeIdentifierDataValidator - Update mode detected. NodeIdentifierDataValidator skipped. appName: " + appName + " Node: " + nodeName);
            return DataValidator.Status.OK;
        }
        return this.validate(nodeName, appName, uninstallName);
    }

    @Override
    public String getErrorMessageId() {
        return "nodealreadyexisterror";
    }

    @Override
    public String getWarningMessageId() {
        return "nodealreadyexistwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    public DataValidator.Status validate(String pstrNodeName, String pstrAppName, String uninstallName) {
        logger.log(Level.FINE, "NodeIdentifierDataValidator - Validate AppName: " + pstrAppName + " UninstallName: " + uninstallName + " NodeName: " + pstrNodeName);
        DataValidator.Status bReturn = DataValidator.Status.ERROR;
        try {
            String nodeName = pstrNodeName;
            String svcExt = ".service";
            ArrayList<String> uninstallKeyPrefixList = new ArrayList<String>();
            if (!StringUtil.isNullOrBlank(pstrAppName)) {
                uninstallKeyPrefixList.add(pstrAppName);
            }
            if (!StringUtil.isNullOrBlank(uninstallName)) {
                uninstallKeyPrefixList.add(uninstallName);
            }
            try {
                InputStream input = new ResourceManager().getInputStream(SPEC_FILE_NAME);
                if (input != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    while ((line = reader.readLine()) != null) {
                        uninstallKeyPrefixList.add(line.trim());
                    }
                    reader.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "NodeIdentifierDataValidator - Error: NodeName: " + pstrNodeName + " Error: " + ex.getMessage());
                logger.log(Level.FINE, prefixLabel + ex.getStackTrace().toString());
            }
            bReturn = OsVersion.IS_UNIX ? this.checkUnix(pstrNodeName, svcExt, uninstallKeyPrefixList) : this.checkWindows(nodeName, uninstallKeyPrefixList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            bReturn = DataValidator.Status.ERROR;
        }
        logger.log(Level.FINE, "NodeIdentifierDataValidator -  NodeName: " + pstrNodeName + " Return " + (Object)((Object)bReturn));
        return bReturn;
    }

    private DataValidator.Status checkWindows(String nodeName, ArrayList<String> uninstallKeyPrefixList) throws IOException {
        String line;
        logger.log(Level.FINE, "NodeIdentifierDataValidator - CheckWindows(" + nodeName + ", CheckList: " + uninstallKeyPrefixList.toString() + ")");
        DataValidator.Status bReturn = DataValidator.Status.OK;
        String commandQuery = "sc query state= all | findstr /R /C:\"" + nodeName + "\"";
        String[] command = new String[]{"CMD", "/C", commandQuery};
        logger.log(Level.FINE, "NodeIdentifierDataValidator - command: " + commandQuery);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            logger.log(Level.FINE, "NodeIdentifierDataValidator - line result: " + line);
            for (String prefix : uninstallKeyPrefixList) {
                if (!line.startsWith("DISPLAY_NAME: " + prefix)) continue;
                bReturn = DataValidator.Status.ERROR;
            }
        }
        try {
            int n = process.waitFor();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, prefixLabel + e.getMessage());
            e.printStackTrace();
        }
        return bReturn;
    }

    private DataValidator.Status checkUnix(String pstrNodeName, String svcExt, ArrayList<String> uninstallKeyPrefixList) throws FileNotFoundException, IOException {
        DataValidator.Status bReturn = DataValidator.Status.OK;
        File etcInitDir = new File("/etc/systemd/system");
        if (!etcInitDir.exists() || !etcInitDir.isDirectory()) {
            etcInitDir = new File("/etc/init");
            svcExt = ".conf";
        }
        logger.log(Level.FINE, "NodeIdentifierDataValidator - Service path : " + etcInitDir);
        for (File fileEntry : etcInitDir.listFiles()) {
            logger.log(Level.FINE, "NodeIdentifierDataValidator - fileEntry: " + fileEntry.getAbsolutePath());
            if (!fileEntry.getName().endsWith("-" + pstrNodeName.toLowerCase() + svcExt) && !fileEntry.getName().endsWith("_-_" + pstrNodeName.toLowerCase() + svcExt)) continue;
            BufferedReader reader = new BufferedReader(new FileReader(fileEntry));
            String firstLine = reader.readLine();
            reader.close();
            logger.log(Level.FINE, "NodeIdentifierDataValidator - firstLine: " + firstLine);
            for (String prefix : uninstallKeyPrefixList) {
                if (!firstLine.startsWith("# " + prefix)) continue;
                return DataValidator.Status.ERROR;
            }
        }
        return bReturn;
    }
}

