/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.Pack;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.sage.izpack.InstallDataSage;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.OsVersionHelper;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InstallationInformationHelper {
    private static final Logger logger = Logger.getLogger(InstallationInformationHelper.class.getName());
    private static final String logPrefix = "InstallationInformationHelper - ";
    private static final String ALREADY_LOADED = "installationinformation-already-loaded";
    public static final String FORCE_RESET_VARIABLES = "force-reset-variables";
    public static final String READ_INSTALLATION_INFORMATION = "read-installation-information";
    public static final String WRITE_INSTALLATION_INFORMATION = "write-installation-information";
    private static final List<String> VARIABLES_EXCEPTIONS = Arrays.asList("app-version", "APP-VERSION", "APP_VER", "ISO2_LANG", "ISO3_LANG", "COMPONENT.VERSION", "component.version", "CLASS_PATH", "modify.izpack.install", "component.status", "component.updatemode", "installationinformation-already-loaded", "APP_NAME", "IP_ADDRESS", "OS.VERSION", "os.version", "sageos.version", "sageos.details", "izpack.version", "allow-multiple-instance", "APP_URL", "UNPACKER_CLASS", "force-generate-uninstaller", "USER_HOME", "izpack.file", "need-adxadmin", "JAVA_HOME", "ESTIMATED_SIZE", "TEMP_DIRECTORY", "HOST_NAME", "publisher", "need-service-configuration-fix");
    private static boolean isLegacyIzpack = false;
    private static Hashtable<String, String> backupVariables = new Hashtable();

    public static boolean isReadInformation(InstallData installData) {
        boolean resultStandard = installData.getInfo().isReadInstallationInformation();
        String readInstallInfo = installData.getVariable(READ_INSTALLATION_INFORMATION);
        boolean resultCustom = !StringUtil.isNullOrBlank(readInstallInfo) && (readInstallInfo.toLowerCase().equals("yes") || readInstallInfo.toLowerCase().equals("true"));
        boolean result = resultStandard || resultCustom;
        logger.log(Level.FINE, "InstallationInformationHelper - isReadInformation: " + result + "  resultStandard: " + resultStandard + "  resultCustom: " + resultCustom);
        return result;
    }

    public static boolean isWriteInformation(InstallData installData) {
        boolean resultStandard = installData.getInfo().isWriteInstallationInformation();
        String writeInstallInfo = installData.getVariable(WRITE_INSTALLATION_INFORMATION);
        boolean resultCustom = !StringUtil.isNullOrBlank(writeInstallInfo) && (writeInstallInfo.toLowerCase().equals("yes") || writeInstallInfo.toLowerCase().equals("true"));
        boolean result = resultStandard || resultCustom;
        logger.log(Level.FINE, "InstallationInformationHelper - isWriteInformation: " + result + "  resultStandard: " + resultStandard + "  resultCustom: " + resultCustom);
        return result;
    }

    public static boolean hasAlreadyReadInformation(InstallData installData) {
        boolean hasRead = Boolean.parseBoolean(installData.getVariable(ALREADY_LOADED));
        logger.log(Level.FINE, "InstallationInformationHelper - hasAlreadyReadInformation : " + hasRead);
        return hasRead;
    }

    public static void setAlreadyReadInformation(InstallData installData, boolean informationloaded) {
        installData.setVariable(ALREADY_LOADED, Boolean.toString(informationloaded));
    }

    public static boolean isLegacyIzpackInfo() {
        return isLegacyIzpack;
    }

    public static void writeInformation(InstallData installData) throws Exception {
        if (StringUtil.isNullOrBlank(installData.getInstallPath())) {
            logger.log(Level.FINE, "InstallationInformationHelper - writeInformation - INSTALL_PATH is not set, exiting.");
            return;
        }
        InstallationInformationHelper.readAndInitProperties(installData);
        String installDir = installData.getInstallPath();
        File installationInfo = new File(installDir + File.separator + ".installationinformation");
        logger.log(Level.FINE, "InstallationInformationHelper - Writing installation information " + installationInfo.getAbsolutePath());
        List<com.izforge.izpack.api.data.Pack> selectedPacks = installData.getSelectedPacks();
        ArrayList<com.izforge.izpack.api.data.Pack> installedPacks = new ArrayList<com.izforge.izpack.api.data.Pack>(selectedPacks);
        if (!installationInfo.exists()) {
            logger.fine("Creating info file " + installationInfo.getAbsolutePath());
            File dir = new File(installData.getInstallPath());
            if (!dir.exists() && !dir.mkdirs()) {
                throw new Exception("Failed to create directory: " + dir);
            }
            if (!installationInfo.createNewFile()) {
                throw new Exception("Failed to create file: " + installationInfo);
            }
        } else {
            List packs;
            logger.fine("Previous installation information found: " + installationInfo.getAbsolutePath());
            FileInputStream fin = new FileInputStream(installationInfo);
            ObjectInputStream oin = new ObjectInputStream(fin);
            try {
                packs = (List)oin.readObject();
            }
            catch (Exception exception) {
                throw new Exception("Failed to read previous installation information", exception);
            }
            finally {
                if (oin != null) {
                    oin.close();
                }
                if (fin != null) {
                    fin.close();
                }
            }
            installedPacks.addAll(packs);
        }
        FileOutputStream fout = new FileOutputStream(installationInfo);
        ObjectOutputStream oout = new ObjectOutputStream(fout);
        oout.writeObject(installedPacks);
        oout.writeObject(installData.getVariables().getProperties());
        logger.fine("Writing installation information finished: " + installationInfo.getAbsolutePath());
        if (oout != null) {
            oout.close();
        }
        if (fout != null) {
            fout.close();
        }
    }

    public static void readInformation(InstallData installData) {
        boolean informationloaded;
        boolean perform = ModifyInstallationUtil.get(installData);
        if (!perform && installData instanceof InstallDataSage) {
            perform = Boolean.TRUE;
        }
        if (!perform) {
            logger.log(Level.FINE, "InstallationInformationHelper - not restoring variables because it is not an update or uninstallation.");
            return;
        }
        if (StringUtil.isNullOrBlank(installData.getInstallPath())) {
            logger.log(Level.FINE, "InstallationInformationHelper - INSTALL_PATH is not set, exiting.");
            return;
        }
        String osVersion = OsVersionHelper.OS_VERSION;
        String osVersionDetails = OsVersionHelper.getOsDetails();
        installData.setVariable("OS.VERSION", osVersion);
        installData.setVariable("os.version", osVersion);
        installData.setVariable("sageos.version", osVersion);
        installData.setVariable("sageos.details", osVersionDetails);
        logger.log(Level.FINE, "InstallationInformationHelper - set variables 'os.version', 'sageos.version': " + osVersion + "  'sageos.details':" + osVersionDetails);
        logger.log(Level.FINE, "InstallationInformationHelper - Reading file .installationinformation");
        try {
            informationloaded = InstallationInformationHelper.loadInstallationInformation(installData);
            logger.log(Level.FINE, "InstallationInformationHelper - Installation information loaded");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "InstallationInformationHelper - Installation information loading failed: " + e.getMessage());
            informationloaded = false;
        }
        InstallationInformationHelper.setAlreadyReadInformation(installData, informationloaded);
    }

    public static boolean isDirectoryAlreadyExists(String installPath) {
        Path directoryPath = Paths.get(installPath, new String[0]);
        return Files.exists(directoryPath, new LinkOption[0]) && Files.isDirectory(directoryPath, new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIncompatibleInstallation(String installPath, boolean isReadInstallationInformation) {
        String logHeader = "InstallationInformationHelper.isIncompatibleInstallation - ";
        if (!isReadInstallationInformation) return Boolean.FALSE;
        File installInfo = new File(installPath, ".installationinformation");
        if (!installInfo.exists()) {
            logger.log(Level.SEVERE, logHeader + "File doesn't exist: " + installInfo.getAbsolutePath());
            return Boolean.TRUE;
        }
        try (ObjectInputStream oin = new ObjectInputStream(new FileInputStream(installInfo));){
            List objects = (List)oin.readObject();
            for (Object pack : objects) {
                if (pack instanceof Pack) {
                    logger.log(Level.FINE, logHeader + "found legacy pack: " + ((Pack)pack).name);
                    continue;
                }
                if (!(pack instanceof com.izforge.izpack.api.data.Pack)) {
                    boolean bl = Boolean.TRUE;
                    return bl;
                }
                logger.log(Level.FINE, logHeader + "found pack: " + ((com.izforge.izpack.api.data.Pack)pack).getName());
            }
            Properties props = (Properties)oin.readObject();
            Iterator<String> iterator = props.stringPropertyNames().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                logger.log(Level.FINE, logHeader + "found variable: " + key + " = " + props.getProperty(key));
            }
            return Boolean.FALSE;
        }
        catch (Exception ignored) {
            logger.log(Level.SEVERE, logHeader + "problem reading " + installInfo.getAbsolutePath());
            return Boolean.TRUE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadInstallationInformation(InstallData installData) {
        File installInfo = new File(installData.getInstallPath(), ".installationinformation");
        if (!installInfo.exists()) {
            logger.log(Level.FINE, logPrefix + installInfo.getAbsolutePath() + " doesn't exist, exiting.");
            return Boolean.FALSE;
        }
        try (ObjectInputStream oin = new ObjectInputStream(new FileInputStream(installInfo));){
            List packsinstalled = (List)oin.readObject();
            logger.log(Level.FINE, "InstallationInformationHelper - Found " + packsinstalled.size() + " installed packs");
            ArrayList<com.izforge.izpack.api.data.Pack> selectedPacks = new ArrayList<com.izforge.izpack.api.data.Pack>(installData.getSelectedPacks());
            for (Object obj : packsinstalled) {
                Serializable pack;
                if (obj instanceof Pack) {
                    isLegacyIzpack = Boolean.TRUE;
                    pack = (Pack)obj;
                    installData.getAvailablePacks().stream().filter(arg_0 -> InstallationInformationHelper.lambda$loadInstallationInformation$0((Pack)pack, arg_0)).filter(arg_0 -> InstallationInformationHelper.lambda$loadInstallationInformation$1((Pack)pack, selectedPacks, arg_0)).findFirst().ifPresent(selectedPacks::add);
                    continue;
                }
                if (!(obj instanceof com.izforge.izpack.api.data.Pack)) {
                    boolean bl = Boolean.FALSE;
                    return bl;
                }
                pack = (com.izforge.izpack.api.data.Pack)obj;
                installData.getAvailablePacks().stream().filter(arg_0 -> InstallationInformationHelper.lambda$loadInstallationInformation$2((com.izforge.izpack.api.data.Pack)pack, arg_0)).filter(arg_0 -> InstallationInformationHelper.lambda$loadInstallationInformation$3((com.izforge.izpack.api.data.Pack)pack, selectedPacks, arg_0)).findFirst().ifPresent(selectedPacks::add);
            }
            installData.setSelectedPacks(selectedPacks);
            Properties variables = (Properties)oin.readObject();
            InstallationInformationHelper.readAndInitProperties(installData, variables);
            boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception e) {
            logger.warning("InstallationInformationHelper - Could not read Pack installation information in current izPack version: " + e.getMessage());
            return Boolean.FALSE;
        }
    }

    public static void stashVariables(InstallData installData) {
        backupVariables.clear();
        Variables variables = installData.getVariables();
        if (variables != null) {
            Properties variablesProp = variables.getProperties();
            for (Object key : variablesProp.keySet()) {
                backupVariables.putIfAbsent((String)key, (String)variablesProp.get(key));
                logger.log(Level.FINE, "InstallationInformationHelper - stashVariables: " + key + "=" + variablesProp.get(key));
            }
        }
    }

    public static void popVariables(InstallData installData) {
        Variables variables = installData.getVariables();
        if (variables != null) {
            Properties variablesProp = variables.getProperties();
            for (String key : backupVariables.keySet()) {
                variablesProp.put(key, backupVariables.get(key));
                logger.log(Level.FINE, "InstallationInformationHelper - popVariables: " + key + "=" + variablesProp.get(key));
            }
        }
        backupVariables.clear();
    }

    public static void readAndInitProperties(InstallData installData) {
        InstallationInformationHelper.readAndInitProperties(installData, installData.getVariables().getProperties());
    }

    public static void readAndInitProperties(InstallData installData, Properties variables) {
        ArrayList<String> emptyVariables = new ArrayList<String>();
        String forceResetVariables = installData.getVariable(FORCE_RESET_VARIABLES);
        if (!StringUtil.isNullOrBlank(forceResetVariables)) {
            String[] tokensVariable;
            for (String varName : tokensVariable = new String(forceResetVariables).split(",")) {
                varName = varName.trim();
                emptyVariables.add(varName);
            }
        }
        for (Object key : variables.keySet()) {
            if (VARIABLES_EXCEPTIONS.contains(key) || emptyVariables.contains(key)) continue;
            installData.setVariable((String)key, (String)variables.get(key));
        }
        if (!StringUtil.isNullOrBlank(forceResetVariables)) {
            logger.log(Level.FINE, "InstallationInformationHelper - Force reset variables: " + forceResetVariables);
            for (String varName : emptyVariables) {
                installData.setVariable(varName, "");
            }
        }
    }

    private static boolean notContainsPack(String name, List<com.izforge.izpack.api.data.Pack> packs) {
        Optional<com.izforge.izpack.api.data.Pack> found = packs.stream().filter(p -> name.equals(p.getName())).findFirst();
        return !found.isPresent();
    }

    private static /* synthetic */ boolean lambda$loadInstallationInformation$3(com.izforge.izpack.api.data.Pack pack, List selectedPacks, com.izforge.izpack.api.data.Pack p) {
        return InstallationInformationHelper.notContainsPack(pack.getName(), selectedPacks);
    }

    private static /* synthetic */ boolean lambda$loadInstallationInformation$2(com.izforge.izpack.api.data.Pack pack, com.izforge.izpack.api.data.Pack p) {
        return p.getName().equals(pack.getName());
    }

    private static /* synthetic */ boolean lambda$loadInstallationInformation$1(Pack pack, List selectedPacks, com.izforge.izpack.api.data.Pack p) {
        return InstallationInformationHelper.notContainsPack(pack.name, selectedPacks);
    }

    private static /* synthetic */ boolean lambda$loadInstallationInformation$0(Pack pack, com.izforge.izpack.api.data.Pack p) {
        return p.getName().equals(pack.name);
    }
}

