/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.sage.izpack.InstallTypeNewPanelAutomation;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.RegistryHandlerX3;
import com.sage.izpack.ResourcesHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstallTypeNewPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -7778360562175088671L;
    private static final Logger logger = Logger.getLogger(InstallTypeNewPanel.class.getName());
    private static final String logPrefix = "InstallTypeNewPanel - ";
    private JRadioButton normalInstall;
    private JRadioButton modifyInstall;
    private DefaultListModel<String> listItems;
    private HashMap<String, String[]> lstCompProps;
    private JList<String> installedComponents;
    private String selectedKey;
    private final RegistryHandler registryHandler;

    public InstallTypeNewPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, RegistryDefaultHandler handler, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this.buildGUI();
        this.registryHandler = handler.getInstance();
    }

    private void buildGUI() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        topPanel.add(LabelFactory.create(super.getString("InstallTypeNewPanel.info"), 10));
        topPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        ButtonGroup group = new ButtonGroup();
        boolean modifyInstallation = ModifyInstallationUtil.get(this.installData);
        this.normalInstall = new JRadioButton(super.getString("InstallTypeNewPanel.normal"), !modifyInstallation);
        this.normalInstall.addActionListener(this);
        group.add(this.normalInstall);
        topPanel.add(this.normalInstall);
        this.modifyInstall = new JRadioButton(super.getString("InstallTypeNewPanel.modify"), modifyInstallation);
        this.modifyInstall.addActionListener(this);
        group.add(this.modifyInstall);
        topPanel.add(this.modifyInstall);
        this.lstCompProps = new HashMap();
        this.listItems = new DefaultListModel();
        this.installedComponents = new JList<String>(this.listItems);
        this.installedComponents.setSelectionMode(0);
        this.installedComponents.setLayoutOrientation(0);
        this.installedComponents.setVisibleRowCount(5);
        this.installedComponents.setEnabled(false);
        JScrollPane listScroller = new JScrollPane(this.installedComponents);
        listScroller.setPreferredSize(new Dimension(600, 100));
        listScroller.setAlignmentX(0.0f);
        topPanel.add(listScroller);
        this.add((Component)topPanel, "nextLine");
        this.setInitialFocus(this.normalInstall);
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public void panelActivate() {
        logger.log(Level.FINE, "InstallTypeNewPanel - panelActivate");
        this.listItems.clear();
        this.lstCompProps.clear();
        RegistryHandlerX3 helper = new RegistryHandlerX3(this.registryHandler, this.installData);
        try {
            this.lstCompProps = helper.loadComponentsList();
            for (Map.Entry<String, String[]> pair : this.lstCompProps.entrySet()) {
                this.listItems.addElement(pair.getKey());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in InstallTypeNewPanel panelActivate: " + e.getMessage());
            e.printStackTrace();
        }
        boolean modifyInstallation = ModifyInstallationUtil.get(this.installData);
        if (modifyInstallation) {
            this.modifyInstall.setSelected(true);
            this.installedComponents.setEnabled(true);
            if (this.selectedKey != null) {
                if (this.listItems.contains(this.selectedKey)) {
                    this.installedComponents.setSelectedValue(this.selectedKey, true);
                } else if (this.listItems.size() > 0) {
                    this.installedComponents.setSelectedIndex(0);
                }
            } else if (this.listItems.size() > 0) {
                this.installedComponents.setSelectedIndex(0);
            }
        } else {
            this.normalInstall.setSelected(true);
            this.installedComponents.setEnabled(false);
        }
        logger.log(Level.FINE, "InstallTypeNewPanel - modifyInstallation: " + modifyInstallation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.log(Level.FINE, "InstallTypeNewPanel - actionPerformed - installation type changed");
        if (e.getSource() == this.normalInstall) {
            logger.log(Level.FINE, "InstallTypeNewPanel - normal installation");
            this.installedComponents.clearSelection();
            this.installedComponents.setEnabled(false);
            ModifyInstallationUtil.set((InstallData)this.installData, Boolean.FALSE);
        } else if (e.getSource() == this.modifyInstall) {
            logger.log(Level.FINE, "InstallTypeNewPanel - actionPerformed - modification installation");
            this.installedComponents.setEnabled(true);
            ModifyInstallationUtil.set((InstallData)this.installData, Boolean.TRUE);
            if (this.selectedKey != null) {
                if (this.listItems.contains(this.selectedKey)) {
                    this.installedComponents.setSelectedValue(this.selectedKey, true);
                } else if (this.listItems.size() > 0) {
                    this.installedComponents.setSelectedIndex(0);
                }
            } else if (this.listItems.size() > 0) {
                this.installedComponents.setSelectedIndex(0);
            }
        } else if (e.getSource() == this.installedComponents) {
            // empty if block
        }
    }

    public String getPathFromSelected() {
        String compPath = null;
        if (this.installedComponents.getSelectedValue() != null) {
            String key = this.installedComponents.getSelectedValue();
            String[] compProps = this.lstCompProps.get(key);
            compPath = compProps[1];
        }
        logger.log(Level.FINE, "InstallTypeNewPanel - getPathFromSelected: " + compPath);
        return compPath;
    }

    @Override
    public boolean isValidated() {
        Boolean modifyInstallation = ModifyInstallationUtil.get(this.installData);
        logger.log(Level.FINE, "InstallTypeNewPanel - isValidated - modifyInstallation: " + modifyInstallation);
        if (modifyInstallation.booleanValue()) {
            String compPath = this.getPathFromSelected();
            logger.log(Level.FINE, "InstallTypeNewPanel - isValidated - compPath: " + compPath);
            if (compPath == null) {
                return false;
            }
            File installationInformation = new File(compPath + File.separator + ".installationinformation");
            if (!installationInformation.exists()) {
                logger.log(Level.FINE, "InstallTypeNewPanel - isValidated - installationInformation doesn't exist: " + installationInformation.getAbsolutePath());
                this.emitError(ResourcesHelper.getCustomPropString("installer.error"), ResourcesHelper.getCustomPropString("PathInputPanel.required.forModificationInstallation"));
                return false;
            }
            this.installData.setInstallPath(compPath);
            logger.log(Level.FINE, "InstallTypeNewPanel - isValidated - SetInstallPath: " + compPath);
            this.selectedKey = this.installedComponents.getSelectedValue();
            logger.log(Level.FINE, "InstallTypeNewPanel - isValidated: " + this.selectedKey);
        }
        return super.isValidated();
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        logger.log(Level.FINE, "InstallTypeNewPanel - createInstallationRecord");
        new InstallTypeNewPanelAutomation().createInstallationRecord(this.installData, panelRoot);
    }

    @Override
    public String getSummaryBody() {
        if (ModifyInstallationUtil.get(this.installData).booleanValue()) {
            return super.getString("InstallTypeNewPanel.modify");
        }
        return super.getString("InstallTypeNewPanel.normal");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.selectedKey = this.installedComponents.getSelectedValue();
    }
}

