/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.panels.finish.FinishPanelAutomation;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.ResourcesHelper;
import com.sage.izpack.SageInstallationInformationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FinishNewPanelAutomationHelper
extends FinishPanelAutomation {
    private static final Logger logger = Logger.getLogger(FinishNewPanelAutomationHelper.class.getName());
    private final ResourcesHelper resourceHelper;
    private final InstallData installData;
    private final UninstallDataWriter uninstallDataWriter;
    private final UninstallData uninstallData;
    private static final String logPrefix = "FinishNewPanelAutomationHelper instance. ";
    private final Resources resources;

    public FinishNewPanelAutomationHelper(InstallData installData, Resources resources, UninstallDataWriter uninstallDataWriter, UninstallData uninstallData) throws NativeLibException {
        logger.log(Level.FINE, "FinishNewPanelAutomationHelper instance. Init custom resources");
        this.installData = installData;
        this.resources = resources;
        this.uninstallDataWriter = uninstallDataWriter;
        this.uninstallData = uninstallData;
        this.resourceHelper = new ResourcesHelper(installData, resources);
        this.resourceHelper.mergeCustomMessages();
        logger.log(Level.FINE, "FinishNewPanelAutomationHelper instance. Custom resources initialized");
    }

    @Override
    public void runAutomated(InstallData installData, IXMLElement panelRoot) {
        this.writeUninstallData();
        FinishNewPanelAutomationHelper.initSageInstallationInformation(installData);
    }

    private boolean writeUninstallData() {
        boolean result = true;
        boolean uninstallRequired = this.uninstallDataWriter.isUninstallRequired();
        logger.log(Level.FINE, "FinishNewPanelAutomationHelper instance. uninstallRequired:" + uninstallRequired);
        if (!uninstallRequired) {
            FinishNewPanelAutomationHelper.initUninstallPath(this.resources, this.installData);
            result = this.uninstallDataWriter.write();
            logger.log(Level.FINE, "FinishNewPanelAutomationHelper instance. force writeUninstallData. uninstallDataWriter.write() returns " + result);
            if (!result) {
                logger.warning(this.resourceHelper.getCustomString("installer.uninstall.writefailed"));
            }
        }
        return result;
    }

    public static void initUninstallPath(Resources resources, InstallData installData) {
        if (installData == null) {
            logger.log(Level.SEVERE, "FinishNewPanelAutomationHelper instance.  Error: initUninstallPath(resources, installData = NULL)");
            return;
        }
        Info info = installData.getInfo();
        if (info.getUninstallerPath() == null) {
            String uninstallPath = info.getInstallationSubPath();
            if (uninstallPath == null) {
                uninstallPath = installData.getInstallPath();
            }
            if (uninstallPath == null && OsVersion.IS_WINDOWS) {
                uninstallPath = installData.getVariable("TargetPanel.dir.windows");
            }
            if (uninstallPath == null && OsVersion.IS_UNIX) {
                uninstallPath = installData.getVariable("TargetPanel.dir.unix");
            }
            info.setUninstallerPath(uninstallPath + File.separator + "Uninstaller");
        }
        if (info.getUninstallerName() == null) {
            info.setUninstallerName("uninstaller.jar");
        }
        Path path = Paths.get(info.getUninstallerPath() + File.separator + info.getUninstallerName(), new String[0]);
        try {
            Files.deleteIfExists(path);
            logger.log(Level.FINE, "FinishNewPanelAutomationHelper instance. Old uninstaller file " + path.toAbsolutePath() + " deleted");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "FinishNewPanelAutomationHelper instance. Error: " + e.getMessage() + " Stack: " + Arrays.toString(e.getStackTrace()));
        }
    }

    public static void initSageInstallationInformation(InstallData installData) {
        if (SageInstallationInformationHelper.writeSageInformationEnable(installData)) {
            SageInstallationInformationHelper.createSageInstallationInfo(installData);
        }
    }
}

