/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.checkedhello.CheckedHelloConsolePanel;
import com.izforge.izpack.panels.checkedhello.RegistryHelper;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.CheckedHelloNewPanel;
import com.sage.izpack.CheckedHelloNewPanelAutomationHelper;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.RegistryHandlerX3;
import com.sage.izpack.ResourcesHelper;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckedHelloNewConsolePanel
extends CheckedHelloConsolePanel {
    private static final Logger logger = Logger.getLogger(CheckedHelloNewConsolePanel.class.getName());
    private final Resources resources;
    private static final String logPrefix = "CheckedHelloNewConsolePanel - ";
    private final Prompt prompt;
    private final InstallData installData;
    private final RegistryHandler registryHandler;
    private RegistryHelper registryHelper;
    private final RegistryHandlerX3 x3Handler;
    private final ResourcesHelper resourceHelper;
    private final String installPath;

    public CheckedHelloNewConsolePanel(RegistryDefaultHandler handler, InstallData installData, Resources resources, Prompt prompt, PanelView<ConsolePanel> panel) throws NativeLibException {
        super(handler, installData, prompt, panel);
        this.registryHelper = new RegistryHelper(handler, installData);
        this.prompt = prompt;
        this.installData = installData;
        this.resources = resources;
        this.registryHandler = handler != null ? handler.getInstance() : null;
        this.x3Handler = new RegistryHandlerX3(this.registryHandler, installData);
        logger.log(Level.FINE, logPrefix);
        this.resourceHelper = new ResourcesHelper(installData, resources);
        this.resourceHelper.mergeCustomMessages();
        this.registryHelper = new RegistryHelper(handler, installData);
        this.installPath = CheckedHelloNewPanel.initPath(installData, resources, this.registryHelper, this.x3Handler);
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        logger.log(Level.FINE, "CheckedHelloNewConsolePanel - run()  installPath: " + this.installPath);
        this.printHeadLine(installData, console);
        if (this.x3Handler.needAdxAdmin()) {
            try {
                boolean adxAdminInstalled;
                String adxAdminPath = this.x3Handler.getAdxAdminDirPath();
                boolean bl = adxAdminInstalled = adxAdminPath != null;
                if (!adxAdminInstalled) {
                    logger.log(Level.FINE, this.resourceHelper.getCustomString("adxadminNotRegistered"));
                    console.println(this.resourceHelper.getCustomString("adxadminNotRegistered"));
                    return false;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, this.resourceHelper.getCustomString("installer.error") + ":" + e.getMessage());
                console.println(this.resourceHelper.getCustomString("installer.error"));
                return false;
            }
        }
        boolean result = true;
        if (this.installPath != null) {
            ModifyInstallationUtil.set(installData, Boolean.TRUE);
            String allowMultipleInstall = installData.getVariable("allow-multiple-instance");
            if (Boolean.TRUE.toString().equalsIgnoreCase(allowMultipleInstall)) {
                try {
                    CheckedHelloNewPanelAutomationHelper.setUniqueUninstallKey(this.registryHandler, this.registryHelper, this.resourceHelper);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    logger.log(Level.SEVERE, "CheckedHelloNewConsolePanel - Error: " + e.getMessage() + " Stack: " + Arrays.toString(e.getStackTrace()));
                }
                Variables variables = this.installData.getVariables();
                installData.setVariable("UNINSTALL_NAME", variables.get("APP_NAME"));
                logger.log(Level.FINE, "CheckedHelloNewConsolePanel - Set UNINSTALL_NAME: " + variables.get("APP_NAME"));
                if (result) {
                    this.display(installData, console);
                    result = this.promptEndPanel(installData, console);
                }
            } else {
                logger.log(Level.FINE, "CheckedHelloNewConsolePanel - allow-multiple-instance=false (updatemode)");
                result = this.multipleInstall(installData);
                if (result) {
                    installData.getInfo().setUninstallerPath(null);
                    installData.getInfo().setUninstallerName(null);
                }
                Variables variables = this.installData.getVariables();
                installData.setVariable("UNINSTALL_NAME", variables.get("APP_NAME"));
                logger.log(Level.FINE, "CheckedHelloNewConsolePanel - Set UNINSTALL_NAME: " + variables.get("APP_NAME"));
                if (result) {
                    this.display(installData, console);
                    result = this.promptEndPanel(installData, console);
                }
            }
        }
        return result;
    }

    @Override
    protected boolean multipleInstall(InstallData installData) {
        boolean result;
        logger.log(Level.FINE, "CheckedHelloNewConsolePanel - multipleInstall()");
        try {
            String noLuck;
            String path = installData.getInstallPath();
            if (path == null && OsVersion.IS_WINDOWS) {
                path = this.registryHelper.getInstallationPath();
            }
            if (path == null) {
                path = "<not found>";
            }
            result = this.prompt.confirm(Prompt.Type.ERROR, noLuck = this.resourceHelper.getCustomString("CheckedHelloNewPanel.productAlreadyExist0") + path + ". " + this.resourceHelper.getCustomString("CheckedHelloNewPanel.productAlreadyExist1"), Prompt.Options.YES_NO) == Prompt.Option.YES;
        }
        catch (NativeLibException e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }
}

