/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class CheckSyracuseCertificateDataValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        Security.addProvider(new BouncyCastleProvider());
        String fieldPemCertFile = installData.getVariable("syracuse.ssl.certfile");
        String fieldPemKeyFile = installData.getVariable("syracuse.ssl.pemkeyfile");
        String fieldPemKeyPassword = installData.getVariable("syracuse.ssl.pemkeypassword");
        String fieldPemCaFile = installData.getVariable("syracuse.ssl.pemcafile");
        try {
            KeyPair kp;
            InputStream inPemKeyFile = Files.newInputStream(Paths.get(fieldPemKeyFile, new String[0]), new OpenOption[0]);
            InputStream inPemCertFile = Files.newInputStream(Paths.get(fieldPemCertFile, new String[0]), new OpenOption[0]);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
            InputStream inPemCaFile = Files.newInputStream(Paths.get(fieldPemCaFile, new String[0]), new OpenOption[0]);
            Collection<? extends Certificate> certCAChain = factory.generateCertificates(inPemCaFile);
            certCAChain.add(cert);
            PEMParser pemParser = new PEMParser(new InputStreamReader(inPemKeyFile));
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(fieldPemKeyPassword.toCharArray());
                kp = converter.getKeyPair(ckp.decryptKeyPair(decProv));
            } else {
                PEMKeyPair ukp = (PEMKeyPair)object;
                kp = converter.getKeyPair(ukp);
            }
            pemParser.close();
            byte[] input = "1234567890ABCDEF".getBytes();
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, cert.getPublicKey());
            byte[] cipherText = cipher.doFinal(input);
            cipher.init(2, kp.getPrivate());
            byte[] decrypted = cipher.doFinal(cipherText);
            if (Arrays.equals(decrypted, input)) {
                return DataValidator.Status.OK;
            }
            this.strMessage = "Unknow error";
            installData.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            installData.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

