/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.CertificateGeneratorHelper;
import com.sage.izpack.CheckMongoDbCertificateP12Validator;
import java.io.File;
import java.io.FileWriter;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class CheckMongoDbCreateCertsValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";
    private static final Logger logger = Logger.getLogger(CheckMongoDbCreateCertsValidator.class.getName());
    private static final String prefixLabel = "CheckMongoDbCreateCertsValidator - ";

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        logger.log(Level.FINE, "CheckMongoDbCreateCertsValidator - validateData");
        try {
            KeyPair pairCA = CertificateGeneratorHelper.generateRSAKeyPair(4096);
            String countryCode = installData.getVariable("mongodb.ssl.certificate.countrycode");
            String state = installData.getVariable("mongodb.ssl.certificate.state");
            String city = installData.getVariable("mongodb.ssl.certificate.city");
            String organization = installData.getVariable("mongodb.ssl.certificate.organization");
            String organizationalUnit = installData.getVariable("mongodb.ssl.certificate.organisationalunit");
            String name = installData.getVariable("mongodb.ssl.certificate.name");
            String email = installData.getVariable("mongodb.ssl.certificate.email");
            int validity = Integer.parseInt(installData.getVariable("mongodb.ssl.certificate.validity"));
            X509Certificate caCert = CertificateGeneratorHelper.generateCAV3Certificate(pairCA, countryCode, organization, organizationalUnit, state, city, name, email, validity);
            logger.log(Level.FINE, "CheckMongoDbCreateCertsValidator - generateCAV3Certificate done");
            String certDirectory = installData.getVariable("mongodb.dir.certs");
            File dirCerts = new File(certDirectory);
            if (!dirCerts.exists()) {
                dirCerts.mkdirs();
            }
            FileWriter caCertFile = new FileWriter(certDirectory + File.separator + "ca.cacrt");
            JcaPEMWriter pem = new JcaPEMWriter(caCertFile);
            pem.writeObject(caCert);
            pem.close();
            logger.log(Level.FINE, prefixLabel + certDirectory + File.separator + "ca.cacrt saved done");
            String caPassphrase = installData.getVariable("mongodb.ssl.capassphrase");
            CertificateGeneratorHelper.writePrivateKey(certDirectory + File.separator + "ca.key", pairCA, caPassphrase.toCharArray());
            KeyPair pairServer = CertificateGeneratorHelper.generateRSAKeyPair(4096);
            String hostname = installData.getVariable("mongodb.ssl.certificate.hostname");
            String cname = installData.getInfo().getAppName() + " " + installData.getVariable("component.node.name") + " " + hostname;
            installData.setVariable("mongodb.ssl.certificate.cname", cname);
            X509Certificate serverCert = CertificateGeneratorHelper.generateServerV3Certificate(pairServer, countryCode, organization, organizationalUnit, state, city, cname, hostname, null, validity, caCert, pairCA);
            FileWriter serverCertFile = new FileWriter(certDirectory + File.separator + hostname + ".crt");
            pem = new JcaPEMWriter(serverCertFile);
            pem.writeObject(serverCert);
            pem.close();
            logger.log(Level.FINE, prefixLabel + certDirectory + File.separator + hostname + ".crt saved done");
            String serverPassphrase = installData.getVariable("mongodb.ssl.serverpassphrase");
            CertificateGeneratorHelper.writePrivateKey(certDirectory + File.separator + hostname + ".key", pairServer, serverPassphrase.toCharArray());
            installData.setVariable("mongodb.ssl.usecafile", "true");
            File pemKeyFile = new File(certDirectory + File.separator + hostname + ".pem");
            File certFile = new File(certDirectory + File.separator + hostname + ".crt");
            File privKeyFile = new File(certDirectory + File.separator + hostname + ".key");
            CertificateGeneratorHelper.mergeFiles(new File[]{certFile, privKeyFile}, pemKeyFile);
            logger.log(Level.FINE, "CheckMongoDbCreateCertsValidator - pemKeyFile merged: " + pemKeyFile.getAbsolutePath());
            KeyPair pairClient = CertificateGeneratorHelper.generateRSAKeyPair(4096);
            X509Certificate clientCert = CertificateGeneratorHelper.generateClientV3Certificate(pairClient, countryCode, organization, organizationalUnit, state, city, name, email, validity, caCert, pairCA);
            FileWriter clientCertFile = new FileWriter(certDirectory + File.separator + "client.crt");
            pem = new JcaPEMWriter(clientCertFile);
            pem.writeObject(clientCert);
            pem.close();
            CertificateGeneratorHelper.writePrivateKey(certDirectory + File.separator + "client.key", pairClient, null);
            logger.log(Level.FINE, prefixLabel + certDirectory + File.separator + "client.key saved done");
            File pemClientKeyFile = new File(certDirectory + File.separator + "client.pem");
            File certClientFile = new File(certDirectory + File.separator + "client.crt");
            File privClientKeyFile = new File(certDirectory + File.separator + "client.key");
            CertificateGeneratorHelper.mergeFiles(new File[]{certClientFile, privClientKeyFile}, pemClientKeyFile);
            CheckMongoDbCertificateP12Validator.writeP12File(serverPassphrase, installData);
            logger.log(Level.FINE, "CheckMongoDbCreateCertsValidator - writeP12File done");
            installData.setVariable("mongodb.ssl.alreadydone", "true");
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            installData.setVariable(strMessageValue, this.strMessage);
            logger.log(Level.FINE, "CheckMongoDbCreateCertsValidator - Exception: " + this.strMessage, ex);
            return DataValidator.Status.ERROR;
        }
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

