/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class CheckMongoDbConfigValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckMongoDbConfigValidator.class.getName());
    private static final String prefixLabel = "CheckMongoDbConfigValidator - ";
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        boolean updateMode = ModifyInstallationUtil.get(installData);
        if (!updateMode) {
            return DataValidator.Status.OK;
        }
        Yaml yaml = new Yaml();
        try {
            String configDir = installData.getInstallPath();
            logger.log(Level.FINE, "CheckMongoDbConfigValidator - InstallPath: " + configDir);
            String mongoDbConfigYml = configDir + File.separator + "config" + File.separator + "mongodb.conf";
            File mongoDbConfigFile = new File(mongoDbConfigYml);
            if (mongoDbConfigFile.exists()) {
                InputStream inputStream = Files.newInputStream(mongoDbConfigFile.toPath(), new OpenOption[0]);
                Map data = (Map)yaml.load(inputStream);
                Map replication = (Map)data.get("replication");
                if (replication != null) {
                    String replSetNameValue;
                    logger.log(Level.FINE, "CheckMongoDbConfigValidator - replSetName: " + replication.get("replSetName"));
                    if (replication.get("replSetName") != null && !StringUtil.isNullOrBlank(replSetNameValue = replication.get("replSetName").toString())) {
                        String errorMEssage2;
                        String errorMEssage = "No supported configuration. ReplicaSet configuration detected: replication.replSetName=" + replSetNameValue + " Config: " + mongoDbConfigYml;
                        logger.log(Level.SEVERE, prefixLabel + errorMEssage);
                        this.strMessage = errorMEssage2 = "A 'ReplicaSet' configuration was detected in your configuration file " + mongoDbConfigYml + ". Since ReplicaSet mode is not supported, please initiate a manual migration using MongoDB tools.";
                        installData.setVariable(strMessageValue, this.strMessage);
                        return DataValidator.Status.ERROR;
                    }
                }
            } else {
                logger.log(Level.FINE, prefixLabel + mongoDbConfigYml + " doesn't exist");
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, prefixLabel + e);
            e.printStackTrace();
        }
        return DataValidator.Status.OK;
    }
}

