/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.CertificateGeneratorHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class CheckJavaWebKeyPairGeneratorValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckJavaWebKeyPairGeneratorValidator.class.getName());
    private static final String logPrefix = "CheckJavaWebKeyPairGeneratorValidator - ";

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        logger.log(Level.FINE, "CheckJavaWebKeyPairGeneratorValidator - validateData");
        DataValidator.Status result = DataValidator.Status.ERROR;
        try {
            String passPhrase = "";
            if (installData.getVariable("tool.passphrase") != null) {
                passPhrase = installData.getVariable("tool.passphrase");
            }
            File publicKeyFile = File.createTempFile("public", ".pem");
            File privateKeyFile = File.createTempFile("private", ".pem");
            String publicKeyFileName = publicKeyFile.getAbsolutePath();
            String privateKeyFileName = privateKeyFile.getAbsolutePath();
            logger.log(Level.FINE, "CheckJavaWebKeyPairGeneratorValidator - validateData. passPhrase: " + passPhrase + " publicKeyFileName: " + publicKeyFileName + " privateKeyFileName: " + privateKeyFileName);
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "SunRsaSign");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyGen.initialize(2048, random);
            KeyPair pair = keyGen.generateKeyPair();
            CheckJavaWebKeyPairGeneratorValidator.writePublic(publicKeyFileName, pair.getPublic());
            CertificateGeneratorHelper.writePrivateKey(privateKeyFileName, pair, passPhrase.toCharArray());
            result = DataValidator.Status.OK;
            installData.setVariable("tool.temp.publickeyfile", publicKeyFileName);
            installData.setVariable("tool.temp.privatekeyfile", privateKeyFileName);
            logger.log(Level.FINE, "CheckJavaWebKeyPairGeneratorValidator - validateData  OK");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, logPrefix + ex.getMessage());
            logger.log(Level.WARNING, logPrefix + ex.getStackTrace().toString());
            result = DataValidator.Status.ERROR;
        }
        return result;
    }

    @Override
    public String getErrorMessageId() {
        return "keypairgenerationerror";
    }

    @Override
    public String getWarningMessageId() {
        return "keypairgenerationwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    private static void writePublic(String filename, PublicKey publicKey) throws IOException {
        try (FileWriter writer = new FileWriter(filename);
             JcaPEMWriter pemWriter = new JcaPEMWriter(writer);){
            pemWriter.writeObject(publicKey);
            pemWriter.flush();
        }
    }
}

