/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.internal.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateGeneratorHelper {
    private static final Logger logger = Logger.getLogger(CertificateGeneratorHelper.class.getName());
    private static final String prefixLabel = "CertificateGeneratorHelper - ";

    public static String extractCommonName(String name) {
        String[] parts;
        for (String part : parts = name.split(",")) {
            if (!part.trim().startsWith("CN=")) continue;
            return part.trim().substring(3);
        }
        return null;
    }

    public static String getThumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CertificateGeneratorHelper.bytesToHex(digest);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte element : hash) {
            String hex = Integer.toHexString(0xFF & element);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString().toLowerCase();
    }

    public static void writePrivateKey(String filename, KeyPair key, char[] passphrase) throws IOException {
        logger.log(Level.FINE, "CertificateGeneratorHelper - writePrivateKey " + filename);
        Security.addProvider(new BouncyCastleProvider());
        try (FileWriter writer = new FileWriter(filename);
             JcaPEMWriter pemWriter = new JcaPEMWriter(writer);){
            JcePEMEncryptorBuilder jeb = new JcePEMEncryptorBuilder("DES-EDE3-CBC");
            jeb.setProvider("BC");
            if (passphrase != null && passphrase.length > 0) {
                PEMEncryptor pemEncryptor = jeb.build(passphrase);
                pemWriter.writeObject(key, pemEncryptor);
            } else {
                pemWriter.writeObject(key);
            }
            pemWriter.flush();
            logger.log(Level.FINE, "CertificateGeneratorHelper - writePrivateKey " + filename + " completed successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(File[] files, File mergedFile) throws IOException {
        logger.log(Level.FINE, "CertificateGeneratorHelper - mergeFiles");
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(mergedFile);
            for (File f : files) {
                int c;
                in = new FileInputStream(f);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static X500NameBuilder buildX500Name(String country, String organization, String organizationalUnit, String state, String locality, String name, String email) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        if (!StringUtil.isNullOrBlank(country)) {
            builder.addRDN(BCStyle.C, country);
        }
        if (!StringUtil.isNullOrBlank(organization)) {
            builder.addRDN(BCStyle.O, organization);
        }
        if (!StringUtil.isNullOrBlank(organizationalUnit)) {
            builder.addRDN(BCStyle.OU, organizationalUnit);
        }
        if (!StringUtil.isNullOrBlank(state)) {
            builder.addRDN(BCStyle.ST, state);
        }
        if (!StringUtil.isNullOrBlank(locality)) {
            builder.addRDN(BCStyle.L, locality);
        }
        if (!StringUtil.isNullOrBlank(name)) {
            builder.addRDN(BCStyle.CN, name);
        }
        if (!StringUtil.isNullOrBlank(email)) {
            builder.addRDN(BCStyle.E, email);
        }
        return builder;
    }

    public static X509Certificate generateClientV3Certificate(KeyPair pair, String country, String organization, String organizationalUnit, String state, String locality, String name, String email, int validity, X509Certificate certCA, KeyPair pairCA) throws Exception {
        logger.log(Level.FINE, "CertificateGeneratorHelper - generateClientV3Certificate");
        Security.addProvider(new BouncyCastleProvider());
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        if (!StringUtil.isNullOrBlank(country)) {
            builder.addRDN(BCStyle.C, country);
        }
        if (!StringUtil.isNullOrBlank(organization)) {
            builder.addRDN(BCStyle.O, organization);
        }
        if (!StringUtil.isNullOrBlank(organizationalUnit)) {
            builder.addRDN(BCStyle.OU, organizationalUnit);
        }
        if (!StringUtil.isNullOrBlank(state)) {
            builder.addRDN(BCStyle.ST, state);
        }
        if (!StringUtil.isNullOrBlank(locality)) {
            builder.addRDN(BCStyle.L, locality);
        }
        builder.addRDN(BCStyle.CN, "client");
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(6, validity);
        Date notAfter = cal.getTime();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(certCA, serial, notBefore, notAfter, builder.build(), pair.getPublic());
        certGen.addExtension(Extension.basicConstraints, false, new BasicConstraints(false));
        certGen.addExtension(Extension.keyUsage, true, new KeyUsage(152));
        certGen.addExtension(Extension.extendedKeyUsage, true, new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
        return CertificateGeneratorHelper.getX509Certificate(pairCA, certGen);
    }

    private static X509Certificate getX509Certificate(KeyPair pairCA, X509v3CertificateBuilder certGen) throws OperatorCreationException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(new BouncyCastleProvider()).build(pairCA.getPrivate());
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(certGen.build(sigGen));
        cert.checkValidity(new Date());
        cert.verify(pairCA.getPublic());
        return cert;
    }

    public static X509Certificate generateCAV3Certificate(KeyPair pair, String country, String organization, String organizationalUnit, String state, String locality, String name, String email, int validity) throws Exception {
        logger.log(Level.FINE, "CertificateGeneratorHelper - generateCAV3Certificate");
        Security.addProvider(new BouncyCastleProvider());
        X500NameBuilder builder = CertificateGeneratorHelper.buildX500Name(country, organization, organizationalUnit, state, locality, name, email);
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(6, validity);
        Date notAfter = cal.getTime();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(builder.build(), serial, notBefore, notAfter, builder.build(), pair.getPublic());
        certGen.addExtension(Extension.basicConstraints, true, new BasicConstraints(true));
        certGen.addExtension(Extension.keyUsage, true, new KeyUsage(6));
        String dummy = BSIObjectIdentifiers.class.getName();
        dummy = MiscObjectIdentifiers.class.getName();
        return CertificateGeneratorHelper.getX509Certificate(pair, certGen);
    }

    public static X509Certificate generateServerV3Certificate(KeyPair pair, String country, String organization, String organizationalUnit, String state, String locality, String name, String dnsName, String email, int validity, X509Certificate certCA, KeyPair pairCA) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        X500NameBuilder builder = CertificateGeneratorHelper.buildX500Name(country, organization, organizationalUnit, state, locality, name, email);
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(6, validity);
        Date notAfter = cal.getTime();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(certCA, serial, notBefore, notAfter, builder.build(), pair.getPublic());
        certGen.addExtension(Extension.basicConstraints, false, new BasicConstraints(false));
        certGen.addExtension(Extension.keyUsage, true, new KeyUsage(184));
        ArrayList<GeneralName> subjectNames = new ArrayList<GeneralName>();
        subjectNames.add(new GeneralName(2, dnsName));
        certGen.addExtension(Extension.subjectAlternativeName, false, new GeneralNames(subjectNames.toArray(new GeneralName[0])));
        return CertificateGeneratorHelper.getX509Certificate(pairCA, certGen);
    }

    public static KeyPair generateRSAKeyPair(int nSize) throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(nSize, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static String buildP12Certificate(String p12Filename, String serverPassphrase, X509Certificate serverCert, InputStreamReader keyStreamReader, String cname) throws IOException, PEMException, KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException {
        KeyPair pairServer;
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider(bcProvider);
        PEMParser pemParser = new PEMParser(keyStreamReader);
        Object pemKeyPairObject = pemParser.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(bcProvider);
        if (pemKeyPairObject instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)pemKeyPairObject;
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(serverPassphrase.toCharArray());
            pairServer = converter.getKeyPair(ckp.decryptKeyPair(decProv));
        } else {
            PEMKeyPair ukp = (PEMKeyPair)pemKeyPairObject;
            pairServer = converter.getKeyPair(ukp);
        }
        pemParser.close();
        KeyStore keyStore = KeyStore.getInstance("PKCS12", bcProvider);
        keyStore.load(null, null);
        keyStore.setKeyEntry(cname, pairServer.getPrivate(), null, new Certificate[]{serverCert});
        FileOutputStream foStream = new FileOutputStream(p12Filename);
        keyStore.store(foStream, serverPassphrase.toCharArray());
        foStream.close();
        return p12Filename;
    }

    public static PrivateKey extractPrivateKey(String pemKeyFile, String certPassword) throws FileNotFoundException, IOException, PEMException {
        try (InputStream inPemKeyFile = Files.newInputStream(Paths.get(pemKeyFile, new String[0]), new OpenOption[0]);){
            PrivateKey privateKey;
            try (PEMParser pemParser = new PEMParser(new InputStreamReader(inPemKeyFile));){
                Object ukp;
                Object pemObject = pemParser.readObject();
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                if (pemObject instanceof X509CertificateHolder) {
                    throw new PEMException("The pemKeyFile " + pemKeyFile + " does not contain a private key.");
                }
                PrivateKey privateKey2 = null;
                if (pemObject instanceof PEMEncryptedKeyPair) {
                    ukp = (PEMEncryptedKeyPair)pemObject;
                    char[] password = certPassword.toCharArray();
                    logger.log(Level.FINE, "CertificateGeneratorHelper - testMongoDBSSLConnection:  pemkeyFile is encrypted (" + pemKeyFile + "). Need password " + new String(password));
                    PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password);
                    KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(((PEMEncryptedKeyPair)ukp).decryptKeyPair(decryptorProvider));
                    privateKey2 = keyPair.getPrivate();
                } else {
                    ukp = (PEMKeyPair)pemObject;
                    KeyPair kp = converter.getKeyPair((PEMKeyPair)ukp);
                    privateKey2 = kp.getPrivate();
                }
                privateKey = privateKey2;
            }
            return privateKey;
        }
    }
}

