/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.sage.izpack.CReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class CReportWritter {
    private final String pFileNameSuffix;
    private final CReport pReport;
    private final String pUserDir;

    public CReportWritter(CReport aReport) {
        this(aReport, "");
    }

    public CReportWritter(CReport aReport, String aFileNameSuffix) {
        this.pReport = aReport;
        this.pFileNameSuffix = aFileNameSuffix;
        this.pUserDir = System.getProperty("user.dir");
    }

    public String getFileNameSuffix() {
        return this.pFileNameSuffix;
    }

    public File getOutputFile() {
        return new File(this.pUserDir, this.pReport.getFileName(this.getFileNameSuffix()));
    }

    public File write() throws IOException {
        return this.write(this.getOutputFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File write(File aOutputFile) throws IOException {
        if (aOutputFile == null) {
            throw new IllegalArgumentException("the given OutputFile must be not null");
        }
        if (!aOutputFile.getParentFile().exists()) {
            Files.createDirectories(aOutputFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        String wPaylod = this.pReport.toString();
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(aOutputFile), "UTF-8"));){
            out.write(wPaylod);
        }
        return aOutputFile;
    }
}

