/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.event.AbstractInstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.helper.SpecHelper;
import com.sage.izpack.AdxCompHelper;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.ResourcesHelper;
import com.sage.izpack.StringUtil;
import com.sage.izpack.XMLHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AdxCompInstallerListener
extends AbstractInstallerListener
implements CleanupClient {
    private static final Logger logger = Logger.getLogger(AdxCompInstallerListener.class.getName());
    private static final String LogPrefix = "AdxCompInstallerListener - ";
    private static final String SPEC_FILE_NAME = "AdxCompSpec.xml";
    private SpecHelper specHelper = null;
    private Resources resources;
    private final InstallData installData;
    private final UninstallData uninstallData;
    private final RegistryHandler registryHandler;

    public AdxCompInstallerListener(InstallData installData, UninstallData uninstallData, Resources resources, RegistryDefaultHandler handler) {
        this.installData = installData;
        this.uninstallData = uninstallData;
        this.resources = resources;
        this.registryHandler = handler.getInstance();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void beforePacks(List<Pack> packs) {
        super.beforePacks(packs);
        this.specHelper = new SpecHelper(this.resources);
        try {
            this.specHelper.readSpec(SPEC_FILE_NAME);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "AdxCompInstallerListener - Error: " + e.getMessage() + " Stack: " + Arrays.toString(e.getStackTrace()));
        }
        if (InstallationInformationHelper.isReadInformation(this.installData)) {
            if (!InstallationInformationHelper.hasAlreadyReadInformation(this.installData)) {
                InstallationInformationHelper.readInformation(this.installData);
            } else {
                logger.log(Level.FINE, "AdxCompInstallerListener - beforePacks  ReadInstallationInformation: " + this.installData.getInfo().isReadInstallationInformation() + " AlreadyRead: " + InstallationInformationHelper.hasAlreadyReadInformation(this.installData));
            }
        } else {
            logger.log(Level.FINE, "AdxCompInstallerListener - beforePacks  ReadInstallationInformation: " + this.installData.getInfo().isReadInstallationInformation());
        }
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        try {
            AdxCompHelper adxCompHelper = new AdxCompHelper(this.registryHandler, this.installData);
            String adxAdminPath = adxCompHelper.getAdxAdminPath();
            if (StringUtil.isNullOrBlank(adxAdminPath)) {
                throw new Exception(ResourcesHelper.getCustomPropString("adxadminParseError"));
            }
            File dirAdxDir = new File(adxAdminPath);
            if (!dirAdxDir.exists() || !dirAdxDir.isDirectory()) {
                throw new Exception(ResourcesHelper.getCustomPropString("adxadminParseError"));
            }
            File fileAdxinstalls = adxCompHelper.getAdxInstallFile(dirAdxDir);
            logger.log(Level.FINE, "AdxCompInstallerListener - afterPacks  Reading XML file fileAdxinstalls: " + fileAdxinstalls.getAbsolutePath());
            Document adxInstallXmlDoc = this.getXml(fileAdxinstalls);
            IXMLElement elemSpec = this.specHelper.getSpec();
            IXMLElement moduleSpec = elemSpec.getFirstChildNamed("module");
            VariableSubstitutorImpl substitutor = new VariableSubstitutorImpl(this.installData.getVariables());
            String moduleName = substitutor.substitute(moduleSpec.getAttribute("name"), SubstitutionType.TYPE_PLAIN);
            String moduleFamily = substitutor.substitute(moduleSpec.getAttribute("family"), SubstitutionType.TYPE_PLAIN);
            String moduleType = substitutor.substitute(moduleSpec.getAttribute("type"), SubstitutionType.TYPE_PLAIN);
            if (moduleType == null) {
                moduleType = "";
            }
            String version = substitutor.substitute(moduleSpec.getFirstChildNamed("component." + moduleFamily.toLowerCase() + ".version").getContent(), SubstitutionType.TYPE_PLAIN);
            boolean modifyInstallation = ModifyInstallationUtil.get(this.installData);
            logger.log(Level.FINE, "AdxCompInstallerListener - afterPacks  moduleName: " + moduleName + " moduleFamily: " + moduleFamily + " modifyInstallation: " + modifyInstallation);
            Element module = null;
            module = modifyInstallation ? this.modifyXmlModule(adxInstallXmlDoc, moduleName, moduleFamily, moduleType, version) : this.createModule(adxInstallXmlDoc, moduleSpec, substitutor, moduleName, moduleFamily, moduleType);
            Element moduleToAdd = null;
            if (module != null) {
                moduleToAdd = (Element)module.cloneNode(true);
            }
            logger.log(Level.FINE, "AdxCompInstallerListener - afterPacks  saving XML xdoc:" + adxInstallXmlDoc.getDocumentElement().getNodeName());
            AdxCompHelper.saveXml(fileAdxinstalls, adxInstallXmlDoc);
            logger.log(Level.FINE, "AdxCompInstallerListener - afterPacks  XML doc saved");
            logger.log(Level.FINE, "AdxCompInstallerListener - afterPacks  Add data to uninstaller " + moduleToAdd);
            if (moduleToAdd == null) {
                logger.log(Level.FINE, "AdxCompInstallerListener - afterPacks  Error - module is NULL - Cannot add data to uninstaller");
            } else {
                Transformer transformer = AdxCompHelper.getTransformer();
                this.addDataToUninstaller(transformer, adxCompHelper, moduleToAdd);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "AdxCompInstallerListener - Error: " + e.getMessage() + " Stack: " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void addDataToUninstaller(Transformer transformer, AdxCompHelper adxCompHelper, Element module) throws Exception {
        try {
            logger.log(Level.FINE, "AdxCompInstallerListener - Add data AdxCompSpec.xml: " + module);
            this.uninstallData.addAdditionalData("1AdxCompSpec.xml", AdxCompHelper.asByteArray(module));
            this.uninstallData.addAdditionalData(SPEC_FILE_NAME, AdxCompHelper.asString(module));
        }
        catch (TransformerException e) {
            logger.log(Level.SEVERE, "AdxCompInstallerListener - Error: " + e.getMessage() + " Stack: " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void addBuildResourceToUninstallerData(String dataName, File buildFile) throws IOException {
        int aByte;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)buildFile.length());
        BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(buildFile.toPath(), new OpenOption[0]));
        while (-1 != (aByte = bis.read())) {
            bos.write(aByte);
        }
        byte[] content = bos.toByteArray();
        bis.close();
        this.uninstallData.addAdditionalData(dataName, content);
    }

    private void saveElementToFile(Element module, File file, Transformer transformer) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document xDoc = dBuilder.newDocument();
        xDoc.setXmlVersion("1.0");
        xDoc.setXmlStandalone(true);
        Node newnode = xDoc.importNode(module, true);
        xDoc.appendChild(newnode);
        if (!file.exists()) {
            file.createNewFile();
        }
        DOMSource source = new DOMSource(module);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    private Element createModule(Document adxInstallXmlDoc, IXMLElement moduleSpec, VariableSubstitutor substitutor, String moduleName, String moduleFamily, String moduleType) {
        Element moduleToAddOrUpdate = adxInstallXmlDoc.createElement("module");
        moduleToAddOrUpdate.setAttribute("name", moduleName);
        moduleToAddOrUpdate.setAttribute("family", moduleFamily);
        moduleToAddOrUpdate.setAttribute("type", moduleType);
        for (IXMLElement param : moduleSpec.getChildren()) {
            Element xmlParam = adxInstallXmlDoc.createElement(param.getName());
            xmlParam.setTextContent(substitutor.substitute(param.getContent(), SubstitutionType.TYPE_PLAIN));
            moduleToAddOrUpdate.appendChild(xmlParam);
        }
        adxInstallXmlDoc.getDocumentElement().appendChild(moduleToAddOrUpdate);
        return moduleToAddOrUpdate;
    }

    private Element modifyXmlModule(Document xDoc, String moduleName, String moduleFamily, String moduleType, String version) throws Exception {
        String filter;
        XPath xPath = XPathFactory.newInstance().newXPath();
        Element module = (Element)xPath.compile(filter = "/install/module[@name='" + moduleName + "' and @type='" + moduleType + "' and @family='" + moduleFamily + "']").evaluate(xDoc, XPathConstants.NODE);
        if (module == null) {
            logger.log(Level.FINE, "AdxCompInstallerListener - modifyReportModule  name: " + moduleName + " type: " + moduleType + " family: " + moduleFamily + " not found in xmlDocument " + xDoc);
            ResourcesHelper resourceHelper = new ResourcesHelper(this.installData, this.resources);
            throw new Exception(resourceHelper.getCustomString("sectionNotFound", moduleName));
        }
        String statusComponent = "component." + moduleFamily.toLowerCase() + ".installstatus";
        Node status = module.getElementsByTagName(statusComponent).item(0);
        if (status == null) {
            status = module.appendChild(xDoc.createElement(statusComponent));
        }
        status.setTextContent("update");
        String versionComponent = "component." + moduleFamily.toLowerCase() + ".version";
        Node nodeVersion = module.getElementsByTagName(versionComponent).item(0);
        if (nodeVersion == null) {
            nodeVersion = module.appendChild(xDoc.createElement(versionComponent));
        }
        nodeVersion.setTextContent(version);
        logger.log(Level.FINE, "AdxCompInstallerListener - modifyXmlModule  saving XML '" + versionComponent + "': " + version);
        return module;
    }

    private Document getXml(File fileAdxinstalls) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document xdoc = null;
        if (!fileAdxinstalls.exists()) {
            logger.log(Level.FINE, "AdxCompInstallerListener - getXml  Creating file " + fileAdxinstalls.getAbsolutePath());
            fileAdxinstalls.createNewFile();
            if (OsVersion.IS_UNIX) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                perms.add(PosixFilePermission.GROUP_READ);
                perms.add(PosixFilePermission.GROUP_WRITE);
                perms.add(PosixFilePermission.OTHERS_READ);
                perms.add(PosixFilePermission.OTHERS_WRITE);
                Files.setPosixFilePermissions(fileAdxinstalls.toPath(), perms);
            }
            xdoc = dBuilder.newDocument();
            xdoc.setXmlVersion("1.0");
            xdoc.setXmlStandalone(true);
            Element racine = xdoc.createElement("install");
            xdoc.appendChild(racine);
        } else {
            logger.log(Level.FINE, "AdxCompInstallerListener - getXml  Parsing file " + fileAdxinstalls.getAbsolutePath());
            xdoc = dBuilder.parse(fileAdxinstalls);
            xdoc.getDocumentElement().normalize();
        }
        XMLHelper.cleanEmptyTextNodes(xdoc);
        logger.log(Level.FINE, "AdxCompInstallerListener - getXml  Xml file: " + fileAdxinstalls.getPath() + ". Root element: " + xdoc.getDocumentElement().getNodeName());
        return xdoc;
    }
}

