/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.rule;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldProcessor;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.rule.FieldLayout;
import com.izforge.izpack.panels.userinput.field.rule.RuleFieldConfig;
import com.izforge.izpack.panels.userinput.field.rule.RuleFormat;
import java.util.List;
import java.util.logging.Logger;

public class RuleField
extends Field {
    private final FieldLayout layout;
    private final RuleFormat format;
    private final String separator;
    private String[] initialValues;
    private String[] defaultValues;
    private static final Logger logger = Logger.getLogger(RuleField.class.getName());

    public RuleField(RuleFieldConfig config, InstallData installData) {
        super(config, installData);
        this.layout = new FieldLayout(config.getLayout());
        this.format = config.getFormat();
        this.separator = config.getSeparator();
    }

    public FieldLayout getLayout() {
        return this.layout;
    }

    @Override
    public String getInitialValue() {
        ValidationStatus status;
        String result = null;
        String value = super.getInitialValue();
        this.initialValues = value != null ? ((status = this.validateFormatted(value)).isValid() ? status.getValues() : null) : null;
        if (!this.getInstallData().getVariables().isBlockedVariableName(this.getVariable())) {
            result = this.getInstallData().getVariables().replace(this.format(this.initialValues));
        }
        if (result == null && (result = this.getValue()) == null) {
            result = this.getDefaultValue();
        }
        return result;
    }

    @Override
    public String getDefaultValue() {
        ValidationStatus status;
        String value = super.getDefaultValue();
        this.defaultValues = value != null ? ((status = this.validateFormatted(value)).isValid() ? status.getValues() : null) : null;
        if (this.defaultValues != null) {
            return this.getInstallData().getVariables().replace(this.format(this.defaultValues));
        }
        return null;
    }

    public String format(String[] values) {
        String result;
        if (values == null) {
            return null;
        }
        switch (this.format) {
            case PLAIN_STRING: {
                result = this.formatPlain(values);
                break;
            }
            case SPECIAL_SEPARATOR: {
                result = this.formatSpecialSeparator(values);
                break;
            }
            case PROCESSED: {
                result = this.formatProcessed(values);
                break;
            }
            default: {
                result = this.formatDisplay(values);
            }
        }
        return result;
    }

    @Override
    public ValidationStatus validate(String ... values) {
        String value = this.formatDisplay(values);
        ValidationStatus status = this.validateFormatted(value);
        if (status.isValid()) {
            status = super.validate(value);
        }
        return status;
    }

    public ValidationStatus validateFormatted(String value) {
        ValidationStatus status = this.layout.validate(value);
        return status;
    }

    private String formatDisplay(String[] values) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (Object item : this.layout.getLayout()) {
            if (item instanceof String) {
                result.append(item);
                continue;
            }
            if (index >= values.length) continue;
            result.append(values[index]);
            ++index;
        }
        return result.toString();
    }

    private String formatPlain(String[] values) {
        StringBuilder result = new StringBuilder();
        for (String value : values) {
            result.append(value);
        }
        return result.toString();
    }

    private String formatSpecialSeparator(String[] values) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                result.append(this.separator);
            }
            result.append(values[i]);
        }
        return result.toString();
    }

    private String formatProcessed(String[] values) {
        String result = null;
        List<FieldProcessor> processors = this.getProcessors();
        if (processors != null && !processors.isEmpty()) {
            for (FieldProcessor processor : processors) {
                if (result == null) {
                    result = processor.process(values);
                    continue;
                }
                result = processor.process(result);
            }
        } else {
            logger.warning("Rule field has " + (Object)((Object)this.format) + " type, but no processor is registered");
            result = this.formatDisplay(values);
        }
        return result;
    }
}

