/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.rules.logic.AndCondition;
import com.izforge.izpack.core.rules.logic.NotCondition;
import com.izforge.izpack.core.rules.logic.OrCondition;
import com.izforge.izpack.core.rules.process.PackSelectionCondition;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ElementReader {
    private final Config config;

    public ElementReader(Config config) {
        this.config = config;
    }

    public List<String> getPacks(IXMLElement element) {
        List<IXMLElement> elements = element.getChildrenNamed("createForPack");
        return this.getNames(elements);
    }

    public List<String> getUnselectedPacks(IXMLElement element) {
        List<IXMLElement> elements = element.getChildrenNamed("createForUnselectedPack");
        return this.getNames(elements);
    }

    public List<OsModel> getOsModels(IXMLElement element) {
        return OsConstraintHelper.getOsList(element);
    }

    public Condition getComplexPanelCondition(IXMLElement spec, final PlatformModelMatcher matcher, InstallData installData, RulesEngine rules) {
        Condition newCondition;
        OrCondition orCondition;
        List<String> forPacks = this.getPacks(spec);
        List<String> forUnselectedPacks = this.getUnselectedPacks(spec);
        final List<OsModel> forOs = this.getOsModels(spec);
        HashSet<Condition> globalConditions = new HashSet<Condition>();
        if (!forOs.isEmpty()) {
            Condition osMatcherCondition = new Condition(){
                private static final long serialVersionUID = 1L;

                @Override
                public void readFromXML(IXMLElement xmlcondition) throws Exception {
                }

                @Override
                public void makeXMLData(IXMLElement conditionRoot) {
                }

                @Override
                public boolean isTrue() {
                    return matcher.matchesCurrentPlatform(forOs);
                }

                @Override
                public Set<String> getVarRefs() {
                    return new HashSet<String>(0);
                }
            };
            osMatcherCondition.setId(osMatcherCondition.toString());
            globalConditions.add(osMatcherCondition);
        }
        if (!forPacks.isEmpty()) {
            if (forPacks.size() > 1) {
                orCondition = new OrCondition(rules);
                orCondition.setId(orCondition.toString());
                for (String packName : forPacks) {
                    orCondition.addOperands(ElementReader.createPackSelectionCondition(installData, packName));
                }
                newCondition = orCondition;
            } else {
                newCondition = ElementReader.createPackSelectionCondition(installData, forPacks.iterator().next());
            }
            globalConditions.add(newCondition);
        }
        if (!forUnselectedPacks.isEmpty()) {
            if (forUnselectedPacks.size() > 1) {
                orCondition = new OrCondition(rules);
                orCondition.setId(orCondition.toString());
                for (String packName : forUnselectedPacks) {
                    orCondition.addOperands(ElementReader.createPackUnselectionCondition(installData, rules, packName));
                }
                newCondition = orCondition;
            } else {
                newCondition = ElementReader.createPackUnselectionCondition(installData, rules, forUnselectedPacks.iterator().next());
            }
            globalConditions.add(newCondition);
        }
        if (!globalConditions.isEmpty()) {
            if (globalConditions.size() > 1) {
                AndCondition andCondition = new AndCondition(rules);
                andCondition.setId(andCondition.toString());
                for (Condition globalCondition : globalConditions) {
                    andCondition.addOperands(globalCondition);
                }
                newCondition = andCondition;
            } else {
                newCondition = (Condition)globalConditions.iterator().next();
            }
            return newCondition;
        }
        return null;
    }

    private static Condition createPackSelectionCondition(InstallData installData, String packName) {
        PackSelectionCondition packSelectionCondition = new PackSelectionCondition();
        packSelectionCondition.setId(packSelectionCondition.toString());
        packSelectionCondition.setInstallData(installData);
        packSelectionCondition.setPack(packName);
        return packSelectionCondition;
    }

    private static Condition createPackUnselectionCondition(InstallData installData, RulesEngine rules, String packName) {
        PackSelectionCondition packSelectionCondition = new PackSelectionCondition();
        packSelectionCondition.setId(packSelectionCondition.toString());
        packSelectionCondition.setInstallData(installData);
        packSelectionCondition.setPack(packName);
        NotCondition packNotSelectedCondition = new NotCondition(rules);
        packNotSelectedCondition.setId(packNotSelectedCondition.toString());
        packNotSelectedCondition.setInstallData(installData);
        packNotSelectedCondition.setReferencedCondition(packSelectionCondition);
        return packNotSelectedCondition;
    }

    protected Config getConfig() {
        return this.config;
    }

    private List<String> getNames(List<IXMLElement> elements) {
        ArrayList<String> result = new ArrayList<String>();
        for (IXMLElement element : elements) {
            result.add(this.config.getAttribute(element, "name"));
        }
        return result;
    }
}

