/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.handler;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.AbstractPrompt;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.util.Console;
import java.util.HashMap;
import java.util.Map;

public class ConsolePrompt
extends AbstractPrompt {
    private final Console console;
    private final InstallData installData;

    public ConsolePrompt(Console console, InstallData installData) {
        this.console = console;
        this.installData = installData;
    }

    @Override
    public void message(Prompt.Type type, String title, String message, Throwable throwable) {
        if (title != null) {
            this.console.println(title + ":");
        }
        this.console.println(message);
        if (throwable != null) {
            this.console.println(ConsolePrompt.getDetails(throwable));
        }
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options, Prompt.Option defaultOption) {
        Prompt.Option result;
        Messages messages = this.installData.getMessages();
        if (messages == null) {
            messages = new Messages(){

                @Override
                public String get(String id, Object ... args) {
                    return "";
                }

                @Override
                public void add(Messages messages) {
                }

                @Override
                public Map<String, String> getMessages() {
                    return new HashMap<String, String>();
                }

                @Override
                public Messages newMessages(String name) {
                    return null;
                }
            };
        }
        String okCancelPrompt = messages.get("ConsolePrompt.okCancel", new Object[0]);
        String yesNoPrompt = messages.get("ConsolePrompt.yesNo", new Object[0]);
        String yesNoCancelPrompt = messages.get("ConsolePrompt.yesNoCancel", new Object[0]);
        String ok = messages.get("ConsolePrompt.ok", new Object[0]);
        String cancel = messages.get("ConsolePrompt.cancel", new Object[0]);
        String yes = messages.get("ConsolePrompt.yes", new Object[0]);
        String no = messages.get("ConsolePrompt.no", new Object[0]);
        this.console.printMessageBox(title, message);
        if (options == Prompt.Options.OK_CANCEL) {
            String defaultValue = defaultOption != null && defaultOption == Prompt.Option.OK ? ok : cancel;
            String selected = this.console.prompt(okCancelPrompt, new String[]{ok, cancel}, defaultValue);
            result = ok.equals(selected) ? Prompt.Option.OK : Prompt.Option.CANCEL;
        } else if (options == Prompt.Options.YES_NO_CANCEL) {
            String selected;
            String defaultValue = cancel;
            if (defaultOption != null) {
                if (defaultOption == Prompt.Option.YES) {
                    defaultValue = yes;
                } else if (defaultOption == Prompt.Option.NO) {
                    defaultValue = no;
                }
            }
            result = yes.equals(selected = this.console.prompt(yesNoCancelPrompt, new String[]{yes, no, cancel}, defaultValue)) ? Prompt.Option.YES : (no.equals(selected) ? Prompt.Option.NO : Prompt.Option.CANCEL);
        } else {
            String selected;
            String defaultValue = no;
            if (defaultOption != null && defaultOption == Prompt.Option.YES) {
                defaultValue = yes;
            }
            result = yes.equals(selected = this.console.prompt(yesNoPrompt, new String[]{yes, no}, defaultValue)) ? Prompt.Option.YES : Prompt.Option.NO;
        }
        return result;
    }
}

