/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum PackCompression {
    DEFAULT("default"),
    GZIP("gz"),
    BZIP2("bzip2"),
    XZ("xz"),
    LZMA("lzma"),
    DEFLATE("deflate");

    private static Map<String, PackCompression> lookupByName;
    private String name;

    private PackCompression(String name) {
        this.name = name;
    }

    public String toName() {
        return this.name;
    }

    public static PackCompression byName(String name) {
        if (name != null && lookupByName.containsKey(name)) {
            return lookupByName.get(name);
        }
        return null;
    }

    static {
        lookupByName = new HashMap<String, PackCompression>();
        for (PackCompression compression : EnumSet.allOf(PackCompression.class)) {
            lookupByName.put(compression.toName(), compression);
        }
    }
}

