/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.InstallPathHelper;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.panels.target.TargetConsolePanel;
import com.izforge.izpack.util.Console;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetNewConsolePanel
extends TargetConsolePanel {
    private static Logger logger = Logger.getLogger(TargetNewConsolePanel.class.getName());
    private static final String logPrefix = "TargetNewConsolePanel - ";

    public TargetNewConsolePanel(PanelView<ConsolePanel> panel, InstallData installData, Resources resources, Prompt prompt) {
        super(panel, installData, prompt);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        logger.log(Level.FINE, "TargetNewConsolePanel - run  properties: " + properties);
        boolean result = false;
        String path = properties.getProperty("INSTALL_PATH");
        if (StringUtil.isNullOrBlank(path)) {
            System.err.println("TargetNewConsolePanel - Missing mandatory target path!");
        } else {
            path = installData.getVariables().replace(path);
            installData.setInstallPath(path);
            result = true;
        }
        return result;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        String path;
        this.printHeadLine(installData, console);
        String introText = this.getI18nStringForClass("intro", "TargetPanel", installData);
        if (introText != null) {
            console.println(introText);
            console.println();
        }
        String defaultPath = InstallPathHelper.getPath(installData);
        PathInputBase.setInstallData(installData);
        if (defaultPath == null) {
            defaultPath = "";
        }
        boolean modifyinstallation = ModifyInstallationUtil.get(installData);
        while ((path = console.promptLocation(this.getMessage("info") + " [" + defaultPath + "] ", defaultPath)) != null) {
            path = installData.getVariables().replace(path);
            String normalizedPath = PathInputBase.normalizePath(path);
            File pathFile = new File(normalizedPath);
            if (StringUtil.isNullOrBlank(path)) {
                console.println("You have not specified a target location ! ");
                continue;
            }
            if (modifyinstallation && InstallationInformationHelper.isIncompatibleInstallation(normalizedPath, InstallationInformationHelper.isReadInformation(installData))) {
                console.println(this.getMessage("incompatibleInstallation"));
                continue;
            }
            if (!PathInputBase.isWritable(normalizedPath)) {
                console.println(this.getMessage("notwritable"));
                continue;
            }
            if (!normalizedPath.isEmpty()) {
                if (pathFile.isFile()) {
                    console.println(this.getMessage("isfile"));
                    continue;
                }
                if (pathFile.exists()) {
                    if (!this.checkOverwrite(pathFile, console)) {
                        continue;
                    }
                } else {
                    if (!this.checkCreateDirectory(pathFile, console)) continue;
                    if (!installData.getPlatform().isValidDirectoryPath(pathFile)) {
                        console.println(this.getMessage("syntax.error"));
                        continue;
                    }
                }
                installData.setInstallPath(normalizedPath);
                return this.promptEndPanel(installData, console);
            }
            return super.run(installData, console);
        }
        return false;
    }
}

