/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.sage.izpack.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceWinHelper {
    private static final Logger logger = Logger.getLogger(ServiceWinHelper.class.getName());
    private static final String prefixLabel = "ServiceWinHelper - ";

    public static String getServiceUser(String serviceName) {
        String result = null;
        if (StringUtil.isNullOrBlank(serviceName)) {
            logger.log(Level.WARNING, "ServiceWinHelper - getServiceUser(ServiceName=NULL). Cannot check service.");
            return result;
        }
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("sc", "qc", serviceName);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("SERVICE_START_NAME")) continue;
                String userName = line.substring(line.indexOf(58) + 1);
                userName = StringUtil.trim(userName, new char[]{' ', '\"', '\\', '/'});
                logger.log(Level.WARNING, "ServiceWinHelper - UserName: '" + userName + "'");
                result = userName;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean doesServiceExist(String serviceName) {
        if (StringUtil.isNullOrBlank(serviceName)) {
            logger.log(Level.WARNING, "ServiceWinHelper - doesServiceExist(ServiceName=NULL). Cannot check service.");
            return false;
        }
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("sc", "query", serviceName);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("SERVICE_NAME")) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

