/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bson.Document;

public class CheckSyracuseMongoDBDataValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckSyracuseMongoDBDataValidator.class.getName());
    private static final String prefixLabel = "CheckSyracuseMongoDBDataValidator - ";
    private InstallData installData = null;
    private final String varShowLicensePath = "syracuse.service.showlicensepath";

    private static boolean isSupportedVersion(String version) {
        Integer majorVersion = 0;
        try {
            String[] verStr1 = version.split("\\.");
            if (StringUtil.isNullOrBlank(verStr1[0])) {
                verStr1[0] = "0";
            }
            majorVersion = Integer.valueOf(verStr1[0]);
        }
        catch (NumberFormatException e) {
            majorVersion = 0;
        }
        return majorVersion >= 3;
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        this.installData = installData;
        DataValidator.Status bReturn = DataValidator.Status.OK;
        try {
            Boolean modifyInstallation = ModifyInstallationUtil.get(installData);
            String hostName = new String(installData.getVariable("mongodb.service.hostname"));
            String hostPort = installData.getVariable("mongodb.service.port");
            boolean sslEnabled = "true".equalsIgnoreCase(installData.getVariable("mongodb.ssl.enable"));
            String mongoCertPassword = new String(installData.getVariable("mongodb.url.password"));
            String certFile = installData.getVariable("mongodb.ssl.client.certfile");
            String pemKeyFile = installData.getVariable("mongodb.ssl.client.pemkeyfile");
            String pemcaFile = installData.getVariable("mongodb.ssl.pemcafile");
            if (!sslEnabled) {
                bReturn = this.testMongoDBConnection(modifyInstallation, hostName, hostPort);
            } else {
                bReturn = this.testMongoDBSSLConnection(modifyInstallation, hostName, hostPort, certFile, pemKeyFile, pemcaFile, mongoCertPassword);
                if (bReturn.equals((Object)DataValidator.Status.ERROR) && hostName.indexOf(".") < 0) {
                    logger.log(Level.WARNING, "The hostname '" + hostName + "' is not a FQDN (Fully Qualified Domain Name). Please try with the absolute domain name.");
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, prefixLabel + ex.getMessage());
            logger.log(Level.WARNING, prefixLabel + ex.getStackTrace());
            bReturn = DataValidator.Status.ERROR;
        }
        return bReturn;
    }

    private DataValidator.Status testMongoDBSSLConnection(Boolean modifyInstallation, String hostName, String hostPort, String certFile, String pemKeyFile, String pemCAFile, String mongoCertPassword) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, FileNotFoundException, PEMException {
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBSSLConnection: " + hostName + " certFile: " + certFile + " pemkeyFile:" + pemKeyFile);
        Security.addProvider(new BouncyCastleProvider());
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> chainArray = new ArrayList<X509Certificate>();
        if (!StringUtil.isNullOrBlank(pemCAFile)) {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            InputStream inPemCaFile = Files.newInputStream(Paths.get(pemCAFile, new String[0]), new OpenOption[0]);
            X509Certificate caCert = (X509Certificate)factory.generateCertificate(inPemCaFile);
            trustStore.setCertificateEntry("root", caCert);
            File trustStoreFile = File.createTempFile("tru", null);
            FileOutputStream trustStoreFileOutputStream = new FileOutputStream(trustStoreFile);
            trustStore.store(trustStoreFileOutputStream, "truststore".toCharArray());
            trustStoreFileOutputStream.close();
            chainArray.add(caCert);
            System.setProperty("javax.net.ssl.trustStore", trustStoreFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", "truststore");
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        InputStream inPemCertFile = Files.newInputStream(Paths.get(certFile, new String[0]), new OpenOption[0]);
        X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
        PrivateKey privateKey = this.extractPrivateKey(hostName, pemKeyFile, mongoCertPassword);
        keyStore.setCertificateEntry(cert.getSubjectX500Principal().toString(), cert);
        chainArray.add(cert);
        Certificate[] chain = new X509Certificate[chainArray.size()];
        chain[0] = cert;
        if (chainArray.size() > 1) {
            chain[1] = (X509Certificate)chainArray.get(0);
        }
        keyStore.setKeyEntry("importkey", privateKey, "keystore".toCharArray(), chain);
        File keyStoreFile = File.createTempFile("key", null);
        FileOutputStream keyStoreFileOutputStream = new FileOutputStream(keyStoreFile);
        keyStore.store(keyStoreFileOutputStream, "keystore".toCharArray());
        keyStoreFileOutputStream.close();
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBSSLConnection: 'javax.net.ssl.keyStore' set to '" + keyStoreFile.getAbsolutePath() + "'");
        System.setProperty("javax.net.ssl.keyStore", keyStoreFile.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStorePassword", "keystore");
        System.setProperty("jdk.tls.trustNameService", "true");
        MongoClientOptions.Builder opts = MongoClientOptions.builder();
        opts.sslEnabled(true);
        opts.serverSelectionTimeout(60000);
        ServerAddress address = new ServerAddress(hostName, Integer.parseInt(hostPort));
        MongoClient mongoClient = new MongoClient(address, opts.build());
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - Init MongoDb SSL connection: " + address.toString() + " opt: " + opts.toString());
        String version = mongoClient.getDatabase("test").runCommand(new Document("buildInfo", 1)).getString("version");
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - MongoDb SSL connection: " + address.toString() + " version: " + version);
        DataValidator.Status bReturn = this.checkSyracuseDb(modifyInstallation, address, mongoClient, version);
        mongoClient.close();
        return bReturn;
    }

    private PrivateKey extractPrivateKey(String hostName, String pemKeyFile, String mongoCertPassword) throws FileNotFoundException, IOException, PEMException {
        InputStream inPemKeyFile = Files.newInputStream(Paths.get(pemKeyFile, new String[0]), new OpenOption[0]);
        PEMParser pemParser = new PEMParser(new InputStreamReader(inPemKeyFile));
        Object object = pemParser.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PrivateKey privateKey = null;
        if (object instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair ukp = (PEMEncryptedKeyPair)object;
            char[] password = mongoCertPassword.toCharArray();
            logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBSSLConnection: " + hostName + " pemkeyFile is encrypted (" + pemKeyFile + "). Need password " + password);
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password);
            KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(ukp.decryptKeyPair(decryptorProvider));
            privateKey = keyPair.getPrivate();
        } else {
            PEMKeyPair ukp = (PEMKeyPair)object;
            KeyPair kp = converter.getKeyPair(ukp);
            privateKey = kp.getPrivate();
        }
        pemParser.close();
        return privateKey;
    }

    private DataValidator.Status testMongoDBConnection(Boolean modifyInstallation, String hostName, String hostPort) {
        ServerAddress address = new ServerAddress(hostName, Integer.parseInt(hostPort));
        MongoClient mongoClient = new MongoClient(address);
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBConnection: " + address.toString());
        String version = mongoClient.getDatabase("test").runCommand(new Document("buildInfo", 1)).getString("version");
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBConnection: " + address.toString() + " version: " + version);
        DataValidator.Status result = this.checkSyracuseDb(modifyInstallation, address, mongoClient, version);
        mongoClient.close();
        return result;
    }

    private DataValidator.Status checkSyracuseDb(Boolean modifyInstallation, ServerAddress address, MongoClient mongoClient, String version) {
        DataValidator.Status result = DataValidator.Status.WARNING;
        if (!CheckSyracuseMongoDBDataValidator.isSupportedVersion(version)) {
            logger.log(Level.WARNING, "CheckSyracuseMongoDBDataValidator - MongoDb version not supported: " + version);
            result = DataValidator.Status.ERROR;
        } else {
            MongoIterable<String> listDb = mongoClient.listDatabaseNames();
            logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - MongoDb db list: " + listDb + "  version: " + version);
            boolean syracuseExists = false;
            for (String database : listDb) {
                if (!database.equalsIgnoreCase("syracuse")) continue;
                syracuseExists = true;
                break;
            }
            result = this.getContextResult(modifyInstallation, address, syracuseExists);
            if (syracuseExists) {
                this.checkLicenseCollection(mongoClient, this.installData);
            } else {
                this.installData.setVariable("syracuse.service.showlicensepath", "true");
                logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - checkSyracuseDb - 'syracuse' doesn't exist - set syracuse.service.showlicensepath=" + this.installData.getVariable("syracuse.service.showlicensepath"));
            }
        }
        return result;
    }

    private DataValidator.Status getContextResult(Boolean modifyInstallation, ServerAddress address, boolean syracuseExists) {
        DataValidator.Status bReturn;
        if (syracuseExists) {
            logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - MongoDb 'syracuse' db exists on " + address.toString());
            bReturn = modifyInstallation.booleanValue() ? DataValidator.Status.OK : DataValidator.Status.WARNING;
        } else {
            logger.log(Level.WARNING, "CheckSyracuseMongoDBDataValidator - MongoDb 'syracuse' db not found on " + address.toString());
            bReturn = modifyInstallation != false ? DataValidator.Status.ERROR : DataValidator.Status.OK;
        }
        return bReturn;
    }

    private void checkLicenseCollection(MongoClient mongoClient, InstallData installData) {
        MongoDatabase syrDatabase = mongoClient.getDatabase("syracuse");
        MongoCollection<Document> collection = null;
        if (syrDatabase != null) {
            collection = syrDatabase.getCollection("license");
        }
        long documentsCount = 0L;
        if (collection != null) {
            documentsCount = collection.countDocuments();
        }
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - checkLicenseCollection - MongoDb 'syracuse.license' count: " + documentsCount);
        if (documentsCount > 0L) {
            if (installData != null) {
                logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - checkLicenseCollection - MongoDb 'syracuse.license' count: " + documentsCount + " '" + "syracuse.service.showlicensepath" + "' set to 'false'");
                installData.setVariable("syracuse.service.showlicensepath", "false");
            } else {
                logger.log(Level.SEVERE, "CheckSyracuseMongoDBDataValidator - checkLicenseCollection - Cannot update variable 'syracuse.service.showlicensepath' - installData=null");
            }
        } else {
            logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - checkLicenseCollection - MongoDb 'syracuse.license' count: " + documentsCount + " '" + "syracuse.service.showlicensepath" + "' set to 'true'");
            installData.setVariable("syracuse.service.showlicensepath", "true");
        }
    }

    @Override
    public String getErrorMessageId() {
        return "mongodbtesterror";
    }

    @Override
    public String getWarningMessageId() {
        return "mongodbtestwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return Boolean.TRUE;
    }
}

