/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.CertificateGeneratorHelper;
import com.sage.izpack.CertificateVerifier;
import com.sage.izpack.CheckMongoDbCertificateP12Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class CheckMongoDbCertificateDataValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        Security.addProvider(new BouncyCastleProvider());
        String certificateDirectory = installData.getVariable("mongodb.dir.certs");
        String hostname = installData.getVariable("HOST_NAME");
        String fieldPemCertFile = installData.getVariable("mongodb.ssl.certfile");
        String fieldPemKeyFile = installData.getVariable("mongodb.ssl.pemkeyfile");
        String fieldPemKeyPassword = installData.getVariable("mongodb.ssl.pemkeypassword");
        String fieldPemCaFile = installData.getVariable("mongodb.ssl.pemcafile");
        boolean useCaFile = false;
        try {
            InputStream inPemKeyFile = Files.newInputStream(Paths.get(fieldPemKeyFile, new String[0]), new OpenOption[0]);
            InputStream inPemCertFile = Files.newInputStream(Paths.get(fieldPemCertFile, new String[0]), new OpenOption[0]);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
            if (fieldPemCaFile != null && !fieldPemCaFile.trim().isEmpty()) {
                InputStream inPemCaFile = Files.newInputStream(Paths.get(fieldPemCaFile, new String[0]), new OpenOption[0]);
                Collection<? extends Certificate> certCAChain = factory.generateCertificates(inPemCaFile);
                certCAChain.add(cert);
                PKIXCertPathBuilderResult verifiedCertChain = CertificateVerifier.verifyCertificate(cert, new HashSet<Certificate>(certCAChain));
                installData.setVariable("mongodb.ssl.usecafile", "true");
                useCaFile = true;
            }
            KeyPair kp = this.buildKeyPair(fieldPemKeyPassword, inPemKeyFile);
            byte[] input = "1234567890ABCDEF".getBytes();
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, cert.getPublicKey());
            byte[] cipherText = cipher.doFinal(input);
            cipher.init(2, kp.getPrivate());
            byte[] decrypted = cipher.doFinal(cipherText);
            if (Arrays.equals(decrypted, input)) {
                File certpath = new File(certificateDirectory);
                if (!certpath.exists()) {
                    certpath.mkdirs();
                }
                File pemKeyFile = new File(certificateDirectory + File.separator + hostname + ".pem");
                File certFile = new File(fieldPemCertFile);
                File privKeyFile = new File(fieldPemKeyFile);
                File destCertFile = new File(certificateDirectory + File.separator + hostname + ".crt");
                Files.copy(certFile.toPath(), destCertFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File destKeyFile = new File(certificateDirectory + File.separator + hostname + ".key");
                Files.copy(privKeyFile.toPath(), destKeyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                CertificateGeneratorHelper.mergeFiles(new File[]{certFile, privKeyFile}, pemKeyFile);
                if (useCaFile) {
                    File caPath = new File(fieldPemCaFile);
                    File certCaPath = new File(certificateDirectory + File.separator + "ca.cacrt");
                    Files.copy(caPath.toPath(), certCaPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                CheckMongoDbCertificateP12Validator.writeP12File(fieldPemKeyPassword, installData);
                installData.setVariable("mongodb.ssl.alreadydone", "true");
                return DataValidator.Status.OK;
            }
            this.strMessage = "Unknow error";
            installData.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            installData.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    private KeyPair buildKeyPair(String fieldPemKeyPassword, InputStream inPemKeyFile) throws IOException, PEMException {
        KeyPair kp;
        PEMParser pemParser = new PEMParser(new InputStreamReader(inPemKeyFile));
        Object object = pemParser.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        if (object instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(fieldPemKeyPassword.toCharArray());
            kp = converter.getKeyPair(ckp.decryptKeyPair(decProv));
        } else {
            PEMKeyPair ukp = (PEMKeyPair)object;
            kp = converter.getKeyPair(ukp);
        }
        pemParser.close();
        return kp;
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

