/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.InsertRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.operation.MixedBulkWriteOperation;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

final class LegacyMixedBulkWriteOperation
implements WriteOperation<WriteConcernResult> {
    private final WriteConcern writeConcern;
    private final MongoNamespace namespace;
    private final List<? extends WriteRequest> writeRequests;
    private final WriteRequest.Type type;
    private final boolean ordered;
    private final boolean retryWrites;
    private Boolean bypassDocumentValidation;

    static LegacyMixedBulkWriteOperation createBulkWriteOperationForInsert(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, boolean retryWrites, List<InsertRequest> insertRequests) {
        return new LegacyMixedBulkWriteOperation(namespace, ordered, writeConcern, retryWrites, insertRequests, WriteRequest.Type.INSERT);
    }

    static LegacyMixedBulkWriteOperation createBulkWriteOperationForUpdate(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, boolean retryWrites, List<UpdateRequest> updateRequests) {
        Assertions.assertTrue(updateRequests.stream().allMatch(updateRequest -> updateRequest.getType() == WriteRequest.Type.UPDATE));
        return new LegacyMixedBulkWriteOperation(namespace, ordered, writeConcern, retryWrites, updateRequests, WriteRequest.Type.UPDATE);
    }

    static LegacyMixedBulkWriteOperation createBulkWriteOperationForReplace(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, boolean retryWrites, List<UpdateRequest> replaceRequests) {
        Assertions.assertTrue(replaceRequests.stream().allMatch(updateRequest -> updateRequest.getType() == WriteRequest.Type.REPLACE));
        return new LegacyMixedBulkWriteOperation(namespace, ordered, writeConcern, retryWrites, replaceRequests, WriteRequest.Type.REPLACE);
    }

    static LegacyMixedBulkWriteOperation createBulkWriteOperationForDelete(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, boolean retryWrites, List<DeleteRequest> deleteRequests) {
        return new LegacyMixedBulkWriteOperation(namespace, ordered, writeConcern, retryWrites, deleteRequests, WriteRequest.Type.DELETE);
    }

    private LegacyMixedBulkWriteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, boolean retryWrites, List<? extends WriteRequest> writeRequests, WriteRequest.Type type) {
        Assertions.isTrueArgument("writeRequests not empty", !writeRequests.isEmpty());
        this.writeRequests = Assertions.notNull("writeRequests", writeRequests);
        this.type = type;
        this.ordered = ordered;
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
    }

    List<? extends WriteRequest> getWriteRequests() {
        return this.writeRequests;
    }

    LegacyMixedBulkWriteOperation bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public WriteConcernResult execute(WriteBinding binding) {
        try {
            BulkWriteResult result = new MixedBulkWriteOperation(this.namespace, this.writeRequests, this.ordered, this.writeConcern, this.retryWrites).bypassDocumentValidation(this.bypassDocumentValidation).execute(binding);
            if (result.wasAcknowledged()) {
                return this.translateBulkWriteResult(result);
            }
            return WriteConcernResult.unacknowledged();
        }
        catch (MongoBulkWriteException e) {
            throw this.convertBulkWriteException(e);
        }
    }

    private MongoException convertBulkWriteException(MongoBulkWriteException e) {
        BulkWriteError lastError = this.getLastError(e);
        if (lastError != null) {
            if (ErrorCategory.fromErrorCode(lastError.getCode()) == ErrorCategory.DUPLICATE_KEY) {
                return new DuplicateKeyException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
            }
            return new WriteConcernException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
        }
        return new WriteConcernException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
    }

    private BsonDocument manufactureGetLastErrorResponse(MongoBulkWriteException e) {
        BulkWriteError lastError;
        BsonDocument response = new BsonDocument();
        this.addBulkWriteResultToResponse(e.getWriteResult(), response);
        WriteConcernError writeConcernError = e.getWriteConcernError();
        if (writeConcernError != null) {
            response.putAll(writeConcernError.getDetails());
        }
        if ((lastError = this.getLastError(e)) != null) {
            response.put("err", new BsonString(lastError.getMessage()));
            response.put("code", new BsonInt32(lastError.getCode()));
            response.putAll(lastError.getDetails());
        } else if (writeConcernError != null) {
            response.put("err", new BsonString(writeConcernError.getMessage()));
            response.put("code", new BsonInt32(writeConcernError.getCode()));
        }
        return response;
    }

    private void addBulkWriteResultToResponse(BulkWriteResult bulkWriteResult, BsonDocument response) {
        response.put("ok", new BsonInt32(1));
        if (this.type == WriteRequest.Type.INSERT) {
            response.put("n", new BsonInt32(0));
        } else if (this.type == WriteRequest.Type.DELETE) {
            response.put("n", new BsonInt32(bulkWriteResult.getDeletedCount()));
        } else if (this.type == WriteRequest.Type.UPDATE || this.type == WriteRequest.Type.REPLACE) {
            response.put("n", new BsonInt32(bulkWriteResult.getMatchedCount() + bulkWriteResult.getUpserts().size()));
            if (bulkWriteResult.getUpserts().isEmpty()) {
                response.put("updatedExisting", BsonBoolean.TRUE);
            } else {
                response.put("updatedExisting", BsonBoolean.FALSE);
                response.put("upserted", bulkWriteResult.getUpserts().get(0).getId());
            }
        }
    }

    private WriteConcernResult translateBulkWriteResult(BulkWriteResult bulkWriteResult) {
        return WriteConcernResult.acknowledged(this.getCount(bulkWriteResult), this.getUpdatedExisting(bulkWriteResult), bulkWriteResult.getUpserts().isEmpty() ? null : bulkWriteResult.getUpserts().get(0).getId());
    }

    private int getCount(BulkWriteResult bulkWriteResult) {
        int count = 0;
        if (this.type == WriteRequest.Type.UPDATE || this.type == WriteRequest.Type.REPLACE) {
            count = bulkWriteResult.getMatchedCount() + bulkWriteResult.getUpserts().size();
        } else if (this.type == WriteRequest.Type.DELETE) {
            count = bulkWriteResult.getDeletedCount();
        }
        return count;
    }

    private boolean getUpdatedExisting(BulkWriteResult bulkWriteResult) {
        if (this.type == WriteRequest.Type.UPDATE || this.type == WriteRequest.Type.REPLACE) {
            return bulkWriteResult.getMatchedCount() > 0;
        }
        return false;
    }

    @Nullable
    private BulkWriteError getLastError(MongoBulkWriteException e) {
        return e.getWriteErrors().isEmpty() ? null : e.getWriteErrors().get(e.getWriteErrors().size() - 1);
    }
}

