/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.lang.Nullable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.kotlin.ArrayCodecProvider;
import org.bson.codecs.kotlin.DataClassCodecProvider;
import org.bson.codecs.kotlinx.KotlinSerializerCodecProvider;
import org.bson.internal.ProvidersCodecRegistry;

public class KotlinCodecProvider
implements CodecProvider {
    @Nullable
    private static final CodecProvider KOTLIN_SERIALIZABLE_CODEC_PROVIDER;
    @Nullable
    private static final CodecProvider DATA_CLASS_CODEC_PROVIDER;

    @Override
    @Nullable
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.get(clazz, Collections.emptyList(), registry);
    }

    @Override
    @Nullable
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        Codec<T> codec = null;
        if (KOTLIN_SERIALIZABLE_CODEC_PROVIDER != null) {
            codec = ProvidersCodecRegistry.getFromCodecProvider(KOTLIN_SERIALIZABLE_CODEC_PROVIDER, clazz, typeArguments, registry);
        }
        if (codec == null && DATA_CLASS_CODEC_PROVIDER != null) {
            codec = ProvidersCodecRegistry.getFromCodecProvider(DATA_CLASS_CODEC_PROVIDER, clazz, typeArguments, registry);
        }
        return codec;
    }

    static {
        Object possibleCodecProvider = null;
        try {
            Class.forName("org.bson.codecs.kotlinx.KotlinSerializerCodecProvider");
            possibleCodecProvider = new KotlinSerializerCodecProvider();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        KOTLIN_SERIALIZABLE_CODEC_PROVIDER = possibleCodecProvider;
        possibleCodecProvider = null;
        try {
            Class.forName("org.bson.codecs.kotlin.DataClassCodecProvider");
            possibleCodecProvider = CodecRegistries.fromProviders(new CodecProvider[]{new ArrayCodecProvider(), new DataClassCodecProvider()});
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DATA_CLASS_CODEC_PROVIDER = possibleCodecProvider;
    }
}

