/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBCursorCleaner;
import com.mongodb.MongoClient;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Java9DBCursorCleaner
extends DBCursorCleaner {
    private static final Object CLEANER;
    private static final Method REGISTER_METHOD;
    private static final Method CLEAN_METHOD;
    private final CleanerState cleanerState;
    private final Object cleanable;

    Java9DBCursorCleaner(MongoClient mongoClient, MongoNamespace namespace, ServerCursor serverCursor) {
        this.cleanerState = new CleanerState(mongoClient, namespace, serverCursor);
        try {
            this.cleanable = REGISTER_METHOD.invoke(CLEANER, this, this.cleanerState);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MongoInternalException("Unexpected exception", e);
        }
    }

    @Override
    void clearCursor() {
        this.cleanerState.clear();
        try {
            CLEAN_METHOD.invoke(this.cleanable, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MongoInternalException("Unexpected exception", e);
        }
    }

    static {
        try {
            Class<?> cleanerClass = Class.forName("java.lang.ref.Cleaner");
            CLEANER = cleanerClass.getMethod("create", new Class[0]).invoke(null, new Object[0]);
            REGISTER_METHOD = cleanerClass.getMethod("register", Object.class, Runnable.class);
            CLEAN_METHOD = Class.forName("java.lang.ref.Cleaner$Cleanable").getMethod("clean", new Class[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MongoInternalException("Unexpected exception", e);
        }
    }

    private static class CleanerState
    implements Runnable {
        private final MongoClient mongoClient;
        private final MongoNamespace namespace;
        private volatile ServerCursor serverCursor;

        CleanerState(MongoClient mongoClient, MongoNamespace namespace, ServerCursor serverCursor) {
            this.mongoClient = Assertions.assertNotNull(mongoClient);
            this.namespace = Assertions.assertNotNull(namespace);
            this.serverCursor = Assertions.assertNotNull(serverCursor);
        }

        @Override
        public void run() {
            if (this.serverCursor != null) {
                this.mongoClient.addOrphanedCursor(this.serverCursor, this.namespace);
            }
        }

        public void clear() {
            this.serverCursor = null;
        }
    }
}

