/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBCursorCleaner;
import com.mongodb.MongoClient;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;

final class Java8DBCursorCleaner
extends DBCursorCleaner {
    private final MongoClient mongoClient;
    private final MongoNamespace namespace;
    private volatile ServerCursor serverCursor;

    Java8DBCursorCleaner(MongoClient mongoClient, MongoNamespace namespace, ServerCursor serverCursor) {
        this.mongoClient = Assertions.assertNotNull(mongoClient);
        this.namespace = Assertions.assertNotNull(namespace);
        this.serverCursor = Assertions.assertNotNull(serverCursor);
    }

    @Override
    void clearCursor() {
        this.serverCursor = null;
    }

    protected void finalize() {
        if (this.serverCursor != null) {
            this.mongoClient.addOrphanedCursor(this.serverCursor, this.namespace);
        }
    }
}

