/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.unpacker.AbstractPackResources;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;

public class ConsolePackResources
extends AbstractPackResources {
    private static final Logger logger = Logger.getLogger(ConsolePackResources.class.getName());

    public ConsolePackResources(Resources resources, InstallData installData) {
        super(resources, installData);
    }

    @Override
    protected InputStream getWebPackStream(String name, String webDirURL) {
        InputStream result;
        String packFileName;
        File packLocalFile;
        InstallData installData = this.getInstallData();
        String baseName = installData.getInfo().getInstallerBase();
        File installerDir = new File(baseName).getParentFile();
        if (baseName.contains("/")) {
            baseName = baseName.substring(baseName.lastIndexOf(47));
        }
        if ((packLocalFile = new File(installerDir, packFileName = baseName + ".pack-" + name + ".jar")).exists() && packLocalFile.canRead()) {
            logger.info("Found local pack " + packLocalFile.getAbsolutePath());
        } else {
            String packURL = webDirURL + "/" + packFileName.replace(" ", "%20");
            String tempFolder = IoHelper.translatePath(installData.getInfo().getUninstallerPath() + "/IzpackWebTemp", installData.getVariables());
            File tempDir = new File(tempFolder);
            tempDir.mkdirs();
            try {
                logger.info("Downloading remote pack " + packURL);
                packLocalFile = File.createTempFile("izpacktempfile", "jar", new File(tempFolder));
                InputStream webStream = new URL(packURL).openStream();
                ConsolePackResources.write(webStream, packLocalFile);
            }
            catch (IOException exception) {
                throw new ResourceException("Failed to read pack", exception);
            }
        }
        try {
            URL url = new URL("jar:" + packLocalFile.toURI().toURL() + "!/packs/pack-" + name);
            result = url.openStream();
        }
        catch (IOException exception) {
            throw new ResourceException("Failed to read pack", exception);
        }
        return result;
    }

    private static void write(InputStream input, File file) throws IOException {
        FileOutputStream output = new FileOutputStream(file);
        int letter = 0;
        byte[] buffer = new byte[1024];
        while ((letter = input.read(buffer)) != -1) {
            ((OutputStream)output).write(buffer, 0, letter);
        }
        output.flush();
        ((OutputStream)output).close();
    }
}

