/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xml;

import com.izforge.izpack.adaptator.IXMLElement;
import org.w3c.dom.Node;

public class XMLHelper {
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String ON = "ON";
    public static final String OFF = "OFF";
    public static final String _1 = "1";
    public static final String _0 = "0";

    public static boolean attributeIsTrue(IXMLElement element, String name) {
        String value = element.getAttribute(name, "").toUpperCase();
        if (value.equals(YES)) {
            return true;
        }
        if (value.equals(TRUE)) {
            return true;
        }
        if (value.equals(ON)) {
            return true;
        }
        return value.equals(_1);
    }

    public static boolean attributeIsFalse(IXMLElement element, String name) {
        String value = element.getAttribute(name, "").toUpperCase();
        if (value.equals(NO)) {
            return true;
        }
        if (value.equals(FALSE)) {
            return true;
        }
        if (value.equals(OFF)) {
            return true;
        }
        return value.equals(_0);
    }

    public static void cleanEmptyTextNodes(Node parentNode) {
        boolean removeEmptyTextNodes = false;
        for (Node childNode = parentNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            removeEmptyTextNodes |= XMLHelper.checkNodeTypes(childNode);
        }
        if (removeEmptyTextNodes) {
            XMLHelper.removeEmptyTextNodes(parentNode);
        }
    }

    private static void removeEmptyTextNodes(Node parentNode) {
        Node childNode = parentNode.getFirstChild();
        while (childNode != null) {
            boolean containsOnlyWhitespace;
            Node nextChild = childNode.getNextSibling();
            short nodeType = childNode.getNodeType();
            if (nodeType == 3 && (containsOnlyWhitespace = childNode.getNodeValue().trim().isEmpty())) {
                parentNode.removeChild(childNode);
            }
            childNode = nextChild;
        }
    }

    private static boolean checkNodeTypes(Node childNode) {
        short nodeType = childNode.getNodeType();
        if (nodeType == 1) {
            XMLHelper.cleanEmptyTextNodes(childNode);
        }
        return nodeType == 1 || nodeType == 4 || nodeType == 8;
    }
}

