/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.sage;

import com.izforge.izpack.util.sage.CReport;
import com.izforge.izpack.util.sage.CTextLineUtils;

public class CWordList {
    private final String pKindOfWord;
    private final CReport pReport;
    private final String[] pWordList;
    private String friendlySuccessMesg;
    private String friendlyWarningMesg;

    public CWordList(CReport aReport, String aKindOfWord, String[] aWordList) {
        this.pReport = aReport;
        this.pKindOfWord = aKindOfWord;
        this.pWordList = aWordList;
    }

    public void SetFriendlySuccessMsg(String friendlyMsg) {
        this.friendlySuccessMesg = friendlyMsg;
    }

    public void SetFriendlyWarningMsg(String friendlyMsg) {
        this.friendlyWarningMesg = friendlyMsg;
    }

    public String dumpAsNumberedList() {
        StringBuilder wDump = new StringBuilder();
        int wIdx = 0;
        for (String wWord : this.pWordList) {
            wDump.append(CTextLineUtils.toInsecable(String.format("\n- %s(%2d)=[%s]", this.pKindOfWord, ++wIdx, wWord)));
        }
        return wDump.toString();
    }

    public boolean isAllWordsIn(String aLines, EKindOfFinding aKindOfFinding) {
        if (aLines == null || aLines.isEmpty()) {
            throw new RuntimeException(String.format("Unable to find a '%s' in a null or empty set of Lines", this.pKindOfWord));
        }
        boolean wAllFound = true;
        for (String wWord : this.pWordList) {
            if (EKindOfFinding.AT_THE_BEGINING_OF_A_LINE == aKindOfFinding) {
                if (!this.oneOfTheLinesStartsWith(aLines, wWord)) {
                    if (this.friendlyWarningMesg != null && !this.friendlyWarningMesg.isEmpty()) {
                        this.pReport.appendError(String.format(this.friendlyWarningMesg, wWord));
                    } else {
                        this.pReport.appendError(String.format("The %s [%s] has NOT been found.", this.pKindOfWord, wWord));
                    }
                    wAllFound = false;
                    continue;
                }
                if (this.friendlySuccessMesg != null && !this.friendlySuccessMesg.isEmpty()) {
                    this.pReport.appendSuccess(String.format(this.friendlySuccessMesg, wWord));
                    continue;
                }
                this.pReport.appendSuccess(String.format("The %s [%s] has been found.", this.pKindOfWord, wWord));
                continue;
            }
            if (!aLines.contains(wWord)) {
                this.pReport.appendError(String.format("The %s [%s] is not present", this.pKindOfWord, wWord));
                wAllFound = false;
                continue;
            }
            this.pReport.appendSuccess(String.format("The %s [%s] is present", this.pKindOfWord, wWord));
        }
        return wAllFound;
    }

    private boolean oneOfTheLinesStartsWith(String aText, String aWord) {
        for (String wLines : aText.split("\n")) {
            if (wLines == null || wLines.isEmpty() || !wLines.trim().startsWith(aWord)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.pWordList.length;
    }

    public String toString() {
        return String.format("KindOfWord=[%s]:%s", this.pKindOfWord, this.dumpAsNumberedList());
    }

    public static enum EKindOfFinding {
        AT_THE_BEGINING_OF_A_LINE,
        IN_ALL_THE_TEXT;

    }
}

