/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.sage;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.sage.CLoggerUtils;
import com.izforge.izpack.util.sage.CReport;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class CAbstractOsInfosfinder {
    private static final String PREREQUISITES_SCRIPT = "PrerequisitesControlScript";
    protected static final String PLATFORM = OsVersion.IS_UNIX ? "unix" : "windows";
    protected final CReport aReport;
    protected AutomatedInstallData aData;

    public CAbstractOsInfosfinder(CReport pReport, AutomatedInstallData pData) {
        this.aReport = pReport;
        this.aData = pData;
    }

    public String getResourceName() {
        return PREREQUISITES_SCRIPT;
    }

    public String execute() throws Exception {
        CLoggerUtils.logInfo("begin");
        String wShellScriptName = this.getResourceName();
        Debug.log("execute " + wShellScriptName);
        this.aReport.appendStep("Exec ScriptName=[%s]", wShellScriptName);
        String wOutput = this.loadPredefinedFunctions(this.getResourceName());
        this.aReport.appendOutput(wOutput);
        return wOutput;
    }

    private String loadPredefinedFunctions(String resource) throws Exception {
        String result = "";
        SpecHelper spechelper = new SpecHelper();
        String ext = OsVersion.IS_UNIX ? ".sh" : ".cmd";
        InputStream stream = spechelper.getResource(resource);
        if (stream != null) {
            int len;
            InputStream substitutedStream = spechelper.substituteVariables(stream, new VariableSubstitutor(this.aData.getVariables()));
            File tempFile = File.createTempFile(resource, ext);
            FileOutputStream fos = null;
            tempFile.deleteOnExit();
            fos = new FileOutputStream(tempFile);
            this.aReport.append("ScriptLocation=[%s]", tempFile.getPath());
            byte[] buffer = new byte[1024];
            while ((len = substitutedStream.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            substitutedStream.close();
            fos.flush();
            fos.close();
            ProcessBuilder procBuilder = null;
            procBuilder = OsVersion.IS_UNIX ? new ProcessBuilder(System.getenv("SHELL"), tempFile.getAbsolutePath()) : new ProcessBuilder("cmd.exe", "/C", tempFile.getAbsolutePath());
            Debug.log("Launching " + tempFile.getAbsolutePath());
            Process p = procBuilder.start();
            BufferedInputStream errorOutput = new BufferedInputStream(p.getErrorStream(), 10000);
            BufferedInputStream consoleOutput = new BufferedInputStream(p.getInputStream(), 10000);
            Debug.log("ErrorOutput:");
            BufferedReader br = new BufferedReader(new InputStreamReader(errorOutput));
            String readErrorOutput = br.readLine();
            while (readErrorOutput != null) {
                Debug.log(readErrorOutput);
                readErrorOutput = br.readLine();
                result = result + readErrorOutput + "\r\n";
            }
            Debug.log("ConsoleOutput:");
            BufferedReader readerOutput = new BufferedReader(new InputStreamReader(consoleOutput));
            String readOutput = readerOutput.readLine();
            while (readOutput != null) {
                Debug.log(readOutput);
                readOutput = readerOutput.readLine();
                result = result + readOutput + "\r\n";
            }
            int exitCode = p.waitFor();
            Debug.log("ExitCode: " + exitCode);
            this.aReport.append("exitCode: ", exitCode);
            if (exitCode != 0) {
                Debug.log("Command failed: " + procBuilder.command());
                throw new InstallerException(resource + " return code is " + exitCode + " !");
            }
        }
        return result;
    }
}

