/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Properties;

public class X3WebServerValidator
implements Validator {
    @Override
    public boolean validate(ProcessingClient client, AutomatedInstallData adata) {
        boolean bReturn = false;
        try {
            String x3webPath = client.getFieldContents(0).trim();
            File X3WebInstallInformation = new File(x3webPath + "/" + ".installationinformation");
            if (X3WebInstallInformation.exists() && X3WebInstallInformation.isFile()) {
                FileInputStream fin = new FileInputStream(X3WebInstallInformation);
                ObjectInputStream oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                Properties variables = (Properties)oin.readObject();
                String strDataPath = variables.getProperty("webserver.dir.data");
                if (strDataPath != null) {
                    adata.setVariable("syracuse.certificate.x3webserverdata", strDataPath + File.separator + "KEYSTORE" + File.separator + "SYRACUSE");
                    bReturn = true;
                }
            }
        }
        catch (Exception ex) {
            Debug.trace(ex.getMessage());
            bReturn = false;
        }
        return bReturn;
    }

    public String getErrorMessageId() {
        return "x3webserverpath";
    }

    public String getWarningMessageId() {
        return null;
    }

    public boolean getDefaultAnswer() {
        return false;
    }
}

