/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X3NodeIdentifierValidator
implements Validator {
    private static final String X3FAMILY = "X3FAMILY";
    private static final String X3TYPE = "X3TYPE";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(ProcessingClient client, AutomatedInstallData adata) {
        if (!client.hasParams()) {
            return false;
        }
        Map<String, String> params = client.getValidatorParams();
        String nodename = client.getText();
        String strX3Type = null;
        String strX3Family = null;
        if (!params.containsKey(X3FAMILY)) {
            return false;
        }
        strX3Family = params.get(X3FAMILY);
        if (params.containsKey(X3TYPE)) {
            strX3Type = params.get(X3TYPE);
        }
        String strAdxAdminPath = "";
        try {
            Node module;
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh != null) {
                rh.verify(adata);
                if (!rh.adxadminProductRegistered()) return false;
                String keyName = "SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN";
                int oldVal = rh.getRoot();
                rh.setRoot(-2147483646);
                if (!rh.valueExist(keyName, "ADXDIR")) {
                    keyName = "SOFTWARE\\Wow6432Node\\Adonix\\X3RUNTIME\\ADXADMIN";
                }
                if (!rh.valueExist(keyName, "ADXDIR")) {
                    rh.setRoot(oldVal);
                    return false;
                }
                strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
                rh.setRoot(oldVal);
            } else if (OsVersion.IS_UNIX) {
                File adxadmFile = new File("/sage/adxadm");
                if (!adxadmFile.exists() && !(adxadmFile = new File("/adonix/adxadm")).exists()) {
                    return false;
                }
                FileReader readerAdxAdmFile = new FileReader(adxadmFile);
                BufferedReader buffread = new BufferedReader(readerAdxAdmFile);
                strAdxAdminPath = buffread.readLine();
            }
            if (strAdxAdminPath == null || "".equals(strAdxAdminPath)) {
                return false;
            }
            File dirAdxDir = new File(strAdxAdminPath);
            if (!dirAdxDir.exists() || !dirAdxDir.isDirectory()) {
                return false;
            }
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(dirAdxDir.getAbsolutePath());
            strBuilder.append(File.separator);
            strBuilder.append("inst");
            File fileAdxinstalls = new File(strBuilder.toString());
            if (!fileAdxinstalls.exists() || !fileAdxinstalls.isDirectory()) {
                return false;
            }
            strBuilder.append(File.separator);
            strBuilder.append("adxinstalls.xml");
            fileAdxinstalls = new File(strBuilder.toString());
            if (!fileAdxinstalls.exists()) {
                return true;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document xdoc = null;
            Object xmodule = null;
            xdoc = dBuilder.parse(fileAdxinstalls);
            Element xmlinstall = xdoc.getDocumentElement();
            XPath xPath = XPathFactory.newInstance().newXPath();
            String strPath = "/install/module[@name='" + nodename + "' and @family='" + strX3Family + "'";
            if (strX3Type != null && !"".equals(strX3Type)) {
                strPath = strPath + " and @type='" + strX3Type + "'";
            }
            if ((module = (Node)xPath.compile(strPath = strPath + "]").evaluate(xdoc, XPathConstants.NODE)) != null) return false;
            return true;
        }
        catch (Exception ex) {
            Debug.log(ex);
        }
        return false;
    }
}

