/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.MoreAdvApi32;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;

public class UpdatePassphraseValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";
    public static final int STILL_ACTIVE = 259;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        DataValidator.Status sreturn = DataValidator.Status.OK;
        boolean updateMode = false;
        boolean createCertificate = true;
        if (adata.getVariable("MODIFY.IZPACK.INSTALL") != null) {
            updateMode = adata.getVariable("MODIFY.IZPACK.INSTALL").equalsIgnoreCase("true");
        }
        if (adata.getVariable("syracuse.certificate.install") != null) {
            createCertificate = adata.getVariable("syracuse.certificate.install").equalsIgnoreCase("true");
        }
        if (OsVersion.IS_WINDOWS && !updateMode) {
            String userName = adata.getVariable("syracuse.winservice.username");
            String passWord = adata.getVariable("syracuse.winservice.password");
            String strDomain = ".";
            if (userName.contains("\\")) {
                strDomain = userName.substring(0, userName.indexOf("\\"));
                userName = userName.substring(userName.indexOf("\\") + 1);
            } else if (userName.contains("@")) {
                strDomain = null;
            }
            WString nullW = null;
            WinBase.PROCESS_INFORMATION processInformation = new WinBase.PROCESS_INFORMATION();
            WinBase.STARTUPINFO startupInfo = new WinBase.STARTUPINFO();
            startupInfo.dwFlags = 1;
            startupInfo.wShowWindow = new WinDef.WORD(0L);
            String strPassphrasePath = adata.getVariable("INSTALL_PATH") + "\\syracuse";
            String strCertsDir = adata.getVariable("syracuse.dir.certs");
            Boolean certCreate = Boolean.valueOf(adata.getVariable("syracuse.certificate.install"));
            String strHOST_NAME = adata.getVariable("HOST_NAME").toLowerCase();
            String strServerPassphrase = adata.getVariable("syracuse.certificate.serverpassphrase");
            try {
                String strPassPhraseFile;
                File oldPassphrase;
                if (!certCreate.booleanValue()) {
                    strServerPassphrase = adata.getVariable("syracuse.ssl.pemkeypassword");
                }
                if ((oldPassphrase = new File(strPassPhraseFile = strCertsDir + "\\" + strHOST_NAME + "\\" + strHOST_NAME + ".pwd")).exists() && !oldPassphrase.delete()) {
                    throw new Exception(strPassPhraseFile);
                }
                String hexstrServerPassphrase = StringTool.asciiToHex(strServerPassphrase);
                File tempFile = new File(strPassphrasePath + "\\tmpcmd.cmd");
                tempFile.deleteOnExit();
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(tempFile), true);
                printWriter.println("ping -n 5 127.0.0.1>NUL");
                printWriter.println("\"" + strPassphrasePath + "\\passphrasehex.cmd\" \"" + hexstrServerPassphrase + "\" 1>out.log 2>err.log");
                printWriter.println("if errorlevel 1 exit /B 1");
                printWriter.close();
                String strcommand = "/C /E:ON \"" + tempFile.getCanonicalPath() + "\" \"" + strServerPassphrase + "\"";
                boolean result2 = MoreAdvApi32.INSTANCE.CreateProcessWithLogonW(new WString(userName), strDomain == null ? nullW : new WString(strDomain), new WString(passWord), 1, nullW, new WString(tempFile.getCanonicalPath()), 1024, null, new WString(strPassphrasePath), startupInfo, processInformation);
                if (!result2) {
                    int error = Kernel32.INSTANCE.GetLastError();
                    this.strMessage = "OS error #" + error + " - " + Kernel32Util.formatMessageFromLastErrorCode(error);
                    adata.setVariable(strMessageValue, this.strMessage);
                    return DataValidator.Status.WARNING;
                }
                boolean bFinished = false;
                int loop = 0;
                while (!bFinished) {
                    IntByReference lpExitCode = new IntByReference(9999);
                    result2 = Kernel32.INSTANCE.GetExitCodeProcess(processInformation.hProcess, lpExitCode);
                    if (!result2) {
                        int error = Kernel32.INSTANCE.GetLastError();
                        this.strMessage = "OS error #" + error + " - " + Kernel32Util.formatMessageFromLastErrorCode(error);
                        adata.setVariable(strMessageValue, this.strMessage);
                        return DataValidator.Status.WARNING;
                    }
                    if (lpExitCode.getValue() != 259) {
                        int nexitCode = lpExitCode.getValue();
                        bFinished = true;
                    }
                    if (++loop > 30) {
                        this.strMessage = "Error # Could not update passphrase ! (" + strPassPhraseFile + ")";
                        adata.setVariable(strMessageValue, this.strMessage);
                        return DataValidator.Status.WARNING;
                    }
                    Thread.sleep(1000L);
                }
                String strErr = new String(Files.readAllBytes(Paths.get(strPassphrasePath + "\\err.log", new String[0])));
                File strOutFile = new File(strPassphrasePath + "\\out.log");
                File strErrFile = new File(strPassphrasePath + "\\err.log");
                strOutFile.delete();
                strErrFile.delete();
                if (!oldPassphrase.exists()) {
                    this.strMessage = "Error # Passphrase update failed ! (" + strPassPhraseFile + ")\r\n" + strErr;
                    adata.setVariable(strMessageValue, this.strMessage);
                    return DataValidator.Status.WARNING;
                }
            }
            catch (Exception ex) {
                Debug.trace(ex);
                Debug.trace(ex.getMessage());
                this.strMessage = "OS error #" + ex.getMessage();
                adata.setVariable(strMessageValue, this.strMessage);
                sreturn = DataValidator.Status.WARNING;
            }
        }
        return sreturn;
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

